/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.jibx.binding.model.BindingHolder;
import org.jibx.binding.model.BuiltinFormats;
import org.jibx.binding.model.CollectionElement;
import org.jibx.binding.model.ContainerElementBase;
import org.jibx.binding.model.ElementBase;
import org.jibx.binding.model.FormatElement;
import org.jibx.binding.model.MappingElement;
import org.jibx.binding.model.MappingElementBase;
import org.jibx.binding.model.StructureElement;
import org.jibx.binding.model.StructureElementBase;
import org.jibx.binding.model.ValueElement;
import org.jibx.runtime.QName;
import org.jibx.runtime.Utility;
import org.jibx.schema.SchemaUtils;
import org.jibx.schema.codegen.BlockBuilder;
import org.jibx.schema.codegen.CastBuilder;
import org.jibx.schema.codegen.ClassBuilder;
import org.jibx.schema.codegen.ClassHolder;
import org.jibx.schema.codegen.DefinitionItem;
import org.jibx.schema.codegen.EnumerationClassHolder;
import org.jibx.schema.codegen.ExpressionBuilderBase;
import org.jibx.schema.codegen.FieldBuilder;
import org.jibx.schema.codegen.GroupItem;
import org.jibx.schema.codegen.InfixExpressionBuilder;
import org.jibx.schema.codegen.InvocationBuilder;
import org.jibx.schema.codegen.Item;
import org.jibx.schema.codegen.JavaType;
import org.jibx.schema.codegen.MethodBuilder;
import org.jibx.schema.codegen.NameUtils;
import org.jibx.schema.codegen.NewArrayBuilder;
import org.jibx.schema.codegen.NewInstanceBuilder;
import org.jibx.schema.codegen.PackageHolder;
import org.jibx.schema.codegen.ReferenceItem;
import org.jibx.schema.codegen.SourceBuilder;
import org.jibx.schema.codegen.TypeData;
import org.jibx.schema.codegen.ValueItem;
import org.jibx.schema.codegen.extend.ClassDecorator;
import org.jibx.schema.codegen.extend.NameConverter;
import org.jibx.schema.elements.AnnotatedBase;
import org.jibx.schema.elements.AttributeElement;
import org.jibx.schema.elements.CommonCompositorBase;
import org.jibx.schema.elements.ComplexTypeElement;
import org.jibx.schema.elements.ElementElement;
import org.jibx.schema.elements.SchemaBase;
import org.jibx.util.Types;
import org.jibx.util.UniqueNameSet;

public class StructureClassHolder
extends ClassHolder {
    private static final String LIST_DESERIALIZE_PREFIX = "deserialize";
    private static final String LIST_SERIALIZE_PREFIX = "serialize";
    private static final Logger s_logger = Logger.getLogger((String)StructureClassHolder.class.getName());
    private static final Map s_formatMap = new HashMap();
    private boolean m_collectionPresent;
    private ClassHolder.ParentNode m_dataRoot;
    private ContainerElementBase m_bindingElement;
    protected UniqueNameSet m_selectSet;

    public StructureClassHolder(String name, String base, PackageHolder pack, BindingHolder holder, NameConverter nconv, ClassDecorator[] decorators, boolean inner) {
        super(name, base, pack, holder, nconv, decorators, inner, false);
    }

    private StructureClassHolder(String name, StructureClassHolder context) {
        super(name, context, false);
    }

    private void addToTree(GroupItem struct, String supertext, ClassHolder.ParentNode parent, BindingHolder bindhold) {
        if (struct.getChildCount() > 1) {
            supertext = null;
        }
        for (Item item = struct.getFirstChild(); item != null; item = item.getNext()) {
            String curtext;
            if (item.isIgnored()) {
                new ClassHolder.ParentNode((GroupItem)item, parent);
                continue;
            }
            String doctext = supertext;
            if (item.isTopmost() && (curtext = this.extractDocumentation(item.getSchemaComponent())) != null) {
                doctext = curtext;
            }
            if (item.isCollection()) {
                this.m_collectionPresent = true;
            }
            if (item instanceof GroupItem) {
                ClassHolder child;
                GroupItem group = (GroupItem)item;
                if (group.isInline()) {
                    if (group.getChildCount() > 0) {
                        ClassHolder.ParentNode into = parent;
                        AnnotatedBase comp = item.getSchemaComponent();
                        if (comp instanceof CommonCompositorBase) {
                            if (comp.type() == 0 || comp.type() == 7 || comp.getParent() instanceof CommonCompositorBase) {
                                into = new ClassHolder.ParentNode(group, parent);
                                into.setDocumentation(doctext);
                                doctext = null;
                            }
                        } else if (struct.getSchemaComponent() != comp && group.getFirstChild().getSchemaComponent() != comp) {
                            into = new ClassHolder.ParentNode(group, parent);
                            into.setDocumentation(doctext);
                            doctext = null;
                        }
                        this.addToTree(group, doctext, into, bindhold);
                        into.adjustName();
                        continue;
                    }
                    new ClassHolder.ParentNode(group, parent);
                    if (!s_logger.isDebugEnabled()) continue;
                    s_logger.debug((Object)("Added empty parent for " + SchemaUtils.describeComponent((SchemaBase)group.getSchemaComponent())));
                    continue;
                }
                String text = group.getEffectiveClassName();
                if (this.m_useInnerClasses) {
                    if (this.m_nameSet.contains(text)) {
                        StructureClassHolder outer = this;
                        while (outer != null) {
                            if (outer.getName().equals(text)) {
                                text = text + "Inner";
                                break;
                            }
                            outer = (StructureClassHolder)outer.m_outerClass;
                        }
                    }
                    text = this.m_nameSet.add(text);
                    child = group.isEnumeration() ? new EnumerationClassHolder(text, this) : new StructureClassHolder(text, this);
                    this.m_inners.add((Object)child);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Added inner class " + child.getFullName()));
                    }
                } else {
                    String fullname = this.m_baseName + text;
                    child = this.m_package.addClass(fullname, this.m_baseName, this.m_nameConverter, this.m_decorators, group.isEnumeration(), this.m_holder);
                    this.m_importsTracker.addImport(child.getFullName(), true);
                    text = child.getName();
                    if (group.isEnumeration()) {
                        FormatElement format = new FormatElement();
                        format.setTypeName(child.getBindingName());
                        ((EnumerationClassHolder)child).setBinding(format);
                        bindhold.addFormat(format);
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Added derived class " + child.getFullName()));
                    }
                }
                if (!group.isFixedClassName()) {
                    group.setClassName(text);
                }
                group.setGenerateClass(child);
                ClassHolder.LeafNode value = new ClassHolder.LeafNode(group, parent);
                value.setDocumentation(doctext);
                if (!group.isEnumeration()) {
                    group.convertTypeReference();
                    this.importValueType(value);
                }
                child.buildDataStructure(group, bindhold);
                continue;
            }
            ClassHolder.LeafNode value = new ClassHolder.LeafNode(item, parent);
            value.setDocumentation(doctext);
            this.importValueType(value);
        }
    }

    @Override
    public void buildDataStructure(GroupItem group, BindingHolder bindhold) {
        super.buildDataStructure(group, bindhold);
        if (group.isEnumeration()) {
            throw new IllegalArgumentException("Internal error - group is an enumeration");
        }
        this.m_dataRoot = new ClassHolder.ParentNode(group, null);
        this.m_dataRoot.setDocumentation(this.extractDocumentation(group.getSchemaComponent()));
        this.addToTree(group, null, this.m_dataRoot, bindhold);
        int reptype = this.getSchemaCustom().getRepeatType();
        if ((reptype == 1 || reptype == 2) && this.m_collectionPresent) {
            this.m_importsTracker.addImport("java.util.List", false);
            this.m_importsTracker.addImport(this.m_listImplClass, false);
        }
    }

    public void setBinding(ContainerElementBase container) {
        this.m_bindingElement = container;
    }

    private void addInnerFormats(MappingElementBase mapping) {
        for (int i = 0; i < this.m_inners.size(); ++i) {
            ClassHolder inner = (ClassHolder)this.m_inners.get(i);
            if (inner.isSimpleValue()) {
                FormatElement format = new FormatElement();
                format.setTypeName(inner.getBindingName());
                ((EnumerationClassHolder)inner).setBinding(format);
                mapping.addTopChild((Object)format);
                continue;
            }
            ((StructureClassHolder)inner).addInnerFormats(mapping);
        }
    }

    private void addFixedNames(ClassHolder.ParentNode wrapper) {
        ArrayList values = wrapper.getChildren();
        for (int i = 0; i < values.size(); ++i) {
            String name;
            ClassHolder.DataNode value = (ClassHolder.DataNode)values.get(i);
            Item item = value.getItem();
            boolean addname = item.isFixedName();
            if (value instanceof ClassHolder.ParentNode) {
                ClassHolder.ParentNode childgrp = (ClassHolder.ParentNode)value;
                this.addFixedNames(childgrp);
                boolean bl = addname = addname && (childgrp.isSelectorNeeded() || wrapper.isSelectorNeeded());
            }
            if (!addname || this.m_nameSet.add(name = item.getEffectiveName()).equals(name)) continue;
            throw new IllegalStateException("Name '" + name + "' cannot be used twice in same context");
        }
    }

    private void setCollectionName(String base, Item item) {
        String name;
        if (this.getSchemaCustom().getRepeatType() == 0) {
            name = this.m_nameConverter.pluralize(base);
            if (!name.equals(base)) {
                s_logger.debug((Object)("Converted name " + base + " to " + name));
            }
        } else {
            String singular = this.m_nameConverter.depluralize(base);
            if (!singular.equals(base)) {
                s_logger.debug((Object)("Converted name " + base + " to " + singular));
            }
            name = singular + "List";
        }
        item.setName(this.m_nameSet.add(name));
    }

    private void fixFlexibleNames(ClassHolder.ParentNode parent, boolean innamed) {
        String suffix = null;
        ArrayList nodes = parent.getChildren();
        if (parent.isSelectorNeeded()) {
            Item item = parent.getItem();
            item.setName(this.m_nameSet.add(this.m_nameConverter.toBaseName(item.getEffectiveName()) + "Select"));
            if (this.m_selectSet == null) {
                this.m_selectSet = new UniqueNameSet();
            }
            suffix = parent.getSchemaComponent().type() == 39 ? "_Form" : "_Choice";
        }
        for (int i = 0; i < nodes.size(); ++i) {
            ClassHolder.DataNode node = (ClassHolder.DataNode)nodes.get(i);
            Item item = node.getItem();
            String name = null;
            if (node instanceof ClassHolder.ParentNode) {
                ArrayList childvals = ((ClassHolder.ParentNode)node).getChildren();
                if (childvals.size() > 0) {
                    if (!item.isFixedName() && innamed) {
                        item.setName(parent.getItem().getName());
                    }
                    boolean passname = false;
                    if (childvals.size() == 1) {
                        passname = item.isFixedName() || innamed;
                        int type = item.getSchemaComponent().type();
                        if (!(passname || type != 5 && type != 11)) {
                            ArrayList childs = childvals;
                            boolean collect = node.isCollection();
                            while (childs.size() == 1) {
                                ClassHolder.DataNode child = (ClassHolder.DataNode)childs.get(0);
                                if (child.isCollection()) {
                                    collect = true;
                                }
                                if (child instanceof ClassHolder.LeafNode) {
                                    name = item.getEffectiveName();
                                    if (collect) {
                                        this.setCollectionName(name, item);
                                    } else {
                                        item.setName(this.m_nameSet.add(name));
                                    }
                                    passname = true;
                                    break;
                                }
                                childs = ((ClassHolder.ParentNode)child).getChildren();
                            }
                        }
                    }
                    this.fixFlexibleNames((ClassHolder.ParentNode)node, passname);
                }
            } else if (item.isFixedName()) {
                name = item.getName();
            } else if (innamed) {
                if (!item.isFixedName()) {
                    item.setName(parent.getItem().getName());
                }
                name = item.getName();
            } else {
                name = item.getEffectiveName();
                if (node.isCollection()) {
                    this.setCollectionName(name, item);
                    name = item.getName();
                } else {
                    item.setName(this.m_nameSet.add(name));
                }
            }
            if (!parent.isSelectorNeeded()) continue;
            if (name == null) {
                name = item.getEffectiveName();
                if (node.isCollection()) {
                    name = this.m_nameConverter.pluralize(name);
                }
            }
            name = this.m_selectSet.add(NameUtils.toNameWord(name));
            node.setSelectPropName(name);
            node.setSelectConstName(this.m_nameConverter.toConstantName(name + suffix));
        }
    }

    private void generateSelectorSet(ClassHolder.DataNode value, BlockBuilder block, ClassBuilder builder) {
        ClassHolder.ParentNode group;
        while ((group = value.getParent()) != null) {
            if (group.isSelectorNeeded()) {
                int type = group.getSelectorType();
                if (type == 1 || type == 2) {
                    InvocationBuilder call = builder.createMemberMethodCall(group.getSelectSetMethod());
                    call.addVariableOperand(value.getSelectConstName());
                    block.addCall(call);
                    break;
                }
                block.addAssignVariableToField(value.getSelectConstName(), group.getSelectField());
            }
            value = group;
        }
    }

    private void generateSelectorCheck(ClassHolder.DataNode value, BlockBuilder block, ClassBuilder builder) {
        ClassHolder.ParentNode group;
        while ((group = value.getParent()) != null) {
            int type;
            if (group.isSelectorNeeded() && ((type = group.getSelectorType()) == 2 || type == 4)) {
                InvocationBuilder call = builder.createMemberMethodCall(group.getSelectCheckMethod());
                call.addVariableOperand(value.getSelectConstName());
                block.addCall(call);
                break;
            }
            value = group;
        }
    }

    private void checkIfMethod(ClassHolder.DataNode node, String seldesc, String valdesc, ClassBuilder builder) {
        if (node.getParent().isSelectorNeeded()) {
            MethodBuilder ifmeth = builder.addMethod("if" + node.getSelectPropName(), "boolean");
            ifmeth.setPublic();
            ifmeth.addSourceComment("Check if " + valdesc + " is current selection for " + seldesc + '.');
            ifmeth.addSourceComment("");
            ifmeth.addSourceComment("@return", " <code>true</code> if selection, <code>false</code> if not");
            InfixExpressionBuilder testexpr = builder.buildNameOp(node.getParent().getSelectField(), InfixExpression.Operator.EQUALS);
            testexpr.addVariableOperand(node.getSelectConstName());
            ifmeth.createBlock().addReturnExpression(testexpr);
        }
    }

    private void setStructureOptional(ClassHolder.DataNode value, boolean force, StructureElementBase struct) {
        boolean optional = value.isOptional();
        if (!optional && struct.getName() == null) {
            Item item = value.getItem();
            if (item instanceof GroupItem && item.isTopmost()) {
                optional = ((GroupItem)item).isAllOptional();
            } else if (this.getSchemaCustom().isStructureOptional() && item instanceof ReferenceItem) {
                optional = ((ReferenceItem)item).getDefinition().isAllOptional();
            }
        }
        if (optional) {
            struct.setUsage(1);
        }
    }

    private static void setName(QName qname, BindingHolder holder, ValueElement value) {
        if (qname != null) {
            if (value.getName() != null) {
                throw new IllegalStateException("Internal error - trying to overwrite name '" + value.getName() + "' with '" + qname.getName() + '\'');
            }
            value.setName(qname.getName());
            String uri = qname.getUri();
            int style = value.getStyle();
            if (style == 0) {
                if (uri != null) {
                    holder.addNamespaceUsage(uri);
                }
                value.setUri(uri);
            } else if (style == 1) {
                holder.addNamespaceUsage(uri);
                if (!Utility.safeEquals((Object)uri, (Object)holder.getElementDefaultNamespace())) {
                    value.setUri(uri);
                }
            }
        }
    }

    private static void setName(QName qname, BindingHolder holder, StructureElementBase struct) {
        if (qname != null) {
            if (struct.getName() != null) {
                throw new IllegalStateException("Internal error - trying to overwrite name '" + struct.getName() + "' with '" + qname.getName() + '\'');
            }
            String name = qname.getName();
            String uri = qname.getUri();
            if (name.charAt(0) == '{') {
                int split = name.indexOf(125);
                uri = name.substring(1, split);
                name = name.substring(split + 1);
            }
            struct.setName(name);
            holder.addNamespaceUsage(uri);
            if (!Utility.safeEquals((Object)uri, (Object)holder.getElementDefaultNamespace())) {
                struct.setUri(uri);
            }
        }
    }

    private ValueElement buildValueBinding(ClassHolder.DataNode node, QName wrapname, String gname, String sname, BindingHolder holder) {
        ValueElement value = new ValueElement();
        if (gname == null) {
            value.setDeclaredType(node.getBindingType());
        } else {
            value.setGetName(gname);
            value.setSetName(sname);
        }
        this.setValueHandlingOptions(node.getItem(), value, holder);
        ClassHolder.ParentNode wrapper = node.getParent();
        if (wrapper.isSelectorNeeded()) {
            value.setTestName("if" + node.getSelectPropName());
            value.setUsage(1);
        } else if (node.isOptional()) {
            value.setUsage(1);
        }
        AnnotatedBase comp = node.getSchemaComponent();
        if (wrapname == null) {
            ClassHolder.ParentNode parent;
            for (parent = wrapper; parent != null && parent.getSchemaComponent() == comp; parent = parent.getParent()) {
            }
            if (parent == null) {
                value.setEffectiveStyle(3);
            } else {
                if (comp.type() == 11) {
                    value.setEffectiveStyle(1);
                    ElementElement elem = (ElementElement)comp;
                    if (SchemaUtils.isOptionalElement((ElementElement)elem)) {
                        value.setUsage(1);
                    }
                } else if (comp.type() == 5) {
                    value.setEffectiveStyle(0);
                    AttributeElement attr = (AttributeElement)comp;
                    if (SchemaUtils.isOptionalAttribute((AttributeElement)attr)) {
                        value.setUsage(1);
                    }
                } else {
                    value.setEffectiveStyle(3);
                }
                StructureClassHolder.setName(node.getQName(), holder, value);
            }
        } else {
            value.setEffectiveStyle(1);
            StructureClassHolder.setName(wrapname, holder, value);
        }
        return value;
    }

    private void setMemberNames(String basename, ClassHolder.DataNode node) {
        String propname = node.getPropName();
        s_logger.debug((Object)("Adding property " + propname));
        node.setFieldName(this.m_nameConverter.toFieldName(this.m_nameConverter.toBaseName(propname)));
        String getpref = "boolean".equals(node.getType()) ? "is" : "get";
        node.setGetMethodName(getpref + propname);
        node.setSetMethodName("set" + propname);
    }

    private void addSimpleProperty(String basename, ClassHolder.DataNode node, ClassBuilder builder) {
        this.setMemberNames(basename, node);
        String type = node.getType();
        if (type == null) {
            if (node.isAny()) {
                return;
            }
            throw new IllegalStateException("Internal error - no type for property");
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Found type " + type + " for property " + basename));
        }
        String fname = node.getFieldName();
        FieldBuilder field = builder.addField(fname, type);
        field.setPrivate();
        MethodBuilder getmeth = builder.addMethod(node.getGetMethodName(), type);
        getmeth.setPublic();
        StringBuffer buff = new StringBuffer();
        buff.append("Get the ");
        String descript = StructureClassHolder.describe(node);
        buff.append(descript);
        buff.append(" value.");
        String document = this.findDocumentation(false, node);
        if (document != null) {
            buff.append(' ');
            buff.append(document);
        }
        getmeth.addSourceComment(buff.toString());
        getmeth.addSourceComment("");
        getmeth.addSourceComment("@return", " value");
        BlockBuilder block = getmeth.createBlock();
        this.generateSelectorCheck(node, block, builder);
        block.addReturnNamed(fname);
        MethodBuilder setmeth = builder.addMethod(node.getSetMethodName(), "void");
        setmeth.setPublic();
        buff.replace(0, 3, "Set");
        setmeth.addSourceComment(buff.toString());
        setmeth.addSourceComment("");
        String nonres = NameUtils.convertReserved(basename);
        setmeth.addSourceComment("@param", " " + nonres);
        setmeth.addParameter(nonres, type);
        block = setmeth.createBlock();
        this.generateSelectorSet(node, block, builder);
        block.addAssignVariableToField(nonres, fname);
        for (int i = 0; i < this.m_decorators.length; ++i) {
            this.m_decorators[i].valueAdded(nonres, false, type, field.getDeclaration(), getmeth.getDeclaration(), setmeth.getDeclaration(), descript, this);
        }
    }

    private void addRepeatedProperty(String basename, ClassHolder.DataNode node, ClassBuilder builder) {
        String type;
        Type insttype;
        Type fieldtype;
        int reptype;
        String basetype;
        String propname = node.getPropName();
        this.setMemberNames(basename, node);
        int collcount = node.isCollection() ? 1 : 0;
        ClassHolder.DataNode nested = node;
        while ((basetype = nested.getType()) == null && nested.isInterior() && ((ClassHolder.ParentNode)nested).getChildren().size() > 0) {
            if (!(nested = (ClassHolder.DataNode)((ClassHolder.ParentNode)nested).getChildren().get(0)).isCollection()) continue;
            ++collcount;
        }
        if (basetype == null) {
            if (node.isAny()) {
                return;
            }
            basetype = "java.lang.String";
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Found type " + basetype + " (" + collcount + " layers of collection nesting) for property " + propname));
        }
        if ((reptype = this.getSchemaCustom().getRepeatType()) == 2) {
            fieldtype = builder.createParameterizedType("java.util.List", basetype);
            insttype = builder.createType(basetype);
            while (--collcount > 0) {
                fieldtype = builder.createParameterizedType("java.util.List", fieldtype);
                insttype = builder.createParameterizedType("java.util.List", insttype);
            }
            type = basetype;
            insttype = builder.createParameterizedType(this.m_listImplClass, insttype);
        } else if (reptype == 1 || node.isAny()) {
            fieldtype = builder.createType("java.util.List");
            insttype = builder.createType(this.m_listImplClass);
            type = collcount > 1 ? "java.util.List" : basetype;
        } else {
            type = basetype;
            while (--collcount > 0) {
                type = type + "[]";
            }
            fieldtype = builder.createType(type + "[]");
            insttype = null;
        }
        String document = this.findDocumentation(true, node);
        String descript = StructureClassHolder.describe(node);
        String term = this.getSchemaCustom().getRepeatType() == 0 ? "array" : "list";
        String fname = node.getFieldName();
        FieldBuilder field = builder.addField(fname, fieldtype);
        if (insttype != null) {
            field.setInitializer(builder.newInstance(insttype));
        }
        field.setPrivate();
        MethodBuilder getmeth = builder.addMethod(node.getGetMethodName(), (Type)builder.clone((ASTNode)fieldtype));
        getmeth.setPublic();
        StringBuffer buff = new StringBuffer();
        buff.append("Get the ");
        buff.append(term);
        buff.append(" of ");
        buff.append(descript);
        buff.append(" items.");
        if (document != null) {
            buff.append(' ');
            buff.append(document);
        }
        getmeth.addSourceComment(buff.toString());
        getmeth.addSourceComment("");
        getmeth.addSourceComment("@return", " " + term);
        getmeth.createBlock().addReturnNamed(fname);
        MethodBuilder setmeth = builder.addMethod(node.getSetMethodName(), "void");
        setmeth.setPublic();
        buff.replace(0, 3, "Set");
        setmeth.addSourceComment(buff.toString());
        setmeth.addSourceComment("");
        setmeth.addSourceComment("@param", " list");
        setmeth.addParameter("list", (Type)builder.clone((ASTNode)fieldtype));
        BlockBuilder block = setmeth.createBlock();
        this.generateSelectorSet(node, block, builder);
        block.addAssignVariableToField("list", fname);
        Item item = node.getItem();
        if (!node.isCollection()) {
            InvocationBuilder desercall;
            String valsername = null;
            String valdesername = null;
            String valuename = null;
            FormatElement format = (FormatElement)s_formatMap.get(type);
            boolean passctx = false;
            if (format != null) {
                valsername = format.getSerializerName();
                valdesername = format.getDeserializerName();
                if (valsername == null && !"java.lang.String".equals(type)) {
                    valuename = "toString";
                }
                passctx = "org.jibx.runtime.QName".equals(type);
            } else if (item instanceof ReferenceItem) {
                DefinitionItem def = ((ReferenceItem)item).getDefinition();
                if (def.isEnumeration()) {
                    EnumerationClassHolder genclas = (EnumerationClassHolder)def.getGenerateClass();
                    valsername = "fromValue";
                    valuename = genclas.getName() + ".toString";
                }
            } else {
                throw new IllegalStateException("Internal error - invalid list type");
            }
            String sername = LIST_SERIALIZE_PREFIX + propname;
            MethodBuilder sermeth = builder.addMethod(sername, "java.lang.String");
            sermeth.addParameter("values", (Type)builder.clone((ASTNode)fieldtype));
            if (passctx) {
                SingleVariableDeclaration decl = sermeth.addParameter("ictx", "org.jibx.runtime.IMarshallingContext");
                decl.modifiers().add(decl.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
                sermeth.addThrows("org.jibx.runtime.JiBXException");
            }
            sermeth.setPublicStatic();
            sermeth.addSourceComment("Serializer for " + descript + ' ' + term + '.');
            sermeth.addSourceComment("");
            sermeth.addSourceComment("@param", " values");
            sermeth.addSourceComment("@return", " text");
            BlockBuilder nullblock = builder.newBlock();
            nullblock.addReturnNull();
            BlockBuilder serblock = builder.newBlock();
            NewInstanceBuilder newbuff = builder.newInstance("java.lang.StringBuffer");
            serblock.addLocalVariableDeclaration("java.lang.StringBuffer", "buff", (ExpressionBuilderBase)newbuff);
            BlockBuilder forblock = builder.newBlock();
            InfixExpressionBuilder lengthexpr = builder.buildInfix(InfixExpression.Operator.GREATER);
            lengthexpr.addOperand(builder.createNormalMethodCall("buff", "length"));
            lengthexpr.addNumberLiteralOperand("0");
            InvocationBuilder appendcall = builder.createNormalMethodCall("buff", "append");
            appendcall.addCharacterLiteralOperand(' ');
            BlockBuilder spaceblock = builder.newBlock();
            spaceblock.addExpressionStatement(appendcall);
            forblock.addIfStatement(lengthexpr, spaceblock);
            if (reptype == 2) {
                forblock.addLocalVariableDeclaration(type, "value", (ExpressionBuilderBase)builder.createNormalMethodCall("iter", "next"));
            } else if (reptype == 1) {
                CastBuilder castexpr = builder.buildCast(type);
                castexpr.addOperand(builder.createNormalMethodCall("iter", "next"));
                forblock.addLocalVariableDeclaration(type, "value", (ExpressionBuilderBase)castexpr);
            } else {
                forblock.addLocalVariableDeclaration(type, "value", (ExpressionBuilderBase)builder.buildArrayIndexAccess("values", "index"));
            }
            appendcall = builder.createNormalMethodCall("buff", "append");
            if (valuename != null) {
                appendcall.addOperand(builder.createNormalMethodCall("value", valuename));
            } else if (valdesername != null) {
                InvocationBuilder sercall = builder.createStaticMethodCall(valsername);
                sercall.addVariableOperand("value");
                if (passctx) {
                    sercall.addVariableOperand("ictx");
                }
                appendcall.addOperand(sercall);
            } else {
                appendcall.addVariableOperand("value");
            }
            forblock.addExpressionStatement(appendcall);
            if (reptype == 2) {
                Type itertype = builder.createParameterizedType("java.util.Iterator", type);
                serblock.addIteratedForStatement("iter", itertype, builder.createNormalMethodCall("values", "iterator"), forblock);
            } else if (reptype == 1) {
                serblock.addIteratedForStatement("iter", builder.createType("java.util.Iterator"), builder.createNormalMethodCall("values", "iterator"), forblock);
            } else {
                serblock.addIndexedForStatement("index", "values", forblock);
            }
            serblock.addReturnExpression(builder.createNormalMethodCall("buff", "toString"));
            InfixExpressionBuilder iftest = builder.buildNameOp("values", InfixExpression.Operator.EQUALS);
            iftest.addNullOperand();
            sermeth.createBlock().addIfElseStatement(iftest, nullblock, serblock);
            String desername = LIST_DESERIALIZE_PREFIX + propname;
            MethodBuilder desermeth = builder.addMethod(desername, (Type)builder.clone((ASTNode)fieldtype));
            desermeth.addParameter("text", "java.lang.String");
            if (passctx) {
                SingleVariableDeclaration decl = desermeth.addParameter("ictx", "org.jibx.runtime.IUnmarshallingContext");
                decl.modifiers().add(decl.getAST().newModifier(Modifier.ModifierKeyword.FINAL_KEYWORD));
            }
            desermeth.setPublicStatic();
            desermeth.addSourceComment("Deserializer for " + descript + ' ' + term + '.');
            desermeth.addSourceComment("");
            desermeth.addSourceComment("@param", " text");
            desermeth.addSourceComment("@return", " values");
            desermeth.addSourceComment("@throws", " org.jibx.runtime.JiBXException on conversion error");
            desermeth.addThrows("org.jibx.runtime.JiBXException");
            block = desermeth.createBlock();
            NewInstanceBuilder newinst = builder.newInstance("org.jibx.runtime.IListItemDeserializer");
            ClassBuilder anonclas = newinst.addAnonymousInnerClass();
            MethodBuilder innermeth = anonclas.addMethod(LIST_DESERIALIZE_PREFIX, "java.lang.Object");
            if (passctx) {
                innermeth.addThrows("org.jibx.runtime.JiBXException");
            }
            innermeth.addParameter("text", "java.lang.String");
            innermeth.setPublic();
            BlockBuilder innerblock = innermeth.createBlock();
            if (valdesername == null) {
                innerblock.addReturnNamed("text");
            } else {
                desercall = builder.createStaticMethodCall(valdesername);
                desercall.addVariableOperand("text");
                if (passctx) {
                    desercall.addVariableOperand("ictx");
                }
                innerblock.addReturnExpression(desercall);
            }
            block.addLocalVariableDeclaration("org.jibx.runtime.IListItemDeserializer", "ldser", (ExpressionBuilderBase)newinst);
            desercall = builder.createStaticMethodCall("org.jibx.runtime.Utility.deserializeList");
            desercall.addVariableOperand("text");
            desercall.addVariableOperand("ldser");
            if (reptype == 2) {
                CastBuilder castexpr = builder.buildCast((Type)builder.clone((ASTNode)fieldtype));
                castexpr.addOperand(desercall);
                block.addReturnExpression(castexpr);
            } else if (reptype == 1) {
                block.addReturnExpression(desercall);
            } else {
                block.addLocalVariableDeclaration("java.util.List", "list", (ExpressionBuilderBase)desercall);
                BlockBuilder ifnull = builder.newBlock();
                ifnull.addReturnNull();
                BlockBuilder ifnonnull = builder.newBlock();
                InvocationBuilder toarraycall = builder.createNormalMethodCall("list", "toArray");
                NewArrayBuilder newarray = builder.newArrayBuilder(type);
                newarray.setSize(builder.createNormalMethodCall("list", "size"));
                toarraycall.addOperand(newarray);
                CastBuilder castexpr = builder.buildCast((Type)builder.clone((ASTNode)fieldtype));
                castexpr.addOperand(toarraycall);
                ifnonnull.addReturnExpression(castexpr);
                iftest = builder.buildNameOp("list", InfixExpression.Operator.EQUALS);
                iftest.addNullOperand();
                block.addIfElseStatement(iftest, ifnull, ifnonnull);
            }
        }
        for (int i = 0; i < this.m_decorators.length; ++i) {
            this.m_decorators[i].valueAdded(basename, true, basetype, field.getDeclaration(), getmeth.getDeclaration(), setmeth.getDeclaration(), descript, this);
        }
    }

    private void addFlagProperty(String basename, ClassHolder.DataNode node, ClassBuilder builder) {
        String propname = node.getPropName();
        s_logger.debug((Object)("Adding property " + propname));
        String fname = this.m_nameConverter.toFieldName(basename);
        node.setFieldName(fname);
        node.setTestMethodName("if" + propname + "Present");
        node.setFlagMethodName("flag" + propname + "Present");
        String nonres = NameUtils.convertReserved(basename);
        FieldBuilder field = builder.addField(fname, "boolean");
        field.setPrivate();
        MethodBuilder testmeth = builder.addMethod(node.getTestMethodName(), "boolean");
        testmeth.setPublic();
        StringBuffer buff = new StringBuffer();
        buff.append("Check if the ");
        String descript = StructureClassHolder.describe(node);
        buff.append(descript);
        buff.append(" is present.");
        String document = this.findDocumentation(false, node);
        if (document != null) {
            buff.append(' ');
            buff.append(document);
        }
        testmeth.addSourceComment(buff.toString());
        testmeth.addSourceComment("");
        testmeth.addSourceComment("@return", " <code>true</code> if present, <code>false</code> if not");
        BlockBuilder block = testmeth.createBlock();
        this.generateSelectorCheck(node, block, builder);
        block.addReturnNamed(fname);
        MethodBuilder flagmeth = builder.addMethod(node.getFlagMethodName(), "void");
        flagmeth.setPublic();
        buff.setLength(0);
        buff.append("Set flag for ");
        buff.append(descript);
        buff.append(" present.");
        if (document != null) {
            buff.append(' ');
            buff.append(document);
        }
        flagmeth.addSourceComment(buff.toString());
        flagmeth.addSourceComment("");
        flagmeth.addSourceComment("@param", " " + nonres);
        flagmeth.addParameter(nonres, "boolean");
        block = flagmeth.createBlock();
        this.generateSelectorSet(node, block, builder);
        block.addAssignVariableToField(nonres, fname);
        for (int i = 0; i < this.m_decorators.length; ++i) {
            this.m_decorators[i].valueAdded(nonres, false, "boolean", field.getDeclaration(), null, null, descript, this);
        }
    }

    private String findDocumentation(boolean top, ClassHolder.DataNode node) {
        Item item = node.getItem();
        if (item instanceof GroupItem && ((GroupItem)item).getGenerateClass() != null) {
            node = node.getParent();
        }
        String text = null;
        while (node != this.m_dataRoot) {
            ClassHolder.ParentNode parent;
            String thisdoc = node.getDocumentation();
            if (thisdoc != null) {
                text = thisdoc;
                if (!top) break;
            }
            if ((parent = node.getParent()).getChildren().size() != 1) break;
            node = parent;
        }
        return text;
    }

    private void addToClass(ClassHolder.ParentNode parent) {
        ClassBuilder builder = this.getBuilder();
        ArrayList nodes = parent.getChildren();
        Item grpitem = parent.getItem();
        String seldesc = null;
        if (parent.isSelectorNeeded()) {
            String descript;
            String basename = grpitem.getEffectiveName();
            String fieldname = this.m_nameConverter.toFieldName(basename);
            parent.setSelectField(fieldname);
            builder.addIntField(fieldname, "-1").setPrivate();
            AnnotatedBase comp = parent.getSchemaComponent();
            StringBuffer buff = new StringBuffer();
            if (parent.getQName() != null) {
                buff.append(parent.getQName().getName());
                buff.append(' ');
            }
            if (comp.type() == 39) {
                descript = "form";
                buff.append("union");
            } else {
                descript = "choice";
                buff.append("choice");
            }
            seldesc = buff.toString();
            buff.insert(0, "Clear the ");
            buff.append(" selection.");
            String namesuffix = NameUtils.toNameWord(basename);
            boolean expose = parent.isSelectorExposed();
            int index = 0;
            for (int i = 0; i < nodes.size(); ++i) {
                ClassHolder.DataNode node = (ClassHolder.DataNode)nodes.get(i);
                if (node.isIgnored()) continue;
                FieldBuilder field = builder.addIntField(node.getSelectConstName(), Integer.toString(index++));
                if (expose) {
                    field.setPublicStaticFinal();
                    field.addSourceComment(namesuffix + " value when " + node.getItem().getEffectiveName() + " is set");
                    continue;
                }
                field.setPrivateStaticFinal();
            }
            int seltype = parent.getSelectorType();
            String selectname = "set" + namesuffix;
            String resetname = "clear" + namesuffix;
            parent.setSelectSetMethod(selectname);
            MethodBuilder setmeth = builder.addMethod(selectname, "void");
            setmeth.setPrivate();
            BlockBuilder block = setmeth.createBlock();
            setmeth.addParameter(descript, "int");
            this.generateSelectorSet(parent, block, builder);
            if (seltype == 3 || seltype == 4) {
                block.addAssignVariableToField(descript, fieldname);
            } else {
                BlockBuilder assignblock = builder.newBlock();
                assignblock.addAssignVariableToField(descript, fieldname);
                BlockBuilder throwblock = builder.newBlock();
                throwblock.addThrowException("IllegalStateException", "Need to call " + resetname + "() before changing existing " + descript);
                InfixExpressionBuilder iftest = builder.buildNameOp(fieldname, InfixExpression.Operator.EQUALS);
                iftest.addNumberLiteralOperand("-1");
                InfixExpressionBuilder elsetest = builder.buildNameOp(fieldname, InfixExpression.Operator.NOT_EQUALS);
                elsetest.addVariableOperand(descript);
                block.addIfElseIfStatement(iftest, elsetest, assignblock, throwblock);
            }
            if (seltype == 2 || seltype == 4) {
                String checkname = "check" + namesuffix;
                parent.setSelectCheckMethod(checkname);
                MethodBuilder checkmeth = builder.addMethod(checkname, "void");
                checkmeth.setPrivate();
                block = checkmeth.createBlock();
                checkmeth.addParameter(descript, "int");
                this.generateSelectorCheck(parent, block, builder);
                BlockBuilder throwblock = builder.newBlock();
                InfixExpressionBuilder strcat = builder.buildStringConcatenation("State mismatch when accessing " + descript + " value: current state is ");
                strcat.addVariableOperand(fieldname);
                throwblock.addThrowException("IllegalStateException", strcat);
                InfixExpressionBuilder unequaltest = builder.buildNameOp(fieldname, InfixExpression.Operator.NOT_EQUALS);
                unequaltest.addVariableOperand(descript);
                InfixExpressionBuilder unsettest = builder.buildNameOp(fieldname, InfixExpression.Operator.NOT_EQUALS);
                unsettest.addNumberLiteralOperand("-1");
                InfixExpressionBuilder iftest = builder.buildInfix(InfixExpression.Operator.CONDITIONAL_AND);
                iftest.addOperand(unequaltest);
                iftest.addOperand(unsettest);
                block.addIfStatement(iftest, throwblock);
            }
            MethodBuilder resetmeth = builder.addMethod(resetname, "void");
            resetmeth.setPublic();
            resetmeth.addSourceComment(buff.toString());
            block = resetmeth.createBlock();
            block.addAssignToName((Expression)block.numberLiteral("-1"), fieldname);
            if (expose) {
                MethodBuilder statemethod = builder.addMethod("state" + namesuffix, "int");
                statemethod.setPublic();
                statemethod.addSourceComment("Get the current " + seldesc + " state.");
                statemethod.addSourceComment("@return", " state");
                statemethod.createBlock().addReturnNamed(fieldname);
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Created selector for grouping component " + SchemaUtils.describeComponent((SchemaBase)grpitem.getSchemaComponent()) + " in class " + this.getFullName()));
            }
        }
        for (int i = 0; i < nodes.size(); ++i) {
            String plural;
            String basename;
            ClassHolder.DataNode node = (ClassHolder.DataNode)nodes.get(i);
            Item item = node.getItem();
            if (node.isIgnored() || item.isImplicit()) continue;
            boolean repeat = node.isCollection() || node.isList();
            String workingname = basename = item.getEffectiveName();
            if (repeat && !(plural = this.m_nameConverter.pluralize(workingname)).equals(workingname)) {
                workingname = this.m_nameSet.add(plural);
            }
            String propname = NameUtils.toNameWord(workingname);
            node.setPropName(propname);
            this.checkIfMethod(node, seldesc, propname, builder);
            if (node.isInterior()) {
                ClassHolder.ParentNode nestedparent = (ClassHolder.ParentNode)node;
                if (nestedparent.isCollection()) {
                    this.addRepeatedProperty(basename, nestedparent, builder);
                    continue;
                }
                if (nestedparent.getChildren().size() == 0) {
                    if (!nestedparent.isOptional() && !parent.isSelectorNeeded()) continue;
                    this.addFlagProperty(basename, nestedparent, builder);
                    continue;
                }
                this.addToClass(nestedparent);
                continue;
            }
            if (repeat) {
                this.addRepeatedProperty(basename, node, builder);
                continue;
            }
            this.addSimpleProperty(basename, node, builder);
        }
    }

    private StructureElement addReferenceStructure(ClassHolder.LeafNode leaf, DefinitionItem def, boolean single, BindingHolder holder, ContainerElementBase bindcomp) {
        StructureElement struct = null;
        boolean keep = false;
        int type = leaf.getSchemaComponent().type();
        if (single && bindcomp instanceof StructureElement) {
            struct = (StructureElement)bindcomp;
            boolean bl = keep = struct.getGetName() == null && struct.getSetName() == null && struct.getFieldName() == null && !struct.isChoice() && struct.getDeclaredType() == null && struct.getMapAsQName() == null && (struct.getName() == null || type != 5 && type != 11);
        }
        if (!keep) {
            struct = new StructureElement();
        }
        if (def.getSchemaComponent().type() == 11) {
            struct.setDeclaredType(leaf.getBindingType());
        } else {
            QName qname = def.getQName();
            String uri = qname.getUri();
            if (uri != null) {
                holder.addTypeNameReference(uri, (Object)def.getSchemaComponent().getSchema());
            }
            struct.setMapAsQName(qname);
        }
        return struct;
    }

    private CollectionElement newCollection(QName wrapname, boolean wrapopt, BindingHolder holder, ClassHolder.DataNode node) {
        boolean list;
        CollectionElement collect = new CollectionElement();
        int reptype = this.getSchemaCustom().getRepeatType();
        boolean bl = list = reptype == 1 || reptype == 2;
        if (list) {
            collect.setCreateType(this.m_listImplClass);
        }
        if (wrapname == null) {
            if (node.isOptional()) {
                collect.setUsage(1);
            }
        } else {
            StructureClassHolder.setName(wrapname, holder, (StructureElementBase)collect);
            if (wrapopt) {
                collect.setUsage(1);
            }
        }
        return collect;
    }

    private void setValueHandlingOptions(Item item, ValueElement value, BindingHolder holder) {
        if (item instanceof ReferenceItem) {
            ReferenceItem refitem = (ReferenceItem)item;
            DefinitionItem defitem = refitem.getDefinition();
            QName qname = defitem.getQName();
            if (qname != null) {
                value.setFormatQName(qname);
                String uri = qname.getUri();
                if (uri != null) {
                    holder.addTypeNameReference(uri, (Object)defitem.getSchemaComponent().getSchema());
                }
            }
        } else if (item instanceof ValueItem) {
            ValueItem valitem = (ValueItem)item;
            JavaType jtype = valitem.getType();
            value.setFormatName(jtype.getFormat());
            value.setSerializerName(jtype.getSerializerMethod());
            value.setDeserializerName(jtype.getDeserializerMethod());
        }
    }

    private void addToBinding(ClassHolder.ParentNode parent, QName wrapname, boolean wrapopt, boolean single, ContainerElementBase bindcomp, BindingHolder holder) {
        ArrayList children = parent.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            TypeData groupclas;
            boolean consing;
            StructureElement struct;
            ClassHolder.DataNode child = (ClassHolder.DataNode)children.get(i);
            Item item = child.getItem();
            String propname = child.getPropName();
            if (child.isIgnored()) {
                StructureElement struct2 = new StructureElement();
                StructureClassHolder.setName(child.getQName(), holder, (StructureElementBase)struct2);
                struct2.setUsage(1);
                bindcomp.addChild((Object)struct2);
                continue;
            }
            if (item.isImplicit()) {
                DefinitionItem def = ((ReferenceItem)item).getDefinition();
                QName qname = def.getQName();
                AnnotatedBase comp = def.getSchemaComponent();
                int type = comp.type();
                StructureElement struct3 = new StructureElement();
                if (type == 11) {
                    struct3.setMapAsName(this.getSuperClass().getBindingName());
                } else {
                    String uri = qname.getUri();
                    if (uri != null) {
                        holder.addTypeNameReference(uri, (Object)def.getSchemaComponent().getSchema());
                    }
                    struct3.setMapAsQName(qname);
                }
                bindcomp.addChild((Object)struct3);
                continue;
            }
            if (child instanceof ClassHolder.ParentNode) {
                ClassHolder.ParentNode subparent = (ClassHolder.ParentNode)child;
                boolean empty = subparent.getChildren().size() == 0;
                boolean recurse = true;
                ContainerElementBase wrapcomp = bindcomp;
                CollectionElement newcomp = null;
                QName newname = null;
                boolean newopt = false;
                if (subparent.isCollection() && !empty) {
                    CollectionElement collect = this.newCollection(wrapname, wrapopt, holder, subparent);
                    wrapcomp.addChild((Object)collect);
                    newcomp = collect;
                    newname = subparent.getQName();
                } else {
                    boolean multi;
                    boolean all = item.getSchemaComponent().type() == 0;
                    boolean bl = multi = subparent.getChildren().size() > 1;
                    if (wrapname != null && (subparent.isNamed() || multi) || all && multi) {
                        struct = new StructureElement();
                        struct.setOrdered(!all);
                        StructureClassHolder.setName(wrapname, holder, (StructureElementBase)struct);
                        if (wrapopt) {
                            struct.setUsage(1);
                        }
                        wrapcomp.addChild((Object)struct);
                        wrapcomp = struct;
                        if (!empty && bindcomp.type() == 1 && this.getSchemaCustom().getRepeatType() != 0) {
                            ClassHolder.DataNode nested = subparent;
                            String type = null;
                            while (((ClassHolder.ParentNode)nested).getChildren().size() > 0) {
                                if (!(nested = (ClassHolder.DataNode)((ClassHolder.ParentNode)nested).getChildren().get(0)).isCollection() && !(nested instanceof ClassHolder.LeafNode)) continue;
                                type = nested.getBindingType();
                                break;
                            }
                            struct.setDeclaredType(type);
                        }
                    } else {
                        newname = wrapname;
                        newopt = wrapopt;
                    }
                    if (subparent.isNamed()) {
                        AnnotatedBase comp = item.getSchemaComponent();
                        if (comp.type() == 5) {
                            ValueElement value = new ValueElement();
                            value.setEffectiveStyle(0);
                            StructureClassHolder.setName(subparent.getQName(), holder, value);
                            ClassHolder.DataNode nested = subparent;
                            while ((nested = (ClassHolder.DataNode)((ClassHolder.ParentNode)nested).getChildren().get(0)).isInterior()) {
                            }
                            value.setGetName(((ClassHolder.LeafNode)nested).getGetMethodName());
                            value.setSetName(((ClassHolder.LeafNode)nested).getSetMethodName());
                            this.setValueHandlingOptions(item, value, holder);
                            wrapcomp.addChild((Object)value);
                            if (SchemaUtils.isOptionalAttribute((AttributeElement)((AttributeElement)comp))) {
                                value.setUsage(1);
                            }
                            if (nested.isList()) {
                                String nestname = nested.getPropName();
                                value.setSerializerName(this.getBindingName() + '.' + LIST_SERIALIZE_PREFIX + nestname);
                                value.setDeserializerName(this.getBindingName() + '.' + LIST_DESERIALIZE_PREFIX + nestname);
                            } else if (this.getSchemaCustom().isForceTypes()) {
                                value.setDeclaredType(nested.getBindingType());
                            }
                            recurse = false;
                        } else if (subparent.getChildren().size() == 1) {
                            newname = subparent.getQName();
                            newopt = subparent.isOptional();
                        } else {
                            StructureElement struct4 = new StructureElement();
                            StructureClassHolder.setName(subparent.getQName(), holder, (StructureElementBase)struct4);
                            wrapcomp.addChild((Object)struct4);
                            newcomp = struct4;
                            newname = null;
                            newopt = false;
                        }
                    }
                }
                if (parent.isSelectorNeeded()) {
                    if (newcomp == null) {
                        newcomp = new StructureElement();
                        StructureClassHolder.setName(newname, holder, (StructureElementBase)newcomp);
                        newname = null;
                        wrapcomp.addChild((Object)newcomp);
                    }
                    newcomp.setTestName("if" + child.getSelectPropName());
                    newcomp.setUsage(1);
                    newopt = false;
                }
                if (empty) {
                    CollectionElement struct5 = newcomp;
                    if (struct5 == null) {
                        if (newname == null) {
                            throw new IllegalStateException("Internal error - no wrapping name for empty structure");
                        }
                        struct5 = new StructureElement();
                        StructureClassHolder.setName(newname, holder, (StructureElementBase)struct5);
                        wrapcomp.addChild((Object)struct5);
                        newcomp = struct5;
                    }
                    struct5.setFlagName(subparent.getFlagMethodName());
                    struct5.setTestName(subparent.getTestMethodName());
                    this.setStructureOptional(subparent, newopt, (StructureElementBase)struct5);
                    continue;
                }
                if (subparent.isSelectorNeeded()) {
                    if (newcomp == null) {
                        newcomp = new StructureElement();
                        this.setStructureOptional(subparent, false, (StructureElementBase)newcomp);
                        wrapcomp.addChild((Object)newcomp);
                    }
                    newcomp.setChoice(true);
                    newcomp.setOrdered(false);
                }
                if (!recurse) continue;
                if (newcomp == null) {
                    this.addToBinding(subparent, newname, newopt, single && children.size() == 1, wrapcomp, holder);
                    continue;
                }
                newcomp.setGetName(subparent.getGetMethodName());
                newcomp.setSetName(subparent.getSetMethodName());
                if (this.getSchemaCustom().isForceTypes()) {
                    newcomp.setDeclaredType(subparent.getBindingType());
                }
                this.addToBinding(subparent, newname, newopt, true, (ContainerElementBase)newcomp, holder);
                continue;
            }
            ClassHolder.LeafNode leaf = (ClassHolder.LeafNode)child;
            String gname = leaf.getGetMethodName();
            String sname = leaf.getSetMethodName();
            if (leaf.isAny()) {
                String mapper;
                int anytype = item.getComponentExtension().getAnyType();
                StructureElement struct6 = leaf.isCollection() && anytype != 1 ? new CollectionElement() : new StructureElement();
                switch (anytype) {
                    case 0: {
                        mapper = leaf.isCollection() ? "org.jibx.extras.DiscardListMapper" : "org.jibx.extras.DiscardElementMapper";
                        struct6.setDeclaredType("java.lang.Object");
                        sname = null;
                        gname = null;
                        break;
                    }
                    case 1: {
                        mapper = leaf.isCollection() ? "org.jibx.extras.DomListMapper" : "org.jibx.extras.DomElementMapper";
                        break;
                    }
                    case 2: {
                        mapper = null;
                        if (!leaf.isCollection()) break;
                        StructureElement itemstruct = new StructureElement();
                        itemstruct.setDeclaredType("java.lang.Object");
                        struct6.addChild((Object)itemstruct);
                        struct6.setCreateType(this.m_listImplClass);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Internal error - unknown xs:any handling");
                    }
                }
                if (leaf.isOptional()) {
                    struct6.setUsage(1);
                }
                struct6.setGetName(gname);
                struct6.setSetName(sname);
                struct6.setMarshallerName(mapper);
                struct6.setUnmarshallerName(mapper);
                bindcomp.addChild((Object)struct6);
                continue;
            }
            if (leaf.isCollection() || leaf.isList()) {
                if (leaf.isCollection()) {
                    int reptype;
                    CollectionElement collect = this.newCollection(wrapname, wrapopt, holder, leaf);
                    bindcomp.addChild((Object)collect);
                    collect.setGetName(gname);
                    collect.setSetName(sname);
                    if (parent.isSelectorNeeded()) {
                        collect.setUsage(1);
                        collect.setTestName("if" + leaf.getSelectPropName());
                    }
                    if ((reptype = this.getSchemaCustom().getRepeatType()) == 1 || reptype == 2) {
                        collect.setCreateType(this.m_listImplClass);
                        if (gname == null) {
                            collect.setDeclaredType("java.util.List");
                        }
                    }
                    boolean usevalue = true;
                    String usetype = leaf.getType();
                    if (item instanceof ReferenceItem) {
                        DefinitionItem def = ((ReferenceItem)item).getDefinition();
                        TypeData defclas = def.getGenerateClass();
                        if (defclas.isSimpleValue()) {
                            usetype = defclas.getBindingName();
                        } else {
                            usevalue = false;
                            if (def.getSchemaComponent().type() == 11) {
                                collect.setItemTypeName(defclas.getBindingName());
                            } else {
                                struct = new StructureElement();
                                QName qname = def.getQName();
                                String uri = qname.getUri();
                                if (uri != null) {
                                    holder.addTypeNameReference(uri, (Object)def.getSchemaComponent().getSchema());
                                }
                                struct.setMapAsQName(qname);
                                if (leaf.isNamed()) {
                                    StructureClassHolder.setName(leaf.getQName(), holder, (StructureElementBase)struct);
                                }
                                collect.addChild((Object)struct);
                            }
                        }
                    } else if (item instanceof GroupItem) {
                        TypeData groupclas2 = ((GroupItem)item).getGenerateClass();
                        if (groupclas2.isSimpleValue()) {
                            usetype = groupclas2.getBindingName();
                        } else {
                            usevalue = false;
                            StructureClassHolder classholder = (StructureClassHolder)groupclas2;
                            struct = new StructureElement();
                            struct.setDeclaredType(classholder.getBindingName());
                            StructureClassHolder.setName(leaf.getQName(), holder, (StructureElementBase)struct);
                            classholder.setBinding((ContainerElementBase)struct);
                            collect.addChild((Object)struct);
                        }
                    }
                    if (!usevalue) continue;
                    ValueElement value = new ValueElement();
                    value.setEffectiveStyle(1);
                    if (leaf.isNamed()) {
                        StructureClassHolder.setName(leaf.getQName(), holder, value);
                    }
                    this.setValueHandlingOptions(item, value, holder);
                    value.setDeclaredType(usetype);
                    collect.addChild((Object)value);
                    continue;
                }
                ValueElement value = this.buildValueBinding(leaf, null, gname, sname, holder);
                value.setSerializerName(this.getBindingName() + '.' + LIST_SERIALIZE_PREFIX + propname);
                value.setDeserializerName(this.getBindingName() + '.' + LIST_DESERIALIZE_PREFIX + propname);
                bindcomp.addChild((Object)value);
                continue;
            }
            ContainerElementBase contain = bindcomp;
            boolean bl = consing = single && children.size() == 1;
            if (wrapname != null && (leaf.isNamed() || leaf.isReference())) {
                StructureElement struct7 = new StructureElement();
                StructureClassHolder.setName(wrapname, holder, (StructureElementBase)struct7);
                String type = leaf.getBindingType();
                if (gname == null) {
                    struct7.setDeclaredType(type);
                } else if (!Types.isSimpleValue((String)type)) {
                    struct7.setGetName(gname);
                    struct7.setSetName(sname);
                    sname = null;
                    gname = null;
                    if (this.getSchemaCustom().isForceTypes()) {
                        struct7.setDeclaredType(type);
                    }
                }
                if (wrapopt) {
                    struct7.setUsage(1);
                }
                contain.addChild((Object)struct7);
                contain = struct7;
                consing = true;
                wrapname = null;
                wrapopt = false;
            }
            StructureElement struct8 = null;
            if (item instanceof ReferenceItem) {
                DefinitionItem def = ((ReferenceItem)item).getDefinition();
                TypeData defclas = def.getGenerateClass();
                if (!defclas.isSimpleValue()) {
                    struct8 = this.addReferenceStructure(leaf, def, consing, holder, contain);
                }
            } else if (item instanceof GroupItem && !(groupclas = ((GroupItem)item).getGenerateClass()).isSimpleValue()) {
                struct8 = new StructureElement();
                StructureClassHolder refclas = (StructureClassHolder)groupclas;
                if (gname == null) {
                    struct8.setDeclaredType(refclas.getBindingName());
                }
                refclas.setBinding((ContainerElementBase)struct8);
            }
            if (struct8 == null) {
                ValueElement value = this.buildValueBinding(leaf, wrapname, gname, sname, holder);
                if (this.getSchemaCustom().isForceTypes()) {
                    value.setDeclaredType(leaf.getBindingType());
                }
                if (wrapopt) {
                    value.setUsage(1);
                }
                contain.addChild((Object)value);
                continue;
            }
            struct8.setGetName(gname);
            struct8.setSetName(sname);
            if (this.getSchemaCustom().isForceTypes()) {
                struct8.setDeclaredType(leaf.getBindingType());
            }
            StructureClassHolder.setName(wrapname == null ? leaf.getQName() : wrapname, holder, (StructureElementBase)struct8);
            this.setStructureOptional(leaf, wrapopt, (StructureElementBase)struct8);
            if (parent.isSelectorNeeded()) {
                struct8.setUsage(1);
                struct8.setTestName("if" + leaf.getSelectPropName());
            }
            if (struct8 == contain) continue;
            contain.addChild((Object)struct8);
        }
    }

    @Override
    public void generate(boolean verbose, SourceBuilder builder) {
        String name = this.getName();
        ClassBuilder clasbuilder = this.m_outerClass == null ? builder.newMainClass(name, false) : builder.newInnerClass(name, this.m_outerClass.getBuilder(), false);
        this.initClass(verbose, clasbuilder, this.m_dataRoot);
        if (this.m_bindingElement instanceof MappingElement) {
            this.addInnerFormats((MappingElementBase)this.m_bindingElement);
        }
        if (this.m_dataRoot.isSelectorNeeded()) {
            this.m_bindingElement.setChoice(true);
            this.m_bindingElement.setOrdered(false);
        }
        String fullname = this.getFullName();
        if (s_logger.isInfoEnabled()) {
            s_logger.info((Object)("Generating class " + fullname + ":\n" + this.m_dataRoot.describe(0)));
        }
        this.addFixedNames(this.m_dataRoot);
        this.fixFlexibleNames(this.m_dataRoot, false);
        AnnotatedBase comp = this.m_dataRoot.getSchemaComponent();
        boolean abs = false;
        int type = comp.type();
        if (type == 11) {
            abs = ((ElementElement)comp).isAbstract();
        } else if (type == 9) {
            abs = ((ComplexTypeElement)comp).isAbstract();
        }
        if (abs) {
            this.getBuilder().setAbstract();
        }
        this.addToClass(this.m_dataRoot);
        if (s_logger.isInfoEnabled()) {
            s_logger.info((Object)("Class " + fullname + " after fields generated:\n" + this.m_dataRoot.describe(0)));
        }
        this.addToBinding(this.m_dataRoot, null, false, false, this.m_bindingElement, this.m_holder);
        this.generateInner(verbose, builder);
        this.finishClass((ElementBase)this.m_bindingElement);
        if (this.m_bindingElement instanceof MappingElement) {
            MappingElementBase mapping = (MappingElementBase)this.m_bindingElement;
            ArrayList childs = mapping.topChildren();
            int fill = 0;
            for (int i = 0; i < childs.size(); ++i) {
                Object child = childs.get(i);
                boolean keep = true;
                if (child instanceof FormatElement) {
                    FormatElement format = (FormatElement)child;
                    boolean bl = keep = format.getDefaultText() != null || format.getDeserializerName() != null || format.getEnumValueName() != null || format.getSerializerName() != null;
                }
                if (!keep) continue;
                childs.set(fill++, child);
            }
            while (fill < childs.size()) {
                childs.remove(childs.size() - 1);
            }
        }
    }

    static {
        for (int i = 0; i < BuiltinFormats.s_builtinFormats.length; ++i) {
            FormatElement format = BuiltinFormats.s_builtinFormats[i];
            s_formatMap.put(format.getTypeName(), format);
        }
    }
}

