/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.schema.codegen;

import java.util.List;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.SwitchCase;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.jibx.schema.codegen.BlockBuilder;
import org.jibx.schema.codegen.ClassBuilder;
import org.jibx.schema.codegen.StatementBuilderBase;

public class SwitchBuilder
extends StatementBuilderBase {
    private final SwitchStatement m_switch;

    public SwitchBuilder(ClassBuilder source, Expression expr) {
        super(source);
        this.m_switch = source.getAST().newSwitchStatement();
        this.m_switch.setExpression(expr);
    }

    @Override
    Statement getStatement() {
        return this.m_switch;
    }

    private static boolean isBreakNeeded(Statement stmt) {
        switch (stmt.getNodeType()) {
            case 8: {
                List stmts = ((Block)stmt).statements();
                int size = stmts.size();
                if (size == 0) {
                    return true;
                }
                return SwitchBuilder.isBreakNeeded((Statement)stmts.get(size - 1));
            }
            case 41: 
            case 53: {
                return false;
            }
        }
        return true;
    }

    public void addNamedCase(String name, StatementBuilderBase stmt) {
        SwitchCase swcase = this.m_ast.newSwitchCase();
        swcase.setExpression((Expression)this.m_ast.newSimpleName(name));
        this.m_switch.statements().add(swcase);
        this.m_switch.statements().add(stmt.getStatement());
        if (SwitchBuilder.isBreakNeeded(stmt.getStatement())) {
            this.m_switch.statements().add(this.m_ast.newBreakStatement());
        }
    }

    public void addNumberCase(String value, StatementBuilderBase stmt) {
        SwitchCase swcase = this.m_ast.newSwitchCase();
        swcase.setExpression((Expression)this.numberLiteral(value));
        this.m_switch.statements().add(swcase);
        this.m_switch.statements().add(stmt.getStatement());
        if (SwitchBuilder.isBreakNeeded(stmt.getStatement())) {
            this.m_switch.statements().add(this.m_ast.newBreakStatement());
        }
    }

    public void addDefault(StatementBuilderBase stmt) {
        SwitchCase swcase = this.m_ast.newSwitchCase();
        this.m_switch.statements().add(swcase);
        this.m_switch.statements().add(stmt.getStatement());
        if (SwitchBuilder.isBreakNeeded(stmt.getStatement())) {
            this.m_switch.statements().add(this.m_ast.newBreakStatement());
        }
    }

    private BlockBuilder newCaseBlock(Expression expr) {
        SwitchCase swcase = this.m_ast.newSwitchCase();
        swcase.setExpression(expr);
        this.m_switch.statements().add(swcase);
        BlockBuilder block = this.m_source.newBlock();
        this.m_switch.statements().add(block.getStatement());
        return block;
    }

    public BlockBuilder newNamedCase(String name) {
        return this.newCaseBlock((Expression)this.m_ast.newSimpleName(name));
    }

    public BlockBuilder newNumberCase(String value) {
        return this.newCaseBlock((Expression)this.numberLiteral(value));
    }
}

