/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.util.Objects;
import org.jnosql.artemis.AttributeConverter;
import org.jnosql.artemis.Converters;
import org.jnosql.artemis.IdNotFoundException;
import org.jnosql.artemis.key.KeyValueEntityConverter;
import org.jnosql.artemis.reflection.ClassMapping;
import org.jnosql.artemis.reflection.ClassMappings;
import org.jnosql.artemis.reflection.FieldMapping;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.KeyValueEntity;

public abstract class AbstractKeyValueEntityConverter
implements KeyValueEntityConverter {
    protected abstract ClassMappings getClassMappings();

    protected abstract Converters getConverters();

    public KeyValueEntity<?> toKeyValue(Object entityInstance) {
        Objects.requireNonNull(entityInstance, "Object is required");
        Class<?> clazz = entityInstance.getClass();
        FieldMapping key = this.getId(clazz);
        Object value = key.read(entityInstance);
        Objects.requireNonNull(value, String.format("The key field %s is required", key.getName()));
        return KeyValueEntity.of((Object)this.getKey(value, clazz, false), (Object)entityInstance);
    }

    @Override
    public <T> T toEntity(Class<T> entityClass, KeyValueEntity<?> entity) {
        Value value = entity.getValue();
        Object bean = value.get(entityClass);
        if (Objects.isNull(bean)) {
            return null;
        }
        Object key = this.getKey(entity.getKey(), entityClass, true);
        FieldMapping id = this.getId(entityClass);
        id.write(bean, key);
        return (T)bean;
    }

    private <T> Object getKey(Object key, Class<T> entityClass, boolean toEntity) {
        FieldMapping id = this.getId(entityClass);
        if (id.getConverter().isPresent()) {
            AttributeConverter attributeConverter = this.getConverters().get((Class)id.getConverter().get());
            if (toEntity) {
                return attributeConverter.convertToEntityAttribute(key);
            }
            return attributeConverter.convertToDatabaseColumn(key);
        }
        return Value.of((Object)key).get(id.getNativeField().getType());
    }

    private FieldMapping getId(Class<?> clazz) {
        ClassMapping mapping = this.getClassMappings().get(clazz);
        return (FieldMapping)mapping.getId().orElseThrow(() -> IdNotFoundException.newInstance((Class)clazz));
    }
}

