/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.PreparedStatement;
import org.jnosql.artemis.key.KeyValueEntityConverter;
import org.jnosql.artemis.key.KeyValuePreparedStatement;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.KeyValueWorkflow;
import org.jnosql.diana.api.NonUniqueResultException;
import org.jnosql.diana.api.Value;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.KeyValueEntity;

public abstract class AbstractKeyValueTemplate
implements KeyValueTemplate {
    protected abstract KeyValueEntityConverter getConverter();

    protected abstract BucketManager getManager();

    protected abstract KeyValueWorkflow getFlow();

    @Override
    public <T> T put(T entity) {
        Objects.requireNonNull(entity, "entity is required");
        UnaryOperator putAction = k -> {
            this.getManager().put(k);
            return k;
        };
        return this.getFlow().flow(entity, putAction);
    }

    @Override
    public <T> T put(T entity, Duration ttl) {
        Objects.requireNonNull(entity, "entity is required");
        Objects.requireNonNull(ttl, "ttl class is required");
        UnaryOperator putAction = k -> {
            this.getManager().put(k, ttl);
            return k;
        };
        return this.getFlow().flow(entity, putAction);
    }

    @Override
    public <K, T> Optional<T> get(K key, Class<T> entityClass) {
        Objects.requireNonNull(key, "key is required");
        Objects.requireNonNull(entityClass, "entity class is required");
        Optional value = this.getManager().get(key);
        return value.map(v -> this.getConverter().toEntity(entityClass, KeyValueEntity.of((Object)key, (Value)v))).filter(Objects::nonNull);
    }

    @Override
    public <K, T> Iterable<T> get(Iterable<K> keys, Class<T> entityClass) {
        Objects.requireNonNull(keys, "keys is required");
        Objects.requireNonNull(entityClass, "entity class is required");
        return StreamSupport.stream(keys.spliterator(), false).map(k -> this.getManager().get(k).map(v -> KeyValueEntity.of((Object)k, (Value)v))).filter(Optional::isPresent).map(e -> this.getConverter().toEntity(entityClass, (KeyValueEntity)e.get())).collect(Collectors.toList());
    }

    @Override
    public <K> void remove(K key) {
        Objects.requireNonNull(key, "key is required");
        this.getManager().remove(key);
    }

    @Override
    public <K> void remove(Iterable<K> keys) {
        Objects.requireNonNull(keys, "keys is required");
        this.getManager().remove(keys);
    }

    @Override
    public <T> List<T> query(String query, Class<T> entityClass) {
        Objects.requireNonNull(query, "query is required");
        List values = this.getManager().query(query);
        if (!values.isEmpty()) {
            Objects.requireNonNull(entityClass, "entityClass is required");
            return values.stream().map(v -> v.get(entityClass)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public <T> Optional<T> getSingleResult(String query, Class<T> entityClass) {
        List<T> result = this.query(query, entityClass);
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() == 1) {
            return Optional.ofNullable(result.get(0));
        }
        throw new NonUniqueResultException("No Unique result found to the query: " + query);
    }

    @Override
    public void query(String query) {
        Objects.requireNonNull(query, "query is required");
        this.getManager().query(query);
    }

    @Override
    public <T> PreparedStatement prepare(String query, Class<T> entityClass) {
        Objects.requireNonNull(query, "query is required");
        return new KeyValuePreparedStatement(this.getManager().prepare(query), entityClass);
    }
}

