/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.jnosql.artemis.key.KeyValueEntityConverter;
import org.jnosql.artemis.key.KeyValueEventPersistManager;
import org.jnosql.artemis.key.KeyValueWorkflow;
import org.jnosql.diana.api.key.KeyValueEntity;

public abstract class AbstractKeyValueWorkflow
implements KeyValueWorkflow {
    protected abstract KeyValueEventPersistManager getEventPersistManager();

    protected abstract KeyValueEntityConverter getConverter();

    @Override
    public <T> T flow(T entity, UnaryOperator<KeyValueEntity<?>> action) {
        Function<T, T> flow = this.getFlow(entity, action);
        return flow.apply(entity);
    }

    private <T> Function<T, T> getFlow(T entity, UnaryOperator<KeyValueEntity<?>> action) {
        UnaryOperator validation = t -> Objects.requireNonNull(t, "entity is required");
        UnaryOperator firePreEntity = t -> {
            this.getEventPersistManager().firePreEntity(t);
            return t;
        };
        UnaryOperator firePreKeyValueEntity = t -> {
            this.getEventPersistManager().firePreKeyValueEntity(t);
            return t;
        };
        Function<Object, KeyValueEntity> convertKeyValue = t -> this.getConverter().toKeyValue(t);
        UnaryOperator firePreDocument = t -> {
            this.getEventPersistManager().firePreKeyValue((KeyValueEntity<?>)t);
            return t;
        };
        UnaryOperator firePostDocument = t -> {
            this.getEventPersistManager().firePostKeyValue((KeyValueEntity<?>)t);
            return t;
        };
        Function<KeyValueEntity, Object> converterEntity = t -> this.getConverter().toEntity(entity.getClass(), (KeyValueEntity<?>)t);
        UnaryOperator firePostEntity = t -> {
            this.getEventPersistManager().firePostEntity(t);
            return t;
        };
        UnaryOperator firePostKeyValueEntity = t -> {
            this.getEventPersistManager().firePostKeyValueEntity(t);
            return t;
        };
        return validation.andThen(firePreEntity).andThen(firePreKeyValueEntity).andThen(convertKeyValue).andThen(firePreDocument).andThen(action).andThen(firePostDocument).andThen(converterEntity).andThen(firePostEntity).andThen(firePostKeyValueEntity);
    }
}

