/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.util.Objects;
import javax.enterprise.inject.Vetoed;
import javax.inject.Inject;
import org.jnosql.artemis.key.AbstractKeyValueTemplate;
import org.jnosql.artemis.key.KeyValueEntityConverter;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.KeyValueTemplateProducer;
import org.jnosql.artemis.key.KeyValueWorkflow;
import org.jnosql.diana.api.key.BucketManager;

class DefaultKeyValueTemplateProducer
implements KeyValueTemplateProducer {
    @Inject
    private KeyValueEntityConverter converter;
    @Inject
    private KeyValueWorkflow flow;

    DefaultKeyValueTemplateProducer() {
    }

    public KeyValueTemplate get(BucketManager manager) {
        Objects.requireNonNull(manager, "manager is required");
        return new ProducerKeyValueTemplate(this.converter, this.flow, manager);
    }

    @Vetoed
    static class ProducerKeyValueTemplate
    extends AbstractKeyValueTemplate {
        private KeyValueEntityConverter converter;
        private KeyValueWorkflow flow;
        private BucketManager manager;

        ProducerKeyValueTemplate(KeyValueEntityConverter converter, KeyValueWorkflow flow, BucketManager manager) {
            this.converter = converter;
            this.flow = flow;
            this.manager = manager;
        }

        ProducerKeyValueTemplate() {
        }

        @Override
        protected KeyValueEntityConverter getConverter() {
            return this.converter;
        }

        @Override
        protected BucketManager getManager() {
            return this.manager;
        }

        @Override
        protected KeyValueWorkflow getFlow() {
            return this.flow;
        }
    }
}

