/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jnosql.artemis.PreparedStatement;

final class KeyValuePreparedStatement
implements PreparedStatement {
    private final org.jnosql.diana.api.key.KeyValuePreparedStatement preparedStatement;
    private final Class<?> entityClass;

    KeyValuePreparedStatement(org.jnosql.diana.api.key.KeyValuePreparedStatement preparedStatement, Class<?> entityClass) {
        this.preparedStatement = preparedStatement;
        this.entityClass = entityClass;
    }

    public PreparedStatement bind(String name, Object value) {
        this.preparedStatement.bind(name, value);
        return this;
    }

    public <T> List<T> getResultList() {
        List values = this.preparedStatement.getResultList();
        if (!values.isEmpty()) {
            Objects.requireNonNull(this.entityClass, "entityClass is required when the command returns value");
            return values.stream().map(v -> v.get(this.entityClass)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public <T> Optional<T> getSingleResult() {
        Optional singleResult = this.preparedStatement.getSingleResult();
        if (singleResult.isPresent()) {
            Objects.requireNonNull(this.entityClass, "entityClass is required when the command returns value");
            return singleResult.map(v -> v.get(this.entityClass));
        }
        return Optional.empty();
    }
}

