/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key;

import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.jnosql.artemis.PreparedStatement;

public interface KeyValueTemplate {
    public <T> T put(T var1);

    public <T> T put(T var1, Duration var2);

    default public <T> Iterable<T> put(Iterable<T> entities) {
        Objects.requireNonNull(entities, "entities is required");
        return StreamSupport.stream(entities.spliterator(), false).map(this::put).collect(Collectors.toList());
    }

    default public <T> Iterable<T> put(Iterable<T> entities, Duration ttl) {
        Objects.requireNonNull(entities, "entities is required");
        Objects.requireNonNull(ttl, "ttl is required");
        return StreamSupport.stream(entities.spliterator(), false).map(d -> this.put(d, ttl)).collect(Collectors.toList());
    }

    public <K, T> Optional<T> get(K var1, Class<T> var2);

    public <T> List<T> query(String var1, Class<T> var2);

    public <T> Optional<T> getSingleResult(String var1, Class<T> var2);

    public void query(String var1);

    public <T> PreparedStatement prepare(String var1, Class<T> var2);

    public <K, T> Iterable<T> get(Iterable<K> var1, Class<T> var2);

    public <K> void remove(K var1);

    public <K> void remove(Iterable<K> var1);
}

