/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.query;

import java.util.Optional;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueTemplate;

public abstract class AbstractKeyValueRepository<T>
implements Repository {
    private final Class<T> typeClass;

    protected abstract KeyValueTemplate getTemplate();

    public AbstractKeyValueRepository(Class<T> typeClass) {
        this.typeClass = typeClass;
    }

    public Object save(Object entity) {
        return this.getTemplate().put(entity);
    }

    public Iterable save(Iterable entities) {
        return this.getTemplate().put(entities);
    }

    public void deleteById(Object key) {
        this.getTemplate().remove(key);
    }

    public void deleteById(Iterable ids) {
        this.getTemplate().remove(ids);
    }

    public Optional findById(Object key) {
        return this.getTemplate().get(key, this.typeClass);
    }

    public Iterable findById(Iterable keys) {
        return this.getTemplate().get(keys, this.typeClass);
    }

    public boolean existsById(Object key) {
        return this.getTemplate().get(key, this.typeClass).isPresent();
    }

    public long count() {
        throw new UnsupportedOperationException("The key-value type does not support count method");
    }
}

