/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.jnosql.artemis.DynamicQueryException;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.query.RepositoryType;
import org.jnosql.artemis.reflection.DynamicQueryMethodReturn;

public abstract class AbstractKeyValueRepositoryProxy<T>
implements InvocationHandler {
    protected abstract Repository getRepository();

    protected abstract KeyValueTemplate getTemplate();

    protected abstract Class<T> getEntityClass();

    @Override
    public Object invoke(Object instance, Method method, Object[] args) throws Throwable {
        RepositoryType type = RepositoryType.of((Method)method);
        switch (type) {
            case DEFAULT: {
                return method.invoke((Object)this.getRepository(), args);
            }
            case OBJECT_METHOD: {
                return method.invoke((Object)this, args);
            }
            case JNOSQL_QUERY: {
                Class<T> typeClass = this.getEntityClass();
                DynamicQueryMethodReturn methodReturn = DynamicQueryMethodReturn.builder().withArgs(args).withMethod(method).withTypeClass(typeClass).withPrepareConverter(q -> this.getTemplate().prepare((String)q, typeClass)).withQueryConverter(q -> this.getTemplate().query((String)q, typeClass)).build();
                return methodReturn.execute();
            }
        }
        throw new DynamicQueryException("Key Value repository does not support query method");
    }
}

