/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.query;

import java.lang.reflect.Proxy;
import java.util.Objects;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueRepositoryProducer;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.KeyValueTemplateProducer;
import org.jnosql.artemis.key.query.KeyValueRepositoryProxy;
import org.jnosql.diana.api.key.BucketManager;

@ApplicationScoped
class DefaultKeyValueRepositoryProducer
implements KeyValueRepositoryProducer {
    @Inject
    private KeyValueTemplateProducer producer;

    DefaultKeyValueRepositoryProducer() {
    }

    @Override
    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, BucketManager manager) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(manager, "manager class is required");
        Object template = this.producer.get(manager);
        return this.get(repositoryClass, (KeyValueTemplate)template);
    }

    @Override
    public <T, K, R extends Repository<T, K>> R get(Class<R> repositoryClass, KeyValueTemplate template) {
        Objects.requireNonNull(repositoryClass, "repository class is required");
        Objects.requireNonNull(template, "template class is required");
        KeyValueRepositoryProxy handler = new KeyValueRepositoryProxy(repositoryClass, template);
        return (R)((Repository)Proxy.newProxyInstance(repositoryClass.getClassLoader(), new Class[]{repositoryClass}, handler));
    }
}

