/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.query;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.query.AbstractKeyValueRepositoryProxy;
import org.jnosql.artemis.key.query.DefaultKeyValueRepository;

class KeyValueRepositoryProxy<T>
extends AbstractKeyValueRepositoryProxy<T> {
    private final DefaultKeyValueRepository repository;
    private final KeyValueTemplate template;
    private final Class<T> entityClass;
    private static final List<Method> METHODS = new ArrayList<Method>();

    KeyValueRepositoryProxy(Class<?> repositoryType, KeyValueTemplate template) {
        Class typeClass = (Class)((ParameterizedType)repositoryType.getGenericInterfaces()[0]).getActualTypeArguments()[0];
        this.repository = new DefaultKeyValueRepository(typeClass, template);
        this.template = template;
        this.entityClass = typeClass;
    }

    @Override
    protected Repository getRepository() {
        return this.repository;
    }

    @Override
    protected KeyValueTemplate getTemplate() {
        return this.template;
    }

    @Override
    protected Class getEntityClass() {
        return this.entityClass;
    }

    static {
        METHODS.addAll(Arrays.asList(Object.class.getMethods()));
        METHODS.addAll(Arrays.asList(Repository.class.getMethods()));
    }
}

