/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.query.KeyValueRepositoryProxy;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.artemis.util.AnnotationLiteralUtil;

public class RepositoryKeyValueBean
extends AbstractBean<Repository> {
    private final Class type;
    private final Set<Type> types;
    private final String provider;
    private final Set<Annotation> qualifiers;

    public RepositoryKeyValueBean(Class type, BeanManager beanManager, String provider) {
        super(beanManager);
        this.type = type;
        this.types = Collections.singleton(type);
        this.provider = provider;
        if (provider.isEmpty()) {
            this.qualifiers = new HashSet<Annotation>();
            this.qualifiers.add((Annotation)DatabaseQualifier.ofKeyValue());
            this.qualifiers.add((Annotation)AnnotationLiteralUtil.DEFAULT_ANNOTATION);
        } else {
            this.qualifiers = Collections.singleton(DatabaseQualifier.ofKeyValue((String)provider));
        }
    }

    public Class<?> getBeanClass() {
        return this.type;
    }

    public Repository create(CreationalContext<Repository> creationalContext) {
        KeyValueTemplate repository = this.provider.isEmpty() ? (KeyValueTemplate)this.getInstance(KeyValueTemplate.class) : (KeyValueTemplate)this.getInstance(KeyValueTemplate.class, (Annotation)DatabaseQualifier.ofKeyValue((String)this.provider));
        KeyValueRepositoryProxy handler = new KeyValueRepositoryProxy(this.type, repository);
        return (Repository)Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, handler);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return this.type.getName() + '@' + DatabaseType.KEY_VALUE + "-" + this.provider;
    }
}

