/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.spi;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessProducer;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.DatabaseMetadata;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.Databases;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.query.RepositoryKeyValueBean;
import org.jnosql.artemis.key.spi.RepositoryUnitKeyValueBean;
import org.jnosql.artemis.key.spi.TemplateBean;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.artemis.util.RepositoryUnit;
import org.jnosql.diana.api.key.BucketManager;

public class BucketManagerProducerExtension
implements Extension {
    private static final Logger LOGGER = Logger.getLogger(BucketManagerProducerExtension.class.getName());
    private final Set<DatabaseMetadata> databases = new HashSet<DatabaseMetadata>();
    private final Collection<Class<?>> crudTypes = new HashSet();
    private final Collection<RepositoryUnit> repositoryUnits = new HashSet<RepositoryUnit>();

    <T, X extends BucketManager> void observes(@Observes ProcessProducer<T, X> pp) {
        Databases.addDatabase(pp, (DatabaseType)DatabaseType.KEY_VALUE, this.databases);
    }

    <T extends Repository> void observes(@Observes ProcessAnnotatedType<T> repo) {
        Class javaClass = repo.getAnnotatedType().getJavaClass();
        if (Repository.class.equals((Object)javaClass)) {
            return;
        }
        if (Arrays.asList(javaClass.getInterfaces()).contains(Repository.class) && Modifier.isInterface(javaClass.getModifiers())) {
            LOGGER.info("Adding a new KeyValueRepository as discovered on key-value: " + javaClass);
            this.crudTypes.add(repo.getAnnotatedType().getJavaClass());
        }
    }

    <T, R extends Repository<?, ?>> void observes(@Observes ProcessInjectionPoint<T, R> event) {
        InjectionPoint injectionPoint = event.getInjectionPoint();
        if (ConfigurationUnitUtils.hasConfigurationUnit((InjectionPoint)injectionPoint)) {
            ConfigurationUnit configurationUnit = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
            Type type = injectionPoint.getType();
            RepositoryUnit unitRepository = RepositoryUnit.of((Class)((Class)type), (ConfigurationUnit)configurationUnit);
            if (unitRepository.isKey()) {
                LOGGER.info(String.format("Found Repository to configuration unit key to configuration name %s fileName %s database: %s repository: %s", configurationUnit.name(), configurationUnit.fileName(), configurationUnit.database(), type.toString()));
                this.repositoryUnits.add(unitRepository);
            }
        }
    }

    void onAfterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        LOGGER.info(String.format("Processing buckets: %d databases crud %d ", this.databases.size(), this.crudTypes.size()));
        this.databases.forEach(type -> {
            TemplateBean bean = new TemplateBean(beanManager, type.getProvider());
            afterBeanDiscovery.addBean((Bean)bean);
        });
        this.crudTypes.forEach(type -> {
            if (!this.databases.contains(DatabaseMetadata.DEFAULT_KEY_VALUE)) {
                afterBeanDiscovery.addBean((Bean)new RepositoryKeyValueBean((Class)type, beanManager, ""));
            }
            this.databases.forEach(database -> afterBeanDiscovery.addBean((Bean)new RepositoryKeyValueBean((Class)type, beanManager, database.getProvider())));
        });
        this.repositoryUnits.forEach(type -> afterBeanDiscovery.addBean((Bean)new RepositoryUnitKeyValueBean(beanManager, (RepositoryUnit)type)));
    }
}

