/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.spi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationReader;
import org.jnosql.artemis.ConfigurationSettingsUnit;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.reflection.Reflections;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.BucketManagerFactory;
import org.jnosql.diana.api.key.KeyValueConfiguration;

@ApplicationScoped
class KeyValueConfigurationProducer {
    @Inject
    private Reflections reflections;
    @Inject
    private Instance<ConfigurationReader> configurationReader;

    KeyValueConfigurationProducer() {
    }

    @ConfigurationUnit
    @Produces
    public <T extends BucketManager> BucketManagerFactory<T> getGenerics(InjectionPoint injectionPoint) {
        return this.getBucketManagerFactory(injectionPoint);
    }

    @ConfigurationUnit
    @Produces
    public BucketManagerFactory get(InjectionPoint injectionPoint) {
        return this.getBucketManagerFactory(injectionPoint);
    }

    <T extends BucketManager> BucketManagerFactory<T> getBucketManagerFactory(ConfigurationUnit annotation) {
        ConfigurationSettingsUnit unit = ((ConfigurationReader)this.configurationReader.get()).read(annotation, KeyValueConfiguration.class);
        Class configurationClass = (Class)unit.getProvider().orElseThrow(() -> new IllegalStateException("The KeyValueConfiguration provider is required in the configuration"));
        KeyValueConfiguration configuration = (KeyValueConfiguration)this.reflections.newInstance(configurationClass);
        return configuration.get(unit.getSettings());
    }

    private <T extends BucketManager> BucketManagerFactory<T> getBucketManagerFactory(InjectionPoint injectionPoint) {
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
        return this.getBucketManagerFactory(annotation);
    }
}

