/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.spi;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jnosql.artemis.ConfigurationException;
import org.jnosql.artemis.ConfigurationUnit;
import org.jnosql.artemis.key.spi.KeyValueConfigurationProducer;
import org.jnosql.artemis.util.ConfigurationUnitUtils;
import org.jnosql.artemis.util.StringUtils;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.BucketManagerFactory;

@ApplicationScoped
class ManagerConfigurationProducer {
    @Inject
    private KeyValueConfigurationProducer configurationProducer;

    ManagerConfigurationProducer() {
    }

    @ConfigurationUnit
    @Produces
    public BucketManager get(InjectionPoint injectionPoint) {
        BucketManagerFactory bucketManagerFactory = this.configurationProducer.get(injectionPoint);
        ConfigurationUnit annotation = ConfigurationUnitUtils.getConfigurationUnit((InjectionPoint)injectionPoint);
        String database = annotation.database();
        if (StringUtils.isBlank((CharSequence)database)) {
            throw new ConfigurationException("The field database at ConfigurationUnit annotation is required");
        }
        return bucketManagerFactory.getBucketManager(database);
    }
}

