/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.Repository;
import org.jnosql.artemis.key.KeyValueRepositoryProducer;
import org.jnosql.artemis.key.spi.KeyValueConfigurationProducer;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.artemis.util.RepositoryUnit;
import org.jnosql.diana.api.key.BucketManager;
import org.jnosql.diana.api.key.BucketManagerFactory;

final class RepositoryUnitKeyValueBean
extends AbstractBean<Repository<?, ?>> {
    private final Set<Type> types;
    private final Set<Annotation> qualifiers;
    private final RepositoryUnit repositoryUnit;

    RepositoryUnitKeyValueBean(BeanManager beanManager, RepositoryUnit repositoryUnit) {
        super(beanManager);
        this.types = Collections.singleton(repositoryUnit.getRepository());
        this.qualifiers = Collections.singleton(repositoryUnit.getUnit());
        this.repositoryUnit = repositoryUnit;
    }

    public Class<?> getBeanClass() {
        return this.repositoryUnit.getRepository();
    }

    public Repository<?, ?> create(CreationalContext<Repository<?, ?>> context) {
        return this.get();
    }

    private <T, K, R extends Repository<T, K>> R get() {
        KeyValueRepositoryProducer producer = (KeyValueRepositoryProducer)this.getInstance(KeyValueRepositoryProducer.class);
        KeyValueConfigurationProducer configurationProducer = (KeyValueConfigurationProducer)this.getInstance(KeyValueConfigurationProducer.class);
        Class repository = this.repositoryUnit.getRepository();
        BucketManagerFactory managerFactory = configurationProducer.getBucketManagerFactory(this.repositoryUnit.getUnit());
        BucketManager bucketManager = managerFactory.getBucketManager(this.repositoryUnit.getDatabase());
        return producer.get(repository, bucketManager);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return "key-value: " + this.repositoryUnit.toString();
    }
}

