/*
 * Decompiled with CFR 0.152.
 */
package org.jnosql.artemis.key.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jnosql.artemis.DatabaseQualifier;
import org.jnosql.artemis.DatabaseType;
import org.jnosql.artemis.key.KeyValueTemplate;
import org.jnosql.artemis.key.KeyValueTemplateProducer;
import org.jnosql.artemis.spi.AbstractBean;
import org.jnosql.diana.api.key.BucketManager;

class TemplateBean
extends AbstractBean<KeyValueTemplate> {
    private final Set<Type> types = Collections.singleton(KeyValueTemplate.class);
    private final String provider;
    private final Set<Annotation> qualifiers;

    public TemplateBean(BeanManager beanManager, String provider) {
        super(beanManager);
        this.provider = provider;
        this.qualifiers = Collections.singleton(DatabaseQualifier.ofKeyValue((String)provider));
    }

    public Class<?> getBeanClass() {
        return KeyValueTemplate.class;
    }

    public KeyValueTemplate create(CreationalContext<KeyValueTemplate> creationalContext) {
        KeyValueTemplateProducer producer = (KeyValueTemplateProducer)this.getInstance(KeyValueTemplateProducer.class);
        BucketManager manager = this.getManager();
        return producer.get(manager);
    }

    private BucketManager getManager() {
        Bean bean = (Bean)this.getBeanManager().getBeans(BucketManager.class, new Annotation[]{DatabaseQualifier.ofKeyValue((String)this.provider)}).iterator().next();
        CreationalContext ctx = this.getBeanManager().createCreationalContext((Contextual)bean);
        return (BucketManager)this.getBeanManager().getReference(bean, BucketManager.class, ctx);
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public String getId() {
        return KeyValueTemplate.class.getName() + DatabaseType.COLUMN + "-" + this.provider;
    }
}

