/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import jodd.csselly.CSSellyException;

public enum Match {
    EQUALS("="){

        @Override
        public boolean compare(String attr, String val) {
            return val.equals(attr);
        }
    }
    ,
    INCLUDES("~="){

        @Override
        public boolean compare(String attr, String val) {
            int valLength = val.length();
            int attrLength = attr.length();
            if (attrLength == 0 || valLength == 0 || attrLength < valLength) {
                return false;
            }
            if (valLength == attrLength) {
                return val.equals(attr);
            }
            boolean inClass = false;
            int start = 0;
            for (int i = 0; i < attrLength; ++i) {
                char c = attr.charAt(i);
                if (c == ' ' || c == '\t') {
                    if (!inClass) continue;
                    if (i - start == valLength && attr.regionMatches(start, val, 0, valLength)) {
                        return true;
                    }
                    inClass = false;
                    continue;
                }
                if (inClass) continue;
                inClass = true;
                start = i;
            }
            if (inClass && attrLength - start == valLength) {
                return attr.regionMatches(start, val, 0, valLength);
            }
            return false;
        }
    }
    ,
    DASH("|="){

        @Override
        public boolean compare(String attr, String val) {
            return attr.equals(val) || attr.startsWith(val + '-');
        }
    }
    ,
    PREFIX("^="){

        @Override
        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.startsWith(val);
        }
    }
    ,
    SUFFIX("$="){

        @Override
        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.endsWith(val);
        }
    }
    ,
    SUBSTRING("*="){

        @Override
        public boolean compare(String attr, String val) {
            if (val.length() == 0) {
                return false;
            }
            return attr.contains(val);
        }
    };

    private final String sign;

    private Match(String sign) {
        this.sign = sign;
    }

    public String getSign() {
        return this.sign;
    }

    public abstract boolean compare(String var1, String var2);

    public static Match valueOfSign(String sign) {
        Match[] values;
        for (Match match : values = Match.values()) {
            if (!match.getSign().equals(sign)) continue;
            return match;
        }
        throw new CSSellyException("Invalid match sign: " + sign);
    }

    public static Match valueOfFirstChar(char firstChar) {
        Match[] values;
        for (Match match : values = Match.values()) {
            String matchSign = match.getSign();
            if (matchSign.length() <= 1 || firstChar != matchSign.charAt(0)) continue;
            return match;
        }
        return EQUALS;
    }
}

