/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jooq.meta.AbstractDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.UniqueKeyDefinition;

public class DefaultForeignKeyDefinition
extends AbstractDefinition
implements ForeignKeyDefinition {
    private final List<ColumnDefinition> keyColumns = new ArrayList<ColumnDefinition>();
    private final TableDefinition table;
    private final UniqueKeyDefinition uniqueKey;

    public DefaultForeignKeyDefinition(SchemaDefinition schema, String name, TableDefinition table, UniqueKeyDefinition uniqueKey) {
        super(schema.getDatabase(), schema, name, null);
        this.table = table;
        this.uniqueKey = uniqueKey;
    }

    @Override
    public List<Definition> getDefinitionPath() {
        ArrayList<Definition> result = new ArrayList<Definition>();
        result.addAll(this.getSchema().getDefinitionPath());
        result.add(this);
        return result;
    }

    @Override
    public TableDefinition getKeyTable() {
        return this.table;
    }

    @Override
    public List<ColumnDefinition> getKeyColumns() {
        return this.keyColumns;
    }

    @Override
    public UniqueKeyDefinition getReferencedKey() {
        return this.uniqueKey;
    }

    @Override
    public TableDefinition getReferencedTable() {
        return this.uniqueKey.getTable();
    }

    @Override
    public List<ColumnDefinition> getReferencedColumns() {
        return this.uniqueKey.getKeyColumns();
    }

    @Override
    public int countSimilarReferences() {
        HashSet<String> keys = new HashSet<String>();
        for (ForeignKeyDefinition key : this.getDatabase().getRelations().getForeignKeys(this.table)) {
            if (!key.getReferencedTable().equals(this.getReferencedTable())) continue;
            keys.add(key.getName());
        }
        return keys.size();
    }
}

