/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.impl;

import [Ljava.lang.String;;
import [[Lorg.jruby.runtime.builtin.IRubyObject;;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.util.Stack;
import jruby.objectweb.asm.ClassVisitor;
import jruby.objectweb.asm.ClassWriter;
import jruby.objectweb.asm.Label;
import jruby.objectweb.asm.MethodVisitor;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.Node;
import org.jruby.ast.executable.Script;
import org.jruby.compiler.ArrayCallback;
import org.jruby.compiler.BranchCallback;
import org.jruby.compiler.ClosureCallback;
import org.jruby.compiler.Compiler;
import org.jruby.evaluator.EvaluationState;
import org.jruby.exceptions.RaiseException;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.WrapperMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.MethodFactory;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.collections.SinglyLinkedList;

public class StandardASMCompiler
implements Compiler {
    private static final CodegenUtils cg;
    private static final String THREADCONTEXT;
    private static final String RUBY;
    private static final String IRUBYOBJECT;
    private static final String METHOD_SIGNATURE;
    private static final String CLOSURE_SIGNATURE;
    private static final int THREADCONTEXT_INDEX = 0;
    private static final int SELF_INDEX = 1;
    private static final int ARGS_INDEX = 2;
    private static final int CLOSURE_INDEX = 3;
    private static final int SCOPE_INDEX = 4;
    private static final int RUNTIME_INDEX = 5;
    private static final int LOCAL_VARS_INDEX = 6;
    private Stack methodVisitors = new Stack();
    private Stack arities = new Stack();
    private Stack scopeStarts = new Stack();
    private String classname;
    private String sourcename;
    private ClassWriter classWriter;
    ClassWriter currentMultiStub = null;
    int methodIndex = -1;
    int multiStubCount = -1;
    int innerIndex = -1;
    int lastLine = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StandardASMCompiler(String classname, String sourcename) {
        this.classname = classname;
        this.sourcename = sourcename;
    }

    public StandardASMCompiler(Node node) {
        this.classname = "EVAL" + this.hashCode();
        this.sourcename = "EVAL" + this.hashCode();
    }

    public Class loadClass(Ruby runtime) throws ClassNotFoundException {
        JRubyClassLoader jcl = runtime.getJRubyClassLoader();
        jcl.defineClass(CodegenUtils.c(this.classname), this.classWriter.toByteArray());
        return jcl.loadClass(CodegenUtils.c(this.classname));
    }

    public void writeClass(File destination) throws IOException {
        this.writeClass(this.classname, destination, this.classWriter);
    }

    private void writeClass(String classname, File destination, ClassWriter writer) throws IOException {
        String fullname = classname + ".class";
        String filename = null;
        String path = null;
        if (fullname.lastIndexOf("/") == -1) {
            filename = fullname;
            path = "";
        } else {
            filename = fullname.substring(fullname.lastIndexOf("/") + 1);
            path = fullname.substring(0, fullname.lastIndexOf("/"));
        }
        File pathfile = new File(destination, path);
        pathfile.mkdirs();
        FileOutputStream out = new FileOutputStream(new File(pathfile, filename));
        out.write(writer.toByteArray());
    }

    public String getClassname() {
        return this.classname;
    }

    public String getSourcename() {
        return this.sourcename;
    }

    public ClassVisitor getClassVisitor() {
        return this.classWriter;
    }

    public MethodVisitor getMethodVisitor() {
        return (MethodVisitor)this.methodVisitors.peek();
    }

    public MethodVisitor popMethodVisitor() {
        return (MethodVisitor)this.methodVisitors.pop();
    }

    public void pushMethodVisitor(MethodVisitor mv) {
        this.methodVisitors.push(mv);
    }

    public int getArity() {
        return (Integer)this.arities.peek();
    }

    public void pushArity(int arity) {
        this.arities.push(new Integer(arity));
    }

    public int popArity() {
        return (Integer)this.arities.pop();
    }

    public void pushScopeStart(Label start) {
        this.scopeStarts.push(start);
    }

    public Label popScopeStart() {
        return (Label)this.scopeStarts.pop();
    }

    public void startScript() {
        this.classWriter = new ClassWriter(true);
        String[] stringArray = new String[1];
        stringArray[0] = CodegenUtils.p(Script.class);
        this.classWriter.visit(46, 33, this.classname, null, CodegenUtils.p(Object.class), stringArray);
        this.classWriter.visitSource(this.sourcename, null);
        this.createConstructor();
    }

    public void endScript() {
        String methodName = "__file__";
        MethodVisitor mv = this.getClassVisitor().visitMethod(1, "run", METHOD_SIGNATURE, null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(25, 4);
        mv.visitMethodInsn(184, this.classname, methodName, METHOD_SIGNATURE);
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = this.getClassVisitor().visitMethod(9, "main", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String;.class)), null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, this.classname);
        mv.visitInsn(89);
        mv.visitMethodInsn(183, this.classname, "<init>", CodegenUtils.sig(Void.TYPE));
        mv.visitMethodInsn(184, CodegenUtils.p(Ruby.class), "getDefaultInstance", CodegenUtils.sig(Ruby.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(182, RUBY, "getCurrentContext", CodegenUtils.sig(ThreadContext.class));
        mv.visitInsn(95);
        mv.visitMethodInsn(182, RUBY, "getTopSelf", CodegenUtils.sig(IRubyObject.class));
        mv.visitInsn(1);
        mv.visitInsn(1);
        mv.visitMethodInsn(182, this.classname, "run", METHOD_SIGNATURE);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    private void createConstructor() {
        ClassVisitor cv = this.getClassVisitor();
        MethodVisitor mv = cv.visitMethod(1, "<init>", CodegenUtils.sig(Void.TYPE), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, CodegenUtils.p(Object.class), "<init>", CodegenUtils.sig(Void.TYPE));
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
    }

    public Object beginMethod(String friendlyName, int arity, int localVarCount) {
        MethodVisitor newMethod = this.getClassVisitor().visitMethod(9, friendlyName, METHOD_SIGNATURE, null, null);
        this.pushMethodVisitor(newMethod);
        newMethod.visitCode();
        newMethod.visitLdcInsn(new Integer(localVarCount));
        newMethod.visitTypeInsn(189, CodegenUtils.p(IRubyObject.class));
        newMethod.visitVarInsn(58, 6);
        newMethod.visitInsn(1);
        newMethod.visitVarInsn(58, 4);
        newMethod.visitVarInsn(25, 0);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
        newMethod.visitVarInsn(58, 5);
        Label start = new Label();
        newMethod.visitLabel(start);
        this.pushScopeStart(start);
        this.pushArity(arity);
        return newMethod;
    }

    public void endMethod(Object token) {
        if (!$assertionsDisabled && !(token instanceof MethodVisitor)) {
            throw new AssertionError();
        }
        MethodVisitor mv = (MethodVisitor)token;
        mv.visitInsn(176);
        Label end = new Label();
        mv.visitLabel(end);
        mv.visitLocalVariable("lvars", CodegenUtils.ci([Lorg.jruby.runtime.builtin.IRubyObject;.class), null, this.popScopeStart(), end, 6);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        this.popMethodVisitor();
        this.popArity();
    }

    public void lineNumber(ISourcePosition position) {
        this.lastLine = position.getEndLine();
        if (this.lastLine == this.lastLine) {
            return;
        }
        Label l = new Label();
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitLabel(l);
        mv.visitLineNumber(position.getEndLine(), l);
    }

    public void invokeDynamic(String name, boolean hasReceiver, boolean hasArgs, ClosureCallback closureArg) {
        MethodVisitor mv = this.getMethodVisitor();
        String callType = null;
        String callSig = CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, String.class, [Lorg.jruby.runtime.builtin.IRubyObject;.class, CallType.class, Block.class));
        Class clazz = IRubyObject.class;
        String callSigIndexed = CodegenUtils.sig(clazz, CodegenUtils.params(ThreadContext.class, Byte.TYPE, String.class, [Lorg.jruby.runtime.builtin.IRubyObject;.class, CallType.class, Block.class));
        byte index = MethodIndex.getIndex(name);
        if (hasArgs) {
            if (hasReceiver) {
                this.loadThreadContext();
                mv.visitInsn(95);
                callType = "NORMAL";
            } else {
                this.loadSelf();
                mv.visitInsn(95);
                this.loadThreadContext();
                mv.visitInsn(95);
                callType = "FUNCTIONAL";
            }
            if (index != 0) {
                mv.visitLdcInsn(new Byte(index));
                mv.visitInsn(95);
            }
            mv.visitLdcInsn(name);
            mv.visitInsn(95);
        } else {
            if (hasReceiver) {
                this.loadThreadContext();
                callType = "FUNCTIONAL";
            } else {
                this.loadSelf();
                this.loadThreadContext();
                callType = "VARIABLE";
            }
            if (index != 0) {
                mv.visitLdcInsn(new Byte(index));
            }
            mv.visitLdcInsn(name);
            String string = CodegenUtils.p(IRubyObject.class);
            mv.visitFieldInsn(178, string, "NULL_ARRAY", CodegenUtils.ci([Lorg.jruby.runtime.builtin.IRubyObject;.class));
        }
        String string = CodegenUtils.p(CallType.class);
        mv.visitFieldInsn(178, string, callType, CodegenUtils.ci(CallType.class));
        if (closureArg == null) {
            mv.visitInsn(1);
        } else {
            closureArg.compile(this);
        }
        if (index != 0) {
            this.invokeIRubyObject("callMethod", callSigIndexed);
        } else {
            this.invokeIRubyObject("callMethod", callSig);
        }
    }

    public void yield(boolean hasArgs) {
        this.loadClosure();
        MethodVisitor method = this.getMethodVisitor();
        method.visitInsn(89);
        this.loadThreadContext();
        method.visitInsn(95);
        this.invokeThreadContext("raiseErrorIfNoBlock", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Block.class)));
        if (hasArgs) {
            method.visitInsn(95);
            this.loadThreadContext();
            method.visitInsn(95);
        } else {
            this.loadThreadContext();
            method.visitInsn(1);
        }
        this.loadSelf();
        this.getRubyClass();
        method.visitLdcInsn(Boolean.FALSE);
        String string = CodegenUtils.p(Block.class);
        method.visitMethodInsn(182, string, "yield", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, IRubyObject.class, RubyModule.class, Boolean.TYPE)));
    }

    private void invokeIRubyObject(String methodName, String signature) {
        this.getMethodVisitor().visitMethodInsn(185, IRUBYOBJECT, methodName, signature);
    }

    public void loadThreadContext() {
        this.getMethodVisitor().visitVarInsn(25, 0);
    }

    public void loadClosure() {
        this.getMethodVisitor().visitVarInsn(25, 3);
    }

    public void loadSelf() {
        this.getMethodVisitor().visitVarInsn(25, 1);
    }

    public void loadRuntime() {
        this.getMethodVisitor().visitVarInsn(25, 5);
    }

    public void loadNil() {
        this.loadRuntime();
        this.invokeIRuby("getNil", CodegenUtils.sig(IRubyObject.class));
    }

    public void consumeCurrentValue() {
        this.getMethodVisitor().visitInsn(87);
    }

    public void retrieveSelf() {
        this.loadSelf();
    }

    public void assignLocalVariable(int index) {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(25, 6);
        mv.visitInsn(95);
        mv.visitLdcInsn(new Integer(index));
        mv.visitInsn(95);
        mv.visitInsn(83);
    }

    public void retrieveLocalVariable(int index) {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitVarInsn(25, 6);
        mv.visitLdcInsn(new Integer(index));
        mv.visitInsn(50);
    }

    public void assignLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.assignLocalVariable(index);
            return;
        }
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitInsn(89);
        mv.visitVarInsn(25, 4);
        mv.visitLdcInsn(new Integer(depth - 1));
        mv.visitInsn(50);
        mv.visitInsn(95);
        mv.visitLdcInsn(new Integer(index));
        mv.visitInsn(95);
        mv.visitInsn(83);
    }

    public void retrieveLocalVariable(int index, int depth) {
        if (depth == 0) {
            this.retrieveLocalVariable(index);
            return;
        }
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitVarInsn(25, 4);
        mv.visitLdcInsn(new Integer(depth - 1));
        mv.visitInsn(50);
        mv.visitLdcInsn(new Integer(index));
        mv.visitInsn(50);
    }

    public void retrieveConstant(String name) {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadThreadContext();
        mv.visitLdcInsn(name);
        this.invokeThreadContext("getConstant", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    public void createNewFixnum(long value) {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadRuntime();
        mv.visitLdcInsn(new Long(value));
        this.invokeIRuby("newFixnum", CodegenUtils.sig(RubyFixnum.class, CodegenUtils.params(Long.TYPE)));
    }

    public void createNewBignum(BigInteger value) {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadRuntime();
        mv.visitLdcInsn(value.toString());
        Class clazz = RubyBignum.class;
        mv.visitMethodInsn(184, CodegenUtils.p(RubyBignum.class), "newBignum", CodegenUtils.sig(clazz, CodegenUtils.params(Ruby.class, String.class)));
    }

    public void createNewString(ByteList value) {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadRuntime();
        mv.visitLdcInsn(value.toString());
        this.invokeIRuby("newString", CodegenUtils.sig(RubyString.class, CodegenUtils.params(String.class)));
    }

    public void createNewSymbol(String name) {
        this.loadRuntime();
        this.getMethodVisitor().visitLdcInsn(name);
        this.invokeIRuby("newSymbol", CodegenUtils.sig(RubySymbol.class, CodegenUtils.params(String.class)));
    }

    public void createNewArray() {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadRuntime();
        mv.visitInsn(95);
        this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params([Lorg.jruby.runtime.builtin.IRubyObject;.class)));
    }

    public void createEmptyArray() {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadRuntime();
        this.invokeIRuby("newArray", CodegenUtils.sig(RubyArray.class, cg.params()));
    }

    public void createObjectArray(Object[] sourceArray, ArrayCallback callback) {
        this.buildObjectArray(IRUBYOBJECT, sourceArray, callback);
    }

    private void buildObjectArray(String type, Object[] sourceArray, ArrayCallback callback) {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitLdcInsn(new Integer(sourceArray.length));
        mv.visitTypeInsn(189, type);
        for (int i = 0; i < sourceArray.length; ++i) {
            mv.visitInsn(89);
            mv.visitLdcInsn(new Integer(i));
            callback.nextValue(this, sourceArray, i);
            mv.visitInsn(83);
        }
    }

    private void isTrue() {
        this.invokeIRubyObject("isTrue", CodegenUtils.sig(Boolean.TYPE));
    }

    public void performBooleanBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        MethodVisitor mv = this.getMethodVisitor();
        this.isTrue();
        mv.visitJumpInsn(153, falseJmp);
        trueBranch.branch(this);
        mv.visitJumpInsn(167, afterJmp);
        mv.visitLabel(falseJmp);
        falseBranch.branch(this);
        mv.visitLabel(afterJmp);
    }

    public void performLogicalAnd(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitInsn(89);
        this.isTrue();
        mv.visitJumpInsn(153, falseJmp);
        mv.visitInsn(87);
        longBranch.branch(this);
        mv.visitLabel(falseJmp);
    }

    public void performLogicalOr(BranchCallback longBranch) {
        Label afterJmp = new Label();
        Label falseJmp = new Label();
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitInsn(89);
        this.isTrue();
        mv.visitJumpInsn(154, falseJmp);
        mv.visitInsn(87);
        longBranch.branch(this);
        mv.visitLabel(falseJmp);
    }

    public void performBooleanLoop(BranchCallback condition, BranchCallback body, boolean checkFirst) {
        MethodVisitor mv = this.getMethodVisitor();
        Label endJmp = new Label();
        if (checkFirst) {
            condition.branch(this);
            this.isTrue();
            mv.visitJumpInsn(153, endJmp);
        }
        Label topJmp = new Label();
        mv.visitLabel(topJmp);
        body.branch(this);
        mv.visitInsn(87);
        condition.branch(this);
        this.isTrue();
        mv.visitJumpInsn(154, topJmp);
        if (checkFirst) {
            mv.visitLabel(endJmp);
        }
        this.loadNil();
    }

    public static CompiledBlock createBlock(ThreadContext context, IRubyObject self, int arity, IRubyObject[][] scopes, CompiledBlockCallback callback) {
        return new CompiledBlock(context, self, Arity.createArity(arity), scopes, callback);
    }

    public void createNewClosure(StaticScope scope, int arity, ClosureCallback body) {
        ClassVisitor cv = this.getClassVisitor();
        String closureMethodName = "closure" + ++this.innerIndex;
        String closureFieldName = "_" + closureMethodName;
        cv.visitField(10, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class), null, null);
        MethodVisitor method = cv.visitMethod(9, closureMethodName, CLOSURE_SIGNATURE, null, null);
        this.pushMethodVisitor(method);
        method.visitCode();
        method.visitLdcInsn(new Integer(scope.getNumberOfVariables()));
        method.visitTypeInsn(189, CodegenUtils.p(IRubyObject.class));
        method.visitVarInsn(58, 6);
        if (arity != 0) {
            // empty if block
        }
        method.visitVarInsn(25, 0);
        this.invokeThreadContext("getRuntime", CodegenUtils.sig(Ruby.class));
        method.visitVarInsn(58, 5);
        Label start = new Label();
        method.visitLabel(start);
        body.compile(this);
        method.visitInsn(176);
        Label end = new Label();
        method.visitLabel(end);
        method.visitMaxs(1, 1);
        method.visitEnd();
        this.popMethodVisitor();
        method = this.getMethodVisitor();
        method.visitFieldInsn(178, this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        Label alreadyCreated = new Label();
        method.visitJumpInsn(199, alreadyCreated);
        this.getCallbackFactory();
        method.visitLdcInsn(closureMethodName);
        Class clazz = CompiledBlockCallback.class;
        method.visitMethodInsn(182, CodegenUtils.p(CallbackFactory.class), "getBlockCallback", CodegenUtils.sig(clazz, CodegenUtils.params(String.class)));
        method.visitFieldInsn(179, this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        method.visitLabel(alreadyCreated);
        this.loadThreadContext();
        this.loadSelf();
        method.visitLdcInsn(new Integer(arity));
        method.visitVarInsn(25, 4);
        Label noScopes = new Label();
        Label copyLocals = new Label();
        method.visitJumpInsn(198, noScopes);
        method.visitVarInsn(25, 4);
        method.visitInsn(190);
        method.visitInsn(4);
        method.visitInsn(96);
        method.visitTypeInsn(189, CodegenUtils.p([Lorg.jruby.runtime.builtin.IRubyObject;.class));
        method.visitInsn(89);
        method.visitVarInsn(25, 4);
        method.visitInsn(95);
        method.visitInsn(3);
        method.visitInsn(95);
        method.visitInsn(4);
        method.visitVarInsn(25, 4);
        method.visitInsn(190);
        method.visitMethodInsn(184, CodegenUtils.p(System.class), "arraycopy", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE)));
        method.visitJumpInsn(167, copyLocals);
        method.visitLabel(noScopes);
        method.visitInsn(4);
        method.visitTypeInsn(189, CodegenUtils.p([Lorg.jruby.runtime.builtin.IRubyObject;.class));
        method.visitLabel(copyLocals);
        method.visitInsn(89);
        method.visitInsn(3);
        method.visitVarInsn(25, 6);
        method.visitInsn(83);
        method.visitFieldInsn(178, this.classname, closureFieldName, CodegenUtils.ci(CompiledBlockCallback.class));
        method.visitMethodInsn(184, CodegenUtils.p(StandardASMCompiler.class), "createBlock", CodegenUtils.sig(CompiledBlock.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Integer.TYPE, IRubyObject;.class, CompiledBlockCallback.class)));
    }

    private void invokeThreadContext(String methodName, String signature) {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitMethodInsn(182, THREADCONTEXT, methodName, signature);
    }

    private void invokeIRuby(String methodName, String signature) {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitMethodInsn(182, RUBY, methodName, signature);
    }

    private void getCallbackFactory() {
        this.loadRuntime();
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitLdcInsn(this.classname);
        Class clazz = Class.class;
        mv.visitMethodInsn(184, CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(clazz, CodegenUtils.params(String.class)));
        this.invokeIRuby("callbackFactory", CodegenUtils.sig(CallbackFactory.class, CodegenUtils.params(Class.class)));
    }

    private void getRubyClass() {
        this.loadSelf();
        this.invokeIRubyObject("getMetaClass", CodegenUtils.sig(RubyClass.class));
    }

    private void getCRef() {
        this.loadThreadContext();
        this.invokeThreadContext("peekCRef", CodegenUtils.sig(SinglyLinkedList.class));
    }

    private void newTypeError(String error) {
        this.loadRuntime();
        this.getMethodVisitor().visitLdcInsn(error);
        this.invokeIRuby("newTypeError", CodegenUtils.sig(RaiseException.class, CodegenUtils.params(String.class)));
    }

    private void getCurrentVisibility() {
        this.loadThreadContext();
        this.invokeThreadContext("getCurrentVisibility", CodegenUtils.sig(Visibility.class));
    }

    private void println() {
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitInsn(89);
        mv.visitFieldInsn(178, CodegenUtils.p(System.class), "out", CodegenUtils.ci(PrintStream.class));
        mv.visitInsn(95);
        String string = CodegenUtils.p(PrintStream.class);
        mv.visitMethodInsn(182, string, "println", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class)));
    }

    public void defineAlias(String newName, String oldName) {
        this.getRubyClass();
        this.getMethodVisitor().visitLdcInsn(newName);
        this.getMethodVisitor().visitLdcInsn(oldName);
        this.getMethodVisitor().visitMethodInsn(182, CodegenUtils.p(RubyModule.class), "defineAlias", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(String.class, String.class)));
        this.loadNil();
    }

    public static IRubyObject def(ThreadContext context, IRubyObject self, Class compiledClass, String name, String javaName, int arity) {
        Ruby runtime = context.getRuntime();
        RubyClass containingClass = self.getMetaClass();
        if (containingClass == null) {
            throw runtime.newTypeError("No class to add method.");
        }
        if (containingClass == runtime.getObject() && name == "initialize") {
            runtime.getWarnings().warn("redefining Object#initialize may cause infinite loop");
        }
        Visibility visibility = context.getCurrentVisibility();
        if (name == "initialize" || visibility.isModuleFunction() || context.isTopLevel()) {
            visibility = Visibility.PRIVATE;
        }
        SinglyLinkedList cref = context.peekCRef();
        MethodFactory factory = MethodFactory.createFactory();
        DynamicMethod method = factory.getCompiledMethod(containingClass, compiledClass, javaName, Arity.createArity(arity), visibility, cref);
        containingClass.addMethod(name, method);
        if (context.getCurrentVisibility().isModuleFunction()) {
            containingClass.getSingletonClass().addMethod(name, new WrapperMethod(containingClass.getSingletonClass(), method, Visibility.PUBLIC));
            containingClass.callMethod(context, "singleton_method_added", runtime.newSymbol(name));
        }
        if (((RubyModule)containingClass).isSingleton()) {
            ((MetaClass)containingClass).getAttachedObject().callMethod(context, "singleton_method_added", runtime.newSymbol(name));
        } else {
            containingClass.callMethod(context, "method_added", runtime.newSymbol(name));
        }
        return runtime.getNil();
    }

    public void defineNewMethod(String name, int arity, int localVarCount, ClosureCallback body) {
        ++this.methodIndex;
        String methodName = name + "__" + this.methodIndex;
        this.beginMethod(methodName, arity, localVarCount);
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitCode();
        mv.visitVarInsn(25, 2);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 6);
        mv.visitInsn(5);
        mv.visitLdcInsn(new Integer(arity));
        mv.visitMethodInsn(184, CodegenUtils.p(System.class), "arraycopy", CodegenUtils.sig(Void.TYPE, CodegenUtils.params(Object.class, Integer.TYPE, Object.class, Integer.TYPE, Integer.TYPE)));
        mv.visitInsn(1);
        mv.visitVarInsn(58, 4);
        body.compile(this);
        this.endMethod(mv);
        mv = this.getMethodVisitor();
        this.loadThreadContext();
        this.loadSelf();
        mv.visitLdcInsn(this.classname.replace('/', '.'));
        Class clazz = Class.class;
        mv.visitMethodInsn(184, CodegenUtils.p(Class.class), "forName", CodegenUtils.sig(clazz, CodegenUtils.params(String.class)));
        mv.visitLdcInsn(name);
        mv.visitLdcInsn(methodName);
        mv.visitLdcInsn(new Integer(arity));
        mv.visitMethodInsn(184, CodegenUtils.p(StandardASMCompiler.class), "def", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(ThreadContext.class, IRubyObject.class, Class.class, String.class, String.class, Integer.TYPE)));
    }

    public void loadFalse() {
        this.loadRuntime();
        this.invokeIRuby("getFalse", CodegenUtils.sig(RubyBoolean.class));
    }

    public void loadTrue() {
        this.loadRuntime();
        this.invokeIRuby("getTrue", CodegenUtils.sig(RubyBoolean.class));
    }

    public void retrieveInstanceVariable(String name) {
        this.loadSelf();
        MethodVisitor mv = this.getMethodVisitor();
        mv.visitLdcInsn(name);
        this.invokeIRubyObject("getInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
        mv.visitInsn(89);
        Label notNull = new Label();
        mv.visitJumpInsn(199, notNull);
        mv.visitInsn(87);
        this.loadNil();
        mv.visitLabel(notNull);
    }

    public void assignInstanceVariable(String name) {
        MethodVisitor mv = this.getMethodVisitor();
        this.loadSelf();
        mv.visitInsn(95);
        mv.visitLdcInsn(name);
        mv.visitInsn(95);
        this.invokeIRubyObject("setInstanceVariable", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    public void retrieveGlobalVariable(String name) {
        this.loadRuntime();
        MethodVisitor mv = this.getMethodVisitor();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
        mv.visitLdcInsn(name);
        String string = CodegenUtils.p(GlobalVariables.class);
        mv.visitMethodInsn(182, string, "get", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class)));
    }

    public void assignGlobalVariable(String name) {
        this.loadRuntime();
        MethodVisitor mv = this.getMethodVisitor();
        this.invokeIRuby("getGlobalVariables", CodegenUtils.sig(GlobalVariables.class));
        mv.visitInsn(95);
        mv.visitLdcInsn(name);
        mv.visitInsn(95);
        String string = CodegenUtils.p(GlobalVariables.class);
        mv.visitMethodInsn(182, string, "set", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(String.class, IRubyObject.class)));
    }

    public void negateCurrentValue() {
        MethodVisitor mv = this.getMethodVisitor();
        this.isTrue();
        Label isTrue = new Label();
        Label end = new Label();
        mv.visitJumpInsn(154, isTrue);
        this.loadTrue();
        mv.visitJumpInsn(167, end);
        mv.visitLabel(isTrue);
        this.loadFalse();
        mv.visitLabel(end);
    }

    public void splatCurrentValue() {
        MethodVisitor method = this.getMethodVisitor();
        method.visitMethodInsn(184, CodegenUtils.p(EvaluationState.class), "splatValue", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void singlifySplattedValue() {
        MethodVisitor method = this.getMethodVisitor();
        method.visitMethodInsn(184, CodegenUtils.p(EvaluationState.class), "aValueSplat", CodegenUtils.sig(IRubyObject.class, CodegenUtils.params(IRubyObject.class)));
    }

    public void ensureRubyArray() {
        MethodVisitor method = this.getMethodVisitor();
        method.visitMethodInsn(184, CodegenUtils.p(StandardASMCompiler.class), "ensureRubyArray", CodegenUtils.sig(RubyArray.class, CodegenUtils.params(IRubyObject.class)));
    }

    public static RubyArray ensureRubyArray(IRubyObject value) {
        if (!(value instanceof RubyArray)) {
            value = RubyArray.newArray(value.getRuntime(), value);
        }
        return (RubyArray)value;
    }

    public void forEachInValueArray(int start, int count, Object source, ArrayCallback callback) {
        MethodVisitor method = this.getMethodVisitor();
        Label noMoreArrayElements = new Label();
        while (start < count) {
            method.visitInsn(89);
            method.visitMethodInsn(182, CodegenUtils.p(class$org$jruby$RubyArray == null ? StandardASMCompiler.class$("org.jruby.RubyArray") : class$org$jruby$RubyArray), "getLength", CodegenUtils.sig(Integer.TYPE, cg.params()));
            method.visitLdcInsn(new Integer(start));
            method.visitJumpInsn(158, noMoreArrayElements);
            method.visitInsn(89);
            method.visitLdcInsn(new Integer(start));
            method.visitMethodInsn(182, CodegenUtils.p(class$org$jruby$RubyArray == null ? StandardASMCompiler.class$("org.jruby.RubyArray") : class$org$jruby$RubyArray), "entry", CodegenUtils.sig(class$org$jruby$runtime$builtin$IRubyObject == null ? StandardASMCompiler.class$("org.jruby.runtime.builtin.IRubyObject") : class$org$jruby$runtime$builtin$IRubyObject, CodegenUtils.params(Long.TYPE)));
            callback.nextValue(this, source, start);
            ++start;
        }
        method.visitLabel(noMoreArrayElements);
    }

    public void loadInteger(int value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performGEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performGTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performLEBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void performLTBranch(BranchCallback trueBranch, BranchCallback falseBranch) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void loadRubyArraySize() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static {
        $assertionsDisabled = !StandardASMCompiler.class.desiredAssertionStatus();
        cg = CodegenUtils.instance;
        THREADCONTEXT = CodegenUtils.p(ThreadContext.class);
        RUBY = CodegenUtils.p(Ruby.class);
        IRUBYOBJECT = CodegenUtils.p(IRubyObject.class);
        METHOD_SIGNATURE = CodegenUtils.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, [Lorg.jruby.runtime.builtin.IRubyObject;.class, Block.class});
        CLOSURE_SIGNATURE = CodegenUtils.sig(IRubyObject.class, new Class[]{ThreadContext.class, IRubyObject.class, [Lorg.jruby.runtime.builtin.IRubyObject;.class, Block.class, IRubyObject;.class});
    }
}

