/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaConstructor;
import org.jruby.javasupport.JavaField;
import org.jruby.javasupport.JavaMethod;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.JavaProxyClass;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class Java {
    static /* synthetic */ Class class$java$lang$Object;

    public static RubyModule createJavaModule(Ruby runtime) {
        RubyModule javaModule = runtime.defineModule("Java");
        CallbackFactory callbackFactory = runtime.callbackFactory(Java.class);
        javaModule.defineModuleFunction("define_exception_handler", callbackFactory.getOptSingletonMethod("define_exception_handler"));
        javaModule.defineModuleFunction("primitive_to_java", callbackFactory.getSingletonMethod("primitive_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_primitive", callbackFactory.getSingletonMethod("java_to_primitive", IRubyObject.class));
        javaModule.defineModuleFunction("java_to_ruby", callbackFactory.getSingletonMethod("java_to_ruby", IRubyObject.class));
        javaModule.defineModuleFunction("ruby_to_java", callbackFactory.getSingletonMethod("ruby_to_java", IRubyObject.class));
        javaModule.defineModuleFunction("new_proxy_instance", callbackFactory.getOptSingletonMethod("new_proxy_instance"));
        JavaObject.createJavaObjectClass(runtime, javaModule);
        JavaArray.createJavaArrayClass(runtime, javaModule);
        JavaClass.createJavaClassClass(runtime, javaModule);
        JavaMethod.createJavaMethodClass(runtime, javaModule);
        JavaConstructor.createJavaConstructorClass(runtime, javaModule);
        JavaField.createJavaFieldClass(runtime, javaModule);
        JavaProxyClass.createJavaProxyModule(runtime);
        return javaModule;
    }

    public static IRubyObject define_exception_handler(IRubyObject recv, IRubyObject[] args, Block block) {
        String name = args[0].toString();
        RubyProc handler = null;
        handler = args.length > 1 ? (RubyProc)args[1] : recv.getRuntime().newProc(false, block);
        recv.getRuntime().getJavaSupport().defineExceptionHandler(name, handler);
        return recv;
    }

    public static IRubyObject primitive_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime = recv.getRuntime();
        switch (object.getMetaClass().index) {
            case 5: {
                javaObject = null;
                break;
            }
            case 1: {
                javaObject = new Long(((RubyFixnum)object).getLongValue());
                break;
            }
            case 2: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case 11: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case 4: {
                javaObject = ((RubyString)object).toString();
                break;
            }
            case 6: {
                javaObject = Boolean.TRUE;
                break;
            }
            case 7: {
                javaObject = Boolean.FALSE;
                break;
            }
            default: {
                javaObject = object instanceof RubyTime ? ((RubyTime)object).getJavaDate() : object;
            }
        }
        return JavaObject.wrap(runtime, javaObject);
    }

    public static IRubyObject java_to_ruby(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            object = JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        if (object instanceof JavaObject) {
            return recv.getRuntime().getModule("JavaUtilities").callMethod(recv.getRuntime().getCurrentContext(), "wrap", object);
        }
        return object;
    }

    public static IRubyObject ruby_to_java(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result = object.getInstanceVariable("@java_object");
            if (result == null) {
                result = object.callMethod(recv.getRuntime().getCurrentContext(), "to_java_object");
            }
            return result;
        }
        return Java.primitive_to_java(recv, object, unusedBlock);
    }

    public static IRubyObject java_to_primitive(IRubyObject recv, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    public static IRubyObject new_proxy_instance(final IRubyObject recv, IRubyObject[] args, Block block) {
        RubyProc proc;
        int size = recv.checkArgumentCount(args, 1, -1) - 1;
        if (args[size] instanceof RubyProc) {
            proc = (RubyProc)args[size];
        } else {
            proc = recv.getRuntime().newProc(false, block);
            ++size;
        }
        Class[] interfaces = new Class[size];
        for (int i = 0; i < size; ++i) {
            if (!(args[i] instanceof JavaClass) || !((JavaClass)args[i]).interface_p().isTrue()) {
                throw recv.getRuntime().newArgumentError("Java interface expected.");
            }
            interfaces[i] = ((JavaClass)args[i]).javaClass();
        }
        return JavaObject.wrap(recv.getRuntime(), Proxy.newProxyInstance(recv.getRuntime().getJavaSupport().getJavaClassLoader(), interfaces, new InvocationHandler(){

            public Object invoke(Object proxy, Method method, Object[] nargs) throws Throwable {
                int methodArgsLength = method.getParameterTypes().length;
                String methodName = method.getName();
                if (methodName.equals("toString") && methodArgsLength == 0) {
                    return proxy.getClass().getName();
                }
                if (methodName.equals("hashCode") && methodArgsLength == 0) {
                    return new Integer(proxy.getClass().hashCode());
                }
                if (methodName.equals("equals") && methodArgsLength == 1 && method.getParameterTypes()[0].equals(class$java$lang$Object == null ? (class$java$lang$Object = Java.class$("java.lang.Object")) : class$java$lang$Object)) {
                    return proxy == nargs[0];
                }
                int length = nargs == null ? 0 : nargs.length;
                IRubyObject[] rubyArgs = new IRubyObject[length + 2];
                rubyArgs[0] = JavaObject.wrap(recv.getRuntime(), proxy);
                rubyArgs[1] = new JavaMethod(recv.getRuntime(), method);
                for (int i = 0; i < length; ++i) {
                    rubyArgs[i + 2] = JavaObject.wrap(recv.getRuntime(), nargs[i]);
                }
                return JavaUtil.convertArgument(proc.call(rubyArgs), method.getReturnType());
            }
        }));
    }
}

