/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyProc;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class ProcMetaClass
extends ObjectMetaClass {
    private static ObjectAllocator PROC_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            RubyProc instance = RubyProc.newProc(runtime, false);
            instance.setMetaClass(klass);
            return instance;
        }
    };

    public ProcMetaClass(Ruby runtime) {
        super("Proc", RubyProc.class, runtime.getObject(), PROC_ALLOCATOR);
    }

    public ProcMetaClass(String name, RubyClass superClass, ObjectAllocator allocator, SinglyLinkedList parentCRef) {
        super(name, RubyProc.class, superClass, allocator, parentCRef);
    }

    protected AbstractMetaClass.Meta getMeta() {
        return new ProcMeta();
    }

    public IRubyObject newInstance(IRubyObject[] args, Block block) {
        IRubyObject obj = this.allocate();
        if (!block.isGiven()) {
            block = this.getRuntime().getCurrentContext().getPreviousFrame().getBlock();
        }
        obj.callInit(args, block);
        return obj;
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new ProcMetaClass(name, (RubyClass)this, PROC_ALLOCATOR, parentCRef);
    }

    protected class ProcMeta
    extends AbstractMetaClass.Meta {
        protected ProcMeta() {
        }

        protected void initializeClass() {
            ProcMetaClass.this.defineFastMethod("arity", Arity.noArguments(), "arity");
            ProcMetaClass.this.defineFastMethod("binding", Arity.noArguments(), "binding");
            ProcMetaClass.this.defineMethod("call", Arity.optional(), "call");
            ProcMetaClass.this.defineAlias("[]", "call");
            ProcMetaClass.this.defineFastMethod("to_proc", Arity.noArguments(), "to_proc");
            ProcMetaClass.this.defineMethod("initialize", Arity.optional());
            ProcMetaClass.this.defineSingletonMethod("new", Arity.optional(), "newInstance");
        }
    }
}

