/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.Serializable;

public class ByteList
implements Comparable,
CharSequence,
Serializable {
    private static final long serialVersionUID = -1286166947275543731L;
    public static final byte[] NULL_ARRAY = new byte[0];
    public byte[] bytes;
    public int realSize;
    private static final int DEFAULT_SIZE = 4;
    private static final double FACTOR = 1.5;

    public ByteList() {
        this(4);
    }

    public ByteList(int size) {
        this.bytes = new byte[size];
        this.realSize = 0;
    }

    public ByteList(byte[] wrap) {
        this(wrap, true);
    }

    public ByteList(byte[] wrap, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        this.bytes = copy ? (byte[])wrap.clone() : wrap;
        this.realSize = wrap.length;
    }

    public ByteList(ByteList wrap) {
        this(wrap.bytes, 0, wrap.realSize);
    }

    public ByteList(byte[] wrap, int index, int len) {
        this(wrap, index, len, true);
    }

    public ByteList(byte[] wrap, int index, int len, boolean copy) {
        if (wrap == null) {
            throw new NullPointerException("Invalid argument: constructing with null array");
        }
        if (copy || index != 0) {
            this.bytes = new byte[len];
            System.arraycopy(wrap, index, this.bytes, 0, len);
        } else {
            this.bytes = wrap;
        }
        this.realSize = len;
    }

    public ByteList(ByteList wrap, int index, int len) {
        this(wrap.bytes, index, len);
    }

    public void delete(int start, int len) {
        this.realSize -= len;
        System.arraycopy(this.bytes, start + len, this.bytes, start, this.realSize);
    }

    public void append(byte b) {
        this.grow(1);
        this.bytes[this.realSize++] = b;
    }

    public void append(int b) {
        this.append((byte)b);
    }

    public void prepend(byte b) {
        this.grow(1);
        System.arraycopy(this.bytes, 0, this.bytes, 1, this.realSize);
        this.bytes[0] = b;
        ++this.realSize;
    }

    public void append(byte[] moreBytes) {
        this.grow(moreBytes.length);
        System.arraycopy(moreBytes, 0, this.bytes, this.realSize, moreBytes.length);
        this.realSize += moreBytes.length;
    }

    public void append(ByteList moreBytes) {
        this.append(moreBytes.bytes, 0, moreBytes.realSize);
    }

    public void append(ByteList moreBytes, int index, int len) {
        this.append(moreBytes.bytes, index, len);
    }

    public void append(byte[] moreBytes, int start, int len) {
        this.grow(len);
        System.arraycopy(moreBytes, start, this.bytes, this.realSize, len);
        this.realSize += len;
    }

    public int length() {
        return this.realSize;
    }

    public void length(int newLength) {
        this.grow(newLength - this.realSize);
        this.realSize = newLength;
    }

    public int get(int index) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.bytes[index];
    }

    public void set(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.bytes[index] = (byte)b;
    }

    public void replace(byte[] newBytes) {
        if (newBytes == null) {
            throw new NullPointerException("Invalid argument: replacing with null array");
        }
        this.bytes = newBytes;
        this.realSize = newBytes.length;
    }

    public void unsafeReplace(int beg, int len, ByteList nbytes) {
        this.unsafeReplace(beg, len, nbytes.bytes, 0, nbytes.realSize);
    }

    public void unsafeReplace(int beg, int len, byte[] buf) {
        this.unsafeReplace(beg, len, buf, 0, buf.length);
    }

    public void unsafeReplace(int beg, int len, byte[] nbytes, int index, int count) {
        this.grow(count - len);
        int newSize = this.realSize + count - len;
        System.arraycopy(this.bytes, beg + len, this.bytes, beg + count, this.realSize - (len + beg));
        System.arraycopy(nbytes, index, this.bytes, beg, count);
        this.realSize = newSize;
    }

    public void replace(int beg, int len, ByteList nbytes) {
        this.replace(beg, len, nbytes.bytes, 0, nbytes.realSize);
    }

    public void replace(int beg, int len, byte[] buf) {
        this.replace(beg, len, buf, 0, buf.length);
    }

    public void replace(int beg, int len, byte[] nbytes, int index, int count) {
        if (len - beg > this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.unsafeReplace(beg, len, nbytes, index, count);
    }

    public void insert(int index, int b) {
        if (index >= this.realSize) {
            throw new IndexOutOfBoundsException();
        }
        this.grow(1);
        System.arraycopy(this.bytes, index, this.bytes, index + 1, this.realSize - index);
        this.bytes[index] = (byte)b;
        ++this.realSize;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ByteList) {
            ByteList b = (ByteList)other;
            if (b.realSize != this.realSize) {
                return false;
            }
            for (int i = 0; i < this.realSize; ++i) {
                if (this.bytes[i] == b.bytes[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Object other) {
        return this.cmp((ByteList)other);
    }

    public int cmp(ByteList other) {
        if (other == this || other.bytes == this.bytes) {
            return 0;
        }
        int len = Math.min(this.realSize, other.realSize);
        int retval = 0;
        for (int i = 0; i < len && retval == 0; ++i) {
            retval = (this.bytes[i] & 0xFF) - (other.bytes[i] & 0xFF);
        }
        if (retval == 0) {
            if (this.realSize == other.realSize) {
                return 0;
            }
            if (this.realSize > len) {
                return 1;
            }
            return -1;
        }
        if (retval > 0) {
            return 1;
        }
        return -1;
    }

    public byte[] unsafeBytes() {
        return this.bytes;
    }

    public byte[] bytes() {
        byte[] newBytes = new byte[this.realSize];
        System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
        return newBytes;
    }

    public Object clone() {
        return new ByteList(this.bytes, 0, this.realSize);
    }

    private void grow(int increaseRequested) {
        if (increaseRequested < 0) {
            return;
        }
        int newSize = this.realSize + increaseRequested;
        if (this.bytes.length < newSize) {
            byte[] newBytes = new byte[(int)((double)newSize * 1.5)];
            System.arraycopy(this.bytes, 0, newBytes, 0, this.realSize);
            this.bytes = newBytes;
        }
    }

    public int hashCode() {
        int key = 0;
        for (int i = 0; i < this.realSize; ++i) {
            int g = (key = (key << 4) + (this.bytes[i] & 0xFF)) & 0xF0000000;
            if (g != 0) {
                key ^= g >> 24;
            }
            key &= ~g;
        }
        return key;
    }

    public String toString() {
        return new String(this.bytes, 0, this.realSize);
    }

    public static ByteList create(CharSequence s) {
        return new ByteList(ByteList.plain(s), false);
    }

    public static byte[] plain(CharSequence s) {
        byte[] bytes = new byte[s.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)s.charAt(i);
        }
        return bytes;
    }

    public static byte[] plain(char[] s) {
        byte[] bytes = new byte[s.length];
        for (int i = 0; i < s.length; ++i) {
            bytes[i] = (byte)s[i];
        }
        return bytes;
    }

    public static char[] plain(byte[] b) {
        char[] chars = new char[b.length];
        for (int i = 0; i < b.length; ++i) {
            chars[i] = (char)(b[i] & 0xFF);
        }
        return chars;
    }

    public char charAt(int ix) {
        return (char)(this.bytes[ix] & 0xFF);
    }

    public CharSequence subSequence(int start, int end) {
        return new ByteList(this, start, end - start);
    }
}

