/*
 * Decompiled with CFR 0.152.
 */
package jruby.objectweb.asm.tree.analysis;

import java.util.List;
import jruby.objectweb.asm.Type;
import jruby.objectweb.asm.tree.AbstractInsnNode;
import jruby.objectweb.asm.tree.FieldInsnNode;
import jruby.objectweb.asm.tree.MethodInsnNode;
import jruby.objectweb.asm.tree.analysis.AnalyzerException;
import jruby.objectweb.asm.tree.analysis.BasicInterpreter;
import jruby.objectweb.asm.tree.analysis.BasicValue;
import jruby.objectweb.asm.tree.analysis.Value;

public class BasicVerifier
extends BasicInterpreter {
    public Value copyOperation(AbstractInsnNode abstractInsnNode, Value value2) throws AnalyzerException {
        Value value3;
        switch (abstractInsnNode.getOpcode()) {
            case 21: 
            case 54: {
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 23: 
            case 56: {
                value3 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 22: 
            case 55: {
                value3 = BasicValue.LONG_VALUE;
                break;
            }
            case 24: 
            case 57: {
                value3 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 25: {
                if (!((BasicValue)value2).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value2);
                }
                return value2;
            }
            case 58: {
                if (!((BasicValue)value2).isReference() && value2 != BasicValue.RETURNADDRESS_VALUE) {
                    throw new AnalyzerException(null, "an object reference or a return address", value2);
                }
                return value2;
            }
            default: {
                return value2;
            }
        }
        if (value2 != value3) {
            throw new AnalyzerException(null, value3, value2);
        }
        return value2;
    }

    public Value unaryOperation(AbstractInsnNode abstractInsnNode, Value value2) throws AnalyzerException {
        Value value3;
        switch (abstractInsnNode.getOpcode()) {
            case 116: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 145: 
            case 146: 
            case 147: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 170: 
            case 171: 
            case 172: 
            case 188: 
            case 189: {
                value3 = BasicValue.INT_VALUE;
                break;
            }
            case 118: 
            case 139: 
            case 140: 
            case 141: 
            case 174: {
                value3 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 117: 
            case 136: 
            case 137: 
            case 138: 
            case 173: {
                value3 = BasicValue.LONG_VALUE;
                break;
            }
            case 119: 
            case 142: 
            case 143: 
            case 144: 
            case 175: {
                value3 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 180: {
                value3 = this.newValue(Type.getObjectType(((FieldInsnNode)abstractInsnNode).owner));
                break;
            }
            case 192: {
                if (!((BasicValue)value2).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value2);
                }
                return super.unaryOperation(abstractInsnNode, value2);
            }
            case 190: {
                if (!this.isArrayValue(value2)) {
                    throw new AnalyzerException(null, "an array reference", value2);
                }
                return super.unaryOperation(abstractInsnNode, value2);
            }
            case 176: 
            case 191: 
            case 193: 
            case 194: 
            case 195: 
            case 198: 
            case 199: {
                if (!((BasicValue)value2).isReference()) {
                    throw new AnalyzerException(null, "an object reference", value2);
                }
                return super.unaryOperation(abstractInsnNode, value2);
            }
            case 179: {
                value3 = this.newValue(Type.getType(((FieldInsnNode)abstractInsnNode).desc));
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value2, value3)) {
            throw new AnalyzerException(null, value3, value2);
        }
        return super.unaryOperation(abstractInsnNode, value2);
    }

    public Value binaryOperation(AbstractInsnNode abstractInsnNode, Value value2, Value value3) throws AnalyzerException {
        Value value4;
        Value value5;
        switch (abstractInsnNode.getOpcode()) {
            case 46: {
                value5 = this.newValue(Type.getType("[I"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 51: {
                value5 = this.isSubTypeOf(value2, this.newValue(Type.getType("[Z"))) ? this.newValue(Type.getType("[Z")) : this.newValue(Type.getType("[B"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 52: {
                value5 = this.newValue(Type.getType("[C"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 53: {
                value5 = this.newValue(Type.getType("[S"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 47: {
                value5 = this.newValue(Type.getType("[J"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 48: {
                value5 = this.newValue(Type.getType("[F"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 49: {
                value5 = this.newValue(Type.getType("[D"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 50: {
                value5 = this.newValue(Type.getType("[Ljava/lang/Object;"));
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: {
                value5 = BasicValue.INT_VALUE;
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: 
            case 149: 
            case 150: {
                value5 = BasicValue.FLOAT_VALUE;
                value4 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 127: 
            case 129: 
            case 131: 
            case 148: {
                value5 = BasicValue.LONG_VALUE;
                value4 = BasicValue.LONG_VALUE;
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                value5 = BasicValue.LONG_VALUE;
                value4 = BasicValue.INT_VALUE;
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: 
            case 151: 
            case 152: {
                value5 = BasicValue.DOUBLE_VALUE;
                value4 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 165: 
            case 166: {
                value5 = BasicValue.REFERENCE_VALUE;
                value4 = BasicValue.REFERENCE_VALUE;
                break;
            }
            case 181: {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)abstractInsnNode;
                value5 = this.newValue(Type.getObjectType(fieldInsnNode.owner));
                value4 = this.newValue(Type.getType(fieldInsnNode.desc));
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value2, value5)) {
            throw new AnalyzerException("First argument", value5, value2);
        }
        if (!this.isSubTypeOf(value3, value4)) {
            throw new AnalyzerException("Second argument", value4, value3);
        }
        if (abstractInsnNode.getOpcode() == 50) {
            return this.getElementValue(value2);
        }
        return super.binaryOperation(abstractInsnNode, value2, value3);
    }

    public Value ternaryOperation(AbstractInsnNode abstractInsnNode, Value value2, Value value3, Value value4) throws AnalyzerException {
        Value value5;
        Value value6;
        switch (abstractInsnNode.getOpcode()) {
            case 79: {
                value6 = this.newValue(Type.getType("[I"));
                value5 = BasicValue.INT_VALUE;
                break;
            }
            case 84: {
                value6 = this.isSubTypeOf(value2, this.newValue(Type.getType("[Z"))) ? this.newValue(Type.getType("[Z")) : this.newValue(Type.getType("[B"));
                value5 = BasicValue.INT_VALUE;
                break;
            }
            case 85: {
                value6 = this.newValue(Type.getType("[C"));
                value5 = BasicValue.INT_VALUE;
                break;
            }
            case 86: {
                value6 = this.newValue(Type.getType("[S"));
                value5 = BasicValue.INT_VALUE;
                break;
            }
            case 80: {
                value6 = this.newValue(Type.getType("[J"));
                value5 = BasicValue.LONG_VALUE;
                break;
            }
            case 81: {
                value6 = this.newValue(Type.getType("[F"));
                value5 = BasicValue.FLOAT_VALUE;
                break;
            }
            case 82: {
                value6 = this.newValue(Type.getType("[D"));
                value5 = BasicValue.DOUBLE_VALUE;
                break;
            }
            case 83: {
                value6 = value2;
                value5 = BasicValue.REFERENCE_VALUE;
                break;
            }
            default: {
                throw new Error("Internal error.");
            }
        }
        if (!this.isSubTypeOf(value2, value6)) {
            throw new AnalyzerException("First argument", "a " + value6 + " array reference", value2);
        }
        if (value3 != BasicValue.INT_VALUE) {
            throw new AnalyzerException("Second argument", BasicValue.INT_VALUE, value3);
        }
        if (!this.isSubTypeOf(value4, value5)) {
            throw new AnalyzerException("Third argument", value5, value4);
        }
        return null;
    }

    public Value naryOperation(AbstractInsnNode abstractInsnNode, List list2) throws AnalyzerException {
        int n = abstractInsnNode.getOpcode();
        if (n == 197) {
            for (int i = 0; i < list2.size(); ++i) {
                if (list2.get(i) == BasicValue.INT_VALUE) continue;
                throw new AnalyzerException(null, BasicValue.INT_VALUE, (Value)list2.get(i));
            }
        } else {
            Type[] typeArray;
            int n2 = 0;
            int n3 = 0;
            if (n != 184) {
                typeArray = Type.getObjectType(((MethodInsnNode)abstractInsnNode).owner);
                if (!this.isSubTypeOf((Value)list2.get(n2++), this.newValue((Type)typeArray))) {
                    throw new AnalyzerException("Method owner", this.newValue((Type)typeArray), (Value)list2.get(0));
                }
            }
            typeArray = Type.getArgumentTypes(((MethodInsnNode)abstractInsnNode).desc);
            while (n2 < list2.size()) {
                Value value2;
                Value value3 = this.newValue(typeArray[n3++]);
                if (this.isSubTypeOf(value2 = (Value)list2.get(n2++), value3)) continue;
                throw new AnalyzerException("Argument " + n3, value3, value2);
            }
        }
        return super.naryOperation(abstractInsnNode, list2);
    }

    protected boolean isArrayValue(Value value2) {
        return ((BasicValue)value2).isReference();
    }

    protected Value getElementValue(Value value2) throws AnalyzerException {
        return BasicValue.REFERENCE_VALUE;
    }

    protected boolean isSubTypeOf(Value value2, Value value3) {
        return value2 == value3;
    }
}

