/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.execution;

import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ContainerExecutionCondition;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestExecutionCondition;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.engine.execution.ConditionEvaluationException;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.commons.meta.API;
import org.junit.platform.commons.util.StringUtils;
import org.junit.platform.engine.ConfigurationParameters;

@API(value=API.Usage.Internal)
public class ConditionEvaluator {
    private static final Logger LOG = Logger.getLogger(ConditionEvaluator.class.getName());
    private static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"No 'disabled' conditions encountered");
    private static final Predicate<Object> alwaysActivated = condition -> true;
    private static final Predicate<Object> alwaysDeactivated = condition -> false;

    public ConditionEvaluationResult evaluateForContainer(ExtensionRegistry extensionRegistry, ConfigurationParameters configurationParameters, ContainerExtensionContext context) {
        BiFunction<Object, Object, ConditionEvaluationResult> evaluateAdaptor = (condition, ctx) -> this.evaluate((ContainerExecutionCondition)condition, (ContainerExtensionContext)ctx);
        return this.evaluate(ContainerExecutionCondition.class, evaluateAdaptor, extensionRegistry, configurationParameters, (ExtensionContext)context);
    }

    public ConditionEvaluationResult evaluateForTest(ExtensionRegistry extensionRegistry, ConfigurationParameters configurationParameters, TestExtensionContext context) {
        BiFunction<Object, Object, ConditionEvaluationResult> evaluateAdaptor = (condition, ctx) -> this.evaluate((TestExecutionCondition)condition, (TestExtensionContext)ctx);
        return this.evaluate(TestExecutionCondition.class, evaluateAdaptor, extensionRegistry, configurationParameters, (ExtensionContext)context);
    }

    private ConditionEvaluationResult evaluate(Class<? extends Extension> extensionType, BiFunction<Object, Object, ConditionEvaluationResult> evaluateAdaptor, ExtensionRegistry extensionRegistry, ConfigurationParameters configurationParameters, ExtensionContext context) {
        Predicate<Object> isActivated = this.conditionIsActivated(configurationParameters);
        return extensionRegistry.stream(extensionType).filter(isActivated).map(condition -> (ConditionEvaluationResult)evaluateAdaptor.apply(condition, context)).filter(ConditionEvaluationResult::isDisabled).findFirst().orElse(ENABLED);
    }

    private ConditionEvaluationResult evaluate(ContainerExecutionCondition condition, ContainerExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluate(context);
            this.logResult(condition.getClass(), result);
            return result;
        }
        catch (Exception ex) {
            throw new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]", condition.getClass().getName()), ex);
        }
    }

    private ConditionEvaluationResult evaluate(TestExecutionCondition condition, TestExtensionContext context) {
        try {
            ConditionEvaluationResult result = condition.evaluate(context);
            this.logResult(condition.getClass(), result);
            return result;
        }
        catch (Exception ex) {
            throw new ConditionEvaluationException(String.format("Failed to evaluate condition [%s]", condition.getClass().getName()), ex);
        }
    }

    private void logResult(Class<?> conditionType, ConditionEvaluationResult result) {
        LOG.finer(() -> String.format("Evaluation of condition [%s] resulted in: %s", conditionType.getName(), result));
    }

    private Predicate<Object> conditionIsActivated(ConfigurationParameters configurationParameters) {
        String patternString = this.getDeactivatePatternString(configurationParameters);
        if (patternString != null) {
            if ("*".equals(patternString)) {
                return alwaysDeactivated;
            }
            Pattern pattern = Pattern.compile(this.convertToRegEx(patternString));
            return condition -> !pattern.matcher(condition.getClass().getName()).matches();
        }
        return alwaysActivated;
    }

    private String getDeactivatePatternString(ConfigurationParameters configurationParameters) {
        return configurationParameters.get("junit.conditions.deactivate").filter(StringUtils::isNotBlank).map(String::trim).orElse(null);
    }

    private String convertToRegEx(String pattern) {
        pattern = Matcher.quoteReplacement(pattern);
        pattern = pattern.replace(".", "[.$]");
        pattern = pattern.replace("*", ".+");
        return pattern;
    }
}

