/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.jpa.updater.liquibase.custom;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import liquibase.exception.CustomChangeException;
import liquibase.statement.core.DeleteStatement;
import liquibase.statement.core.InsertStatement;
import liquibase.structure.core.Table;
import org.jboss.logging.Logger;
import org.keycloak.connections.jpa.updater.liquibase.custom.CustomKeycloakTask;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.storage.UserStorageProvider;

public abstract class AbstractUserFedToComponent
extends CustomKeycloakTask {
    private final Logger logger = Logger.getLogger(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertFedProviderToComponent(String providerId, String newMapperType) throws CustomChangeException {
        try {
            statement.setString(1, providerId);
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID, REALM_ID, PRIORITY, DISPLAY_NAME, FULL_SYNC_PERIOD, CHANGED_SYNC_PERIOD, LAST_SYNC from " + this.getTableName("USER_FEDERATION_PROVIDER") + " WHERE PROVIDER_NAME=?");
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    int index = 1;
                    String id = resultSet.getString(index++);
                    String realmId = resultSet.getString(index++);
                    int priority = resultSet.getInt(index++);
                    String displayName = resultSet.getString(index++);
                    int fullSyncPeriod = resultSet.getInt(index++);
                    int changedSyncPeriod = resultSet.getInt(index++);
                    int lastSync = resultSet.getInt(index++);
                    InsertStatement insertComponent = new InsertStatement(null, null, this.database.correctObjectName("COMPONENT", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("PARENT_ID", (Object)realmId).addColumnValue("NAME", (Object)displayName).addColumnValue("PROVIDER_ID", (Object)providerId).addColumnValue("PROVIDER_TYPE", (Object)UserStorageProvider.class.getName());
                    this.statements.add(insertComponent);
                    this.statements.add(this.componentConfigStatement(id, "priority", Integer.toString(priority)));
                    this.statements.add(this.componentConfigStatement(id, "fullSyncPeriod", Integer.toString(fullSyncPeriod)));
                    this.statements.add(this.componentConfigStatement(id, "changedSyncPeriod", Integer.toString(changedSyncPeriod)));
                    this.statements.add(this.componentConfigStatement(id, "lastSync", Integer.toString(lastSync)));
                    configStatement.setString(1, id);
                    try (PreparedStatement configStatement = this.jdbcConnection.prepareStatement("select name, VALUE from " + this.getTableName("USER_FEDERATION_CONFIG") + " WHERE USER_FEDERATION_PROVIDER_ID=?");
                         ResultSet configSet = configStatement.executeQuery();){
                        while (configSet.next()) {
                            String name = configSet.getString(1);
                            String value = configSet.getString(2);
                            this.statements.add(this.componentConfigStatement(id, name, value));
                        }
                    }
                    if (newMapperType != null) {
                        this.convertFedMapperToComponent(realmId, id, newMapperType);
                    }
                    DeleteStatement configDelete = new DeleteStatement(null, null, this.database.correctObjectName("USER_FEDERATION_CONFIG", Table.class));
                    configDelete.setWhere("USER_FEDERATION_PROVIDER_ID=?");
                    configDelete.addWhereParameters(new Object[]{id});
                    this.statements.add(configDelete);
                    DeleteStatement deleteStatement = new DeleteStatement(null, null, this.database.correctObjectName("USER_FEDERATION_PROVIDER", Table.class));
                    deleteStatement.setWhere("ID=?");
                    deleteStatement.addWhereParameters(new Object[]{id});
                    this.statements.add(deleteStatement);
                }
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " records in USER_FEDERATION_PROVIDER table for " + providerId + " conversion to component model");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }

    protected InsertStatement componentConfigStatement(String componentId, String name, String value) {
        return new InsertStatement(null, null, this.database.correctObjectName("COMPONENT_CONFIG", Table.class)).addColumnValue("ID", (Object)KeycloakModelUtils.generateId()).addColumnValue("COMPONENT_ID", (Object)componentId).addColumnValue("NAME", (Object)name).addColumnValue("VALUE", (Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void convertFedMapperToComponent(String realmId, String parentId, String newMapperType) throws CustomChangeException {
        try {
            statement.setString(1, parentId);
            try (PreparedStatement statement = this.jdbcConnection.prepareStatement("select ID, NAME, FEDERATION_MAPPER_TYPE from " + this.getTableName("USER_FEDERATION_MAPPER") + " WHERE FEDERATION_PROVIDER_ID=?");
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    String id = resultSet.getString(1);
                    String mapperName = resultSet.getString(2);
                    String fedMapperType = resultSet.getString(3);
                    InsertStatement insertComponent = new InsertStatement(null, null, this.database.correctObjectName("COMPONENT", Table.class)).addColumnValue("ID", (Object)id).addColumnValue("REALM_ID", (Object)realmId).addColumnValue("PARENT_ID", (Object)parentId).addColumnValue("NAME", (Object)mapperName).addColumnValue("PROVIDER_ID", (Object)fedMapperType).addColumnValue("PROVIDER_TYPE", (Object)newMapperType);
                    this.statements.add(insertComponent);
                    configStatement.setString(1, id);
                    try (PreparedStatement configStatement = this.jdbcConnection.prepareStatement("select name, VALUE from " + this.getTableName("USER_FEDERATION_MAPPER_CONFIG") + " WHERE USER_FEDERATION_MAPPER_ID=?");
                         ResultSet configSet = configStatement.executeQuery();){
                        while (configSet.next()) {
                            String name = configSet.getString(1);
                            String value = configSet.getString(2);
                            this.statements.add(this.componentConfigStatement(id, name, value));
                        }
                    }
                    DeleteStatement configDelete = new DeleteStatement(null, null, this.database.correctObjectName("USER_FEDERATION_MAPPER_CONFIG", Table.class));
                    configDelete.setWhere("USER_FEDERATION_MAPPER_ID=?");
                    configDelete.addWhereParameters(new Object[]{id});
                    this.statements.add(configDelete);
                    DeleteStatement deleteStatement = new DeleteStatement(null, null, this.database.correctObjectName("USER_FEDERATION_MAPPER", Table.class));
                    deleteStatement.setWhere("ID=?");
                    deleteStatement.addWhereParameters(new Object[]{id});
                    this.statements.add(deleteStatement);
                }
            }
            this.confirmationMessage.append("Updated " + this.statements.size() + " records in USER_FEDERATION_MAPPER table for " + parentId + " conversion to component model");
        }
        catch (Exception e) {
            throw new CustomChangeException(this.getTaskId() + ": Exception when updating data from previous version", (Throwable)e);
        }
    }
}

