/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa;

import jakarta.persistence.EntityManager;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.keycloak.Config;
import org.keycloak.authorization.fgap.AdminPermissionsSchema;
import org.keycloak.common.Profile;
import org.keycloak.connections.jpa.JpaConnectionProvider;
import org.keycloak.models.ClientProvider;
import org.keycloak.models.ClientProviderFactory;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.jpa.JpaRealmProvider;

public class JpaClientProviderFactory
implements ClientProviderFactory {
    private Set<String> clientSearchableAttributes = null;
    private static final List<String> REQUIRED_SEARCHABLE_ATTRIBUTES = Arrays.asList("saml_idp_initiated_sso_url_name", "saml.artifact.binding.identifier");

    public void init(Config.Scope config) {
        Object s;
        String[] searchableAttrsArr = config.getArray("searchableAttributes");
        if (searchableAttrsArr == null) {
            s = System.getProperty("keycloak.client.searchableAttributes");
            searchableAttrsArr = s == null ? null : ((String)s).split("\\s*,\\s*");
        }
        s = new HashSet<String>(REQUIRED_SEARCHABLE_ATTRIBUTES);
        if (searchableAttrsArr != null) {
            ((AbstractCollection)s).addAll(Arrays.asList(searchableAttrsArr));
        }
        this.clientSearchableAttributes = Collections.unmodifiableSet(s);
    }

    public void postInit(KeycloakSessionFactory factory) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.ADMIN_FINE_GRAINED_AUTHZ_V2)) {
            factory.register(event -> {
                RealmModel.RealmAttributeUpdateEvent attrUpdateEvent;
                if (event instanceof RealmModel.RealmAttributeUpdateEvent && Objects.equals((attrUpdateEvent = (RealmModel.RealmAttributeUpdateEvent)event).getAttributeName(), "adminPermissionsEnabled") && Boolean.parseBoolean(attrUpdateEvent.getAttributeValue())) {
                    KeycloakSession keycloakSession = attrUpdateEvent.getKeycloakSession();
                    RealmModel realm = attrUpdateEvent.getRealm();
                    AdminPermissionsSchema.SCHEMA.init(keycloakSession, realm);
                }
            });
        }
    }

    public String getId() {
        return "jpa";
    }

    public ClientProvider create(KeycloakSession session) {
        EntityManager em = ((JpaConnectionProvider)session.getProvider(JpaConnectionProvider.class)).getEntityManager();
        return new JpaRealmProvider(session, em, this.clientSearchableAttributes, null);
    }

    public void close() {
    }

    public int order() {
        return 1;
    }
}

