/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.session;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import jakarta.persistence.Version;
import java.io.Serializable;
import org.hibernate.annotations.DynamicUpdate;

@NamedQueries(value={@NamedQuery(name="deleteClientSessionsByRealm", query="delete from PersistentClientSessionEntity sess where sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId)"), @NamedQuery(name="deleteClientSessionsByClient", query="delete from PersistentClientSessionEntity sess where sess.clientId = :clientId"), @NamedQuery(name="deleteClientSessionsByExternalClient", query="delete from PersistentClientSessionEntity sess where sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId"), @NamedQuery(name="deleteClientSessionsByClientStorageProvider", query="delete from PersistentClientSessionEntity sess where sess.clientStorageProvider = :clientStorageProvider"), @NamedQuery(name="deleteClientSessionsByUser", query="delete from PersistentClientSessionEntity sess where sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.userId = :userId)"), @NamedQuery(name="deleteClientSessionsByUserSession", query="delete from PersistentClientSessionEntity sess where sess.userSessionId = :userSessionId and sess.offline = :offline"), @NamedQuery(name="deleteExpiredClientSessions", query="delete from PersistentClientSessionEntity sess where sess.offline = :offline AND sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId AND u.offline = :offline AND u.lastSessionRefresh < :lastSessionRefresh)"), @NamedQuery(name="deleteClientSessionsByRealmSessionType", query="delete from PersistentClientSessionEntity sess where sess.offline = :offline AND sess.userSessionId IN (select u.userSessionId from PersistentUserSessionEntity u where u.realmId = :realmId and u.offline = :offline)"), @NamedQuery(name="findClientSessionsByUserSession", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline"), @NamedQuery(name="findClientSessionsOrderedByIdInterval", query="select sess from PersistentClientSessionEntity sess where sess.offline = :offline and sess.userSessionId >= :fromSessionId and sess.userSessionId <= :toSessionId order by sess.userSessionId"), @NamedQuery(name="findClientSessionsOrderedByIdExact", query="select sess from PersistentClientSessionEntity sess where sess.offline = :offline and sess.userSessionId IN (:userSessionIds)"), @NamedQuery(name="findClientSessionsCountByClient", query="select count(sess) from PersistentClientSessionEntity sess where sess.offline = :offline and sess.clientId = :clientId"), @NamedQuery(name="findClientSessionsCountByExternalClient", query="select count(sess) from PersistentClientSessionEntity sess where sess.offline = :offline and sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId"), @NamedQuery(name="findClientSessionsByUserSessionAndClient", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline and sess.clientId=:clientId"), @NamedQuery(name="findClientSessionsByUserSessionAndExternalClient", query="select sess from PersistentClientSessionEntity sess where sess.userSessionId=:userSessionId and sess.offline = :offline and sess.clientStorageProvider = :clientStorageProvider and sess.externalClientId = :externalClientId")})
@Table(name="OFFLINE_CLIENT_SESSION")
@Entity
@DynamicUpdate
@IdClass(value=Key.class)
public class PersistentClientSessionEntity {
    public static final String LOCAL = "local";
    public static final String EXTERNAL = "external";
    @Id
    @Column(name="USER_SESSION_ID", length=36)
    protected String userSessionId;
    @Id
    @Column(name="CLIENT_ID", length=36)
    protected String clientId;
    @Id
    @Column(name="CLIENT_STORAGE_PROVIDER", length=36)
    protected String clientStorageProvider;
    @Id
    @Column(name="EXTERNAL_CLIENT_ID", length=255)
    protected String externalClientId;
    @Column(name="TIMESTAMP")
    protected int timestamp;
    @Version
    @Column(name="VERSION")
    private int version;
    @Id
    @Column(name="OFFLINE_FLAG")
    protected String offline;
    @Column(name="DATA")
    protected String data;

    public String getUserSessionId() {
        return this.userSessionId;
    }

    public void setUserSessionId(String userSessionId) {
        this.userSessionId = userSessionId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientStorageProvider() {
        return this.clientStorageProvider;
    }

    public void setClientStorageProvider(String clientStorageProvider) {
        this.clientStorageProvider = clientStorageProvider;
    }

    public String getExternalClientId() {
        return this.externalClientId;
    }

    public void setExternalClientId(String externalClientId) {
        this.externalClientId = externalClientId;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(int timestamp) {
        this.timestamp = timestamp;
    }

    public String getOffline() {
        return this.offline;
    }

    public void setOffline(String offline) {
        this.offline = offline;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public static class Key
    implements Serializable {
        protected String userSessionId;
        protected String clientId;
        protected String clientStorageProvider;
        protected String externalClientId;
        protected String offline;

        public Key() {
        }

        public Key(String userSessionId, String clientId, String clientStorageProvider, String externalClientId, String offline) {
            this.userSessionId = userSessionId;
            this.clientId = clientId;
            this.externalClientId = externalClientId;
            this.clientStorageProvider = clientStorageProvider;
            this.offline = offline;
        }

        public String getUserSessionId() {
            return this.userSessionId;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getOffline() {
            return this.offline;
        }

        public String getClientStorageProvider() {
            return this.clientStorageProvider;
        }

        public String getExternalClientId() {
            return this.externalClientId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.userSessionId != null ? !this.userSessionId.equals(key.userSessionId) : key.userSessionId != null) {
                return false;
            }
            if (this.clientId != null ? !this.clientId.equals(key.clientId) : key.clientId != null) {
                return false;
            }
            if (this.externalClientId != null ? !this.externalClientId.equals(key.externalClientId) : key.externalClientId != null) {
                return false;
            }
            if (this.clientStorageProvider != null ? !this.clientStorageProvider.equals(key.clientStorageProvider) : key.clientStorageProvider != null) {
                return false;
            }
            return !(this.offline != null ? !this.offline.equals(key.offline) : key.offline != null);
        }

        public int hashCode() {
            int result = this.userSessionId != null ? this.userSessionId.hashCode() : 0;
            result = 37 * result + (this.clientId != null ? this.clientId.hashCode() : 0);
            result = 37 * result + (this.externalClientId != null ? this.externalClientId.hashCode() : 0);
            result = 37 * result + (this.clientStorageProvider != null ? this.clientStorageProvider.hashCode() : 0);
            result = 31 * result + (this.offline != null ? this.offline.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "PersistentClientSessionEntity$Key[userSessionId='" + this.userSessionId + "', clientId='" + this.clientId + "', clientStorageProvider='" + this.clientStorageProvider + "', externalClientId='" + this.externalClientId + "', offline='" + this.offline + "']";
        }
    }
}

