/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.migration.migrators;

import org.keycloak.migration.ModelVersion;
import org.keycloak.migration.migrators.RealmMigration;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionProvider;

public class MigrateTo26_0_0
extends RealmMigration {
    public static final ModelVersion VERSION = new ModelVersion("26.0.0");

    public ModelVersion getVersion() {
        return VERSION;
    }

    @Override
    public void migrate(KeycloakSession session) {
        UserSessionProvider userSessions = session.sessions();
        if (userSessions != null) {
            userSessions.migrate(VERSION.toString());
        }
        super.migrate(session);
    }

    @Override
    public void migrateRealm(KeycloakSession session, RealmModel realm) {
        ClientModel adminCliClient;
        ClientModel adminConsoleClient = realm.getClientByClientId("security-admin-console");
        if (adminConsoleClient != null) {
            adminConsoleClient.setFullScopeAllowed(true);
            adminConsoleClient.setAttribute("client.use.lightweight.access.token.enabled", String.valueOf(true));
        }
        if ((adminCliClient = realm.getClientByClientId("admin-cli")) != null) {
            adminCliClient.setFullScopeAllowed(true);
            adminCliClient.setAttribute("client.use.lightweight.access.token.enabled", String.valueOf(true));
        }
    }
}

