/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.console;

import java.net.URI;
import javax.ws.rs.core.Response;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.Authenticator;
import org.keycloak.authentication.ConsoleDisplayMode;
import org.keycloak.authentication.authenticators.browser.OTPFormAuthenticator;

public class ConsoleOTPFormAuthenticator
extends OTPFormAuthenticator
implements Authenticator {
    public static final ConsoleOTPFormAuthenticator SINGLETON = new ConsoleOTPFormAuthenticator();

    public static URI getCallbackUrl(AuthenticationFlowContext context) {
        return context.getActionUrl(context.generateAccessCode(), true);
    }

    protected ConsoleDisplayMode challenge(AuthenticationFlowContext context) {
        return ConsoleDisplayMode.challenge((AuthenticationFlowContext)context).header().param("otp").label("console-otp").challenge();
    }

    @Override
    public void action(AuthenticationFlowContext context) {
        this.validateOTP(context);
    }

    @Override
    public void authenticate(AuthenticationFlowContext context) {
        Response challengeResponse = this.challenge(context, null);
        context.challenge(challengeResponse);
    }

    @Override
    protected Response challenge(AuthenticationFlowContext context, String msg) {
        if (msg == null) {
            return this.challenge(context).response();
        }
        return this.challenge(context).message(msg, new String[0]);
    }

    @Override
    public void close() {
    }
}

