/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.broker.oidc.mappers;

import org.keycloak.broker.oidc.mappers.AbstractClaimMapper;
import org.keycloak.broker.provider.BrokeredIdentityContext;
import org.keycloak.broker.provider.IdentityBrokerException;
import org.keycloak.models.GroupModel;
import org.keycloak.models.IdentityProviderMapperModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.utils.KeycloakModelUtils;

public abstract class AbstractClaimToGroupMapper
extends AbstractClaimMapper {
    public void importNewUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        GroupModel group = this.getGroup(realm, mapperModel);
        if (this.applies(mapperModel, context)) {
            user.joinGroup(group);
        }
    }

    public void updateBrokeredUser(KeycloakSession session, RealmModel realm, UserModel user, IdentityProviderMapperModel mapperModel, BrokeredIdentityContext context) {
        GroupModel group = this.getGroup(realm, mapperModel);
        String groupId = (String)mapperModel.getConfig().get("group");
        if (!context.hasMapperAssignedGroup(groupId)) {
            if (this.applies(mapperModel, context)) {
                context.addMapperAssignedGroup(groupId);
                user.joinGroup(group);
            } else {
                user.leaveGroup(group);
            }
        }
    }

    protected abstract boolean applies(IdentityProviderMapperModel var1, BrokeredIdentityContext var2);

    private GroupModel getGroup(RealmModel realm, IdentityProviderMapperModel mapperModel) {
        GroupModel group = KeycloakModelUtils.findGroupByPath((RealmModel)realm, (String)((String)mapperModel.getConfig().get("group")));
        if (group == null) {
            throw new IdentityBrokerException("Unable to find group: " + group.getId());
        }
        return group;
    }
}

