/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.docker.installation.compose;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.AbstractMap;
import java.util.Map;
import org.keycloak.common.util.CertificateUtils;
import org.keycloak.protocol.docker.installation.compose.DockerCertFileUtils;

public class DockerComposeCertsDirectory {
    private final String directoryName;
    private final Map.Entry<String, byte[]> localhostCertFile;
    private final Map.Entry<String, byte[]> localhostKeyFile;
    private final Map.Entry<String, byte[]> idpTrustChainFile;

    public DockerComposeCertsDirectory(String directoryName, Certificate realmCert, String registryCertFilename, String registryKeyFilename, String idpCertTrustChainFilename, String realmName) {
        this.directoryName = directoryName;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(2048, new SecureRandom());
            KeyPair keypair = keyGen.generateKeyPair();
            PrivateKey privateKey = keypair.getPrivate();
            X509Certificate certificate = CertificateUtils.generateV1SelfSignedCertificate((KeyPair)keypair, (String)realmName);
            this.localhostCertFile = new AbstractMap.SimpleImmutableEntry<String, byte[]>(registryCertFilename, DockerCertFileUtils.formatCrtFileContents(certificate).getBytes());
            this.localhostKeyFile = new AbstractMap.SimpleImmutableEntry<String, byte[]>(registryKeyFilename, DockerCertFileUtils.formatPrivateKeyContents(privateKey).getBytes());
            this.idpTrustChainFile = new AbstractMap.SimpleEntry<String, byte[]>(idpCertTrustChainFilename, DockerCertFileUtils.formatCrtFileContents(realmCert).getBytes());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public Map.Entry<String, byte[]> getLocalhostCertFile() {
        return this.localhostCertFile;
    }

    public Map.Entry<String, byte[]> getLocalhostKeyFile() {
        return this.localhostKeyFile;
    }

    public Map.Entry<String, byte[]> getIdpTrustChainFile() {
        return this.idpTrustChainFile;
    }
}

