/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.clientpolicy.executor;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Optional;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oidc.OIDCAdvancedConfigWrapper;
import org.keycloak.representations.idm.ClientPolicyExecutorConfigurationRepresentation;
import org.keycloak.representations.idm.ClientRepresentation;
import org.keycloak.services.clientpolicy.ClientPolicyContext;
import org.keycloak.services.clientpolicy.ClientPolicyException;
import org.keycloak.services.clientpolicy.context.ClientCRUDContext;
import org.keycloak.services.clientpolicy.executor.ClientPolicyExecutorProvider;
import org.keycloak.utils.StringUtil;

public class SecureLogoutExecutor
implements ClientPolicyExecutorProvider<Configuration> {
    private final KeycloakSession session;
    private Configuration configuration;

    public SecureLogoutExecutor(KeycloakSession session) {
        this.session = session;
    }

    public void setupConfiguration(Configuration config) {
        this.configuration = config;
    }

    public Class<Configuration> getExecutorConfigurationClass() {
        return Configuration.class;
    }

    public String getProviderId() {
        return "secure-logout";
    }

    public void executeOnEvent(ClientPolicyContext context) throws ClientPolicyException {
        switch (context.getEvent()) {
            case REGISTER: 
            case UPDATE: {
                ClientCRUDContext updateContext = (ClientCRUDContext)context;
                ClientRepresentation client = updateContext.getProposedClientRepresentation();
                OIDCAdvancedConfigWrapper clientWrapper = OIDCAdvancedConfigWrapper.fromClientRepresentation(client);
                if (!this.configuration.isAllowFrontChannelLogout().booleanValue() && (Optional.ofNullable(client.isFrontchannelLogout()).orElse(false).booleanValue() || StringUtil.isNotBlank((String)clientWrapper.getFrontChannelLogoutUrl()))) {
                    this.throwFrontChannelLogoutNotAllowed();
                }
                return;
            }
            case LOGOUT_REQUEST: {
                HttpRequest request = (HttpRequest)this.session.getContext().getContextObject(HttpRequest.class);
                if ("GET".equalsIgnoreCase(request.getHttpMethod()) && !this.configuration.isAllowFrontChannelLogout().booleanValue()) {
                    this.throwFrontChannelLogoutNotAllowed();
                }
                return;
            }
        }
    }

    private void throwFrontChannelLogoutNotAllowed() throws ClientPolicyException {
        throw new ClientPolicyException("invalid_registration", "Front-channel logout is not allowed for this client");
    }

    public static class Configuration
    extends ClientPolicyExecutorConfigurationRepresentation {
        @JsonProperty(value="allow-front-channel-logout")
        protected Boolean allowFrontChannelLogout = Boolean.FALSE;

        public Boolean isAllowFrontChannelLogout() {
            return this.allowFrontChannelLogout;
        }

        public void setAllowFrontChannelLogout(Boolean allowFrontChannelLogout) {
            this.allowFrontChannelLogout = allowFrontChannelLogout;
        }
    }
}

