/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.keycloak.component.ComponentValidationException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.services.ErrorResponse;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;
import org.keycloak.userprofile.UserProfileProvider;

public class UserProfileResource {
    @Context
    protected KeycloakSession session;
    protected RealmModel realm;
    private AdminPermissionEvaluator auth;

    public UserProfileResource(RealmModel realm, AdminPermissionEvaluator auth) {
        this.realm = realm;
        this.auth = auth;
    }

    @GET
    @Produces(value={"application/json"})
    public String getConfiguration() {
        this.auth.realm().requireViewRealm();
        return ((UserProfileProvider)this.session.getProvider(UserProfileProvider.class)).getConfiguration();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response update(String text) {
        this.auth.realm().requireManageRealm();
        UserProfileProvider t = (UserProfileProvider)this.session.getProvider(UserProfileProvider.class);
        try {
            t.setConfiguration(text);
        }
        catch (ComponentValidationException e) {
            return ErrorResponse.error(e.getMessage(), Response.Status.BAD_REQUEST);
        }
        return Response.ok((Object)t.getConfiguration()).type("application/json").build();
    }
}

