/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.storage.openshift;

import com.openshift.restclient.IClient;
import com.openshift.restclient.NotFoundException;
import com.openshift.restclient.model.IResource;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.storage.StorageId;
import org.keycloak.storage.client.ClientStorageProvider;
import org.keycloak.storage.client.ClientStorageProviderModel;
import org.keycloak.storage.openshift.OpenshiftClientStorageProviderFactory;
import org.keycloak.storage.openshift.OpenshiftSAClientAdapter;

public class OpenshiftClientStorageProvider
implements ClientStorageProvider {
    private final KeycloakSession session;
    private final ClientStorageProviderModel providerModel;
    private final IClient client;

    OpenshiftClientStorageProvider(KeycloakSession session, ClientStorageProviderModel providerModel, IClient client) {
        this.session = session;
        this.providerModel = providerModel;
        this.client = client;
    }

    public ClientModel getClientById(RealmModel realm, String id) {
        StorageId storageId = new StorageId(id);
        if (!storageId.getProviderId().equals(this.providerModel.getId())) {
            return null;
        }
        String clientId = storageId.getExternalId();
        return this.getClientByClientId(realm, clientId);
    }

    public ClientModel getClientByClientId(RealmModel realm, String clientId) {
        Matcher matcher = OpenshiftClientStorageProviderFactory.SERVICE_ACCOUNT_PATTERN.matcher(clientId);
        IResource resource = null;
        if (matcher.matches()) {
            resource = this.getServiceAccount(matcher.group(2), matcher.group(1));
        } else {
            String defaultNamespace = this.providerModel.get("openshift.namespace.default");
            if (defaultNamespace != null) {
                resource = this.getServiceAccount(clientId, defaultNamespace);
            }
        }
        if (resource == null) {
            return null;
        }
        return new OpenshiftSAClientAdapter(clientId, resource, this.client, this.session, realm, this.providerModel);
    }

    public Stream<ClientModel> searchClientsByClientIdStream(RealmModel realm, String clientId, Integer firstResult, Integer maxResults) {
        return Stream.of(this.getClientByClientId(realm, clientId));
    }

    public Stream<ClientModel> searchClientsByAttributes(RealmModel realm, Map<String, String> attributes, Integer firstResult, Integer maxResults) {
        return Stream.empty();
    }

    public void close() {
    }

    private IResource getServiceAccount(String name, String namespace) {
        try {
            return this.client.get("ServiceAccount", name, namespace);
        }
        catch (NotFoundException nfe) {
            return null;
        }
    }

    public Map<String, ClientScopeModel> getClientScopes(RealmModel realm, ClientModel client, boolean defaultScopes) {
        return Collections.EMPTY_MAP;
    }
}

