/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.vault;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.jboss.logging.Logger;
import org.keycloak.vault.AbstractVaultProvider;
import org.keycloak.vault.DefaultVaultRawSecret;
import org.keycloak.vault.VaultKeyResolver;
import org.keycloak.vault.VaultRawSecret;

public class FilesPlainTextVaultProvider
extends AbstractVaultProvider {
    private static final Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final Path vaultPath;

    public FilesPlainTextVaultProvider(@Nonnull Path path, @Nonnull String realmName, @Nonnull List<VaultKeyResolver> resolvers) {
        super(realmName, resolvers);
        this.vaultPath = path;
        logger.debugf("PlainTextVaultProvider will operate in %s directory", (Object)this.vaultPath.toAbsolutePath());
    }

    @Override
    protected VaultRawSecret obtainSecretInternal(String vaultSecretId) {
        Path secretPath = this.vaultPath.resolve(vaultSecretId);
        if (!Files.exists(secretPath, new LinkOption[0])) {
            logger.warnf("Cannot find secret %s in %s", (Object)vaultSecretId, (Object)secretPath);
            return DefaultVaultRawSecret.forBuffer(Optional.empty());
        }
        try {
            byte[] bytes = Files.readAllBytes(secretPath);
            return DefaultVaultRawSecret.forBuffer(Optional.of(ByteBuffer.wrap(bytes)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
    }
}

