/*
 * Decompiled with CFR 0.152.
 */
package org.kie.efesto.common.api.model;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.kie.efesto.common.api.identifiers.ModelLocalUriId;

enum GeneratedClassesRepository {
    INSTANCE;

    private Map<ModelLocalUriId, Map<String, byte[]>> generatedClassesMap = new ConcurrentHashMap<ModelLocalUriId, Map<String, byte[]>>();

    public void addGeneratedClasses(ModelLocalUriId modelLocalUriId, Map<String, byte[]> generatedClasses) {
        this.generatedClassesMap.put(modelLocalUriId, generatedClasses);
    }

    public Map<String, byte[]> getGeneratedClasses(ModelLocalUriId modelLocalUriId) {
        return this.generatedClassesMap.get(modelLocalUriId);
    }

    public Map<String, byte[]> removeGeneratedClasses(ModelLocalUriId modelLocalUriId) {
        return this.generatedClassesMap.remove(modelLocalUriId);
    }

    public boolean containsKey(ModelLocalUriId modelLocalUriId) {
        return this.generatedClassesMap.containsKey(modelLocalUriId);
    }

    public Set<ModelLocalUriId> localUriIdKeySet() {
        return this.generatedClassesMap.keySet();
    }

    public void clear() {
        this.generatedClassesMap.clear();
    }
}

