/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.threads;

import java.text.NumberFormat;
import java.util.List;
import org.kuali.common.threads.ElementHandler;
import org.kuali.common.threads.ExecutionStatistics;
import org.kuali.common.threads.ThreadHandler;
import org.kuali.common.threads.ThreadHandlerContext;
import org.kuali.common.threads.ThreadHandlerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadInvoker {
    private final Logger logger = LoggerFactory.getLogger(ThreadHandlerFactory.class);
    ThreadHandlerFactory factory = new ThreadHandlerFactory();
    NumberFormat nf = this.getNumberFormat();

    protected NumberFormat getNumberFormat() {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(false);
        return nf;
    }

    public <T> ExecutionStatistics invokeThreads(ThreadHandlerContext<T> context) {
        return this.invokeThreads(context, "Executing ");
    }

    public <T> ExecutionStatistics invokeThreads(ThreadHandlerContext<T> context, String msg) {
        if (context.getHandler() == null || context.getList() == null) {
            throw new IllegalArgumentException("Neither elementHandler nor list can be null");
        }
        ThreadHandler<T> handler = this.factory.getThreadHandler(context);
        int size = context.getList().size();
        int threads = handler.getThreadCount();
        double elementsPerThread = (double)size * 1.0 / (double)threads;
        this.logger.info(msg + "[t:" + threads + " e:" + this.nf.format(elementsPerThread) + " s:" + size + "]");
        handler.executeThreads();
        return handler.getExecutionStatistics();
    }

    public <T> ExecutionStatistics invokeThreads(int max, int min, int divisor, ThreadHandlerContext<T> context) {
        context.setMax(max);
        context.setMin(min);
        context.setDivisor(divisor);
        return this.invokeThreads(context);
    }

    public <T> ExecutionStatistics invokeThreads(int max, ElementHandler<T> elementHandler, List<T> list) {
        ThreadHandlerContext<T> thc = new ThreadHandlerContext<T>();
        thc.setMax(max);
        thc.setHandler(elementHandler);
        thc.setList(list);
        return this.invokeThreads(max, 0, 0, thc);
    }
}

