/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.integration.server;

import com.google.common.base.Charsets;
import com.google.common.net.MediaType;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.StringStartsWith;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockserver.client.netty.NettyHttpClient;
import org.mockserver.client.netty.SocketConnectionException;
import org.mockserver.client.server.MockServerClient;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.matchers.MatchType;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.model.BinaryBody;
import org.mockserver.model.Body;
import org.mockserver.model.Cookie;
import org.mockserver.model.Delay;
import org.mockserver.model.Header;
import org.mockserver.model.HttpCallback;
import org.mockserver.model.HttpForward;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.HttpStatusCode;
import org.mockserver.model.JsonBody;
import org.mockserver.model.JsonSchemaBody;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.OutboundHttpRequest;
import org.mockserver.model.Parameter;
import org.mockserver.model.ParameterBody;
import org.mockserver.model.StringBody;
import org.mockserver.model.XPathBody;
import org.mockserver.socket.PortFactory;
import org.mockserver.verify.VerificationTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClientServerIntegrationTest {
    public static final String TEXT_PLAIN = MediaType.create((String)"text", (String)"plain").toString();
    protected static MockServerClient mockServerClient;
    protected static String servletContext;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<String> headersToIgnore = Arrays.asList("server", "expires", "date", "host", "connection", "user-agent", "content-length", "accept-encoding", "transfer-encoding");
    private NettyHttpClient httpClient = new NettyHttpClient();

    public abstract int getMockServerPort();

    public abstract int getMockServerSecurePort();

    public abstract int getTestServerPort();

    protected String calculatePath(String path) {
        return "/" + path;
    }

    @Before
    public void resetServer() {
        mockServerClient.reset();
    }

    @Test
    public void shouldForwardRequestInHTTP() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(this.getTestServerPort())));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldForwardRequestInHTTPS() {
        int testServerHttpsPort = PortFactory.findFreePort();
        EchoServer secureEchoServer = new EchoServer(testServerHttpsPort, true);
        try {
            mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo"))).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(testServerHttpsPort)).withScheme(HttpForward.Scheme.HTTPS));
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("an_example_body_http"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
            Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("an_example_body_https"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
        }
        finally {
            secureEchoServer.stop();
        }
    }

    @Test
    public void shouldAllowSimultaneousForwardAndResponseExpectations() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("echo")), Times.once()).forward(HttpForward.forward().withHost("127.0.0.1").withPort(Integer.valueOf(this.getTestServerPort())));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), Times.once()).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("an_example_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("echo")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("test_headers_and_body")), this.headersToIgnore));
    }

    @Test
    public void shouldCallbackToSpecifiedClassWithPrecannedResponse() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("callback"))).callback(HttpCallback.callback().withCallbackClass("org.mockserver.integration.callback.PrecannedTestExpectationCallback"));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_http"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withHeaders(new Header[]{Header.header((String)"x-callback", (String[])new String[]{"test_callback_header"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withBody("a_callback_response"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("callback")).withMethod("POST").withHeaders(new Header[]{Header.header((String)"x-test", (String[])new String[]{"test_headers_and_body"})}).withBody("an_example_body_https"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseWithOnlyBody() {
        mockServerClient.when(HttpRequest.request()).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseForRequestInSsl() {
        mockServerClient.when(HttpRequest.request().withSecure(Boolean.valueOf(true))).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseForRequestNotInSsl() {
        mockServerClient.when(HttpRequest.request().withSecure(Boolean.valueOf(false))).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnMatchRequestWithBodyInUTF16() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when(HttpRequest.request().withBody(body, Charsets.UTF_16)).respond(HttpResponse.response().withBody(body, Charsets.UTF_8));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")).withBody(body, Charsets.UTF_16), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")).withBody(body, Charsets.UTF_16), this.headersToIgnore));
    }

    @Test
    public void shouldReturnMatchRequestWithBodyInUTF16WithContentTypeHeader() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when(HttpRequest.request().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withBody(body)).respond(HttpResponse.response().withBody(body, Charsets.UTF_8));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withPath(this.calculatePath("")).withBody(body), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")).withBody(body), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseWithBodyInUTF8() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when(HttpRequest.request()).respond(HttpResponse.response().withBody(body, Charsets.UTF_16));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_16).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_16).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseWithBodyInUTF16WithContentTypeHeader() {
        String body = "\u6211\u8bf4\u4e2d\u56fd\u8bdd";
        mockServerClient.when(HttpRequest.request()).respond(HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withBody(body));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_8).toString()}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody(body), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseWithOnlyStatusCode() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_path"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(200)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void shouldVerifyReceivedRequests() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)1));
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)2));
    }

    @Test
    public void shouldVerifyReceivedRequestInSsl() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some.*path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(false))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(false)), VerificationTimes.exactly((int)1));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true)), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true)), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyReceivedRequestsWithNoBody() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response());
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request().withPath(this.calculatePath("some_path"))});
        mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)1));
    }

    @Test
    public void shouldVerifyNotEnoughRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.atLeast((int)2));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least 2 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyTooManyRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")), VerificationTimes.exactly((int)0));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 0 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoMatchingRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_other_path")), VerificationTimes.exactly((int)2));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found exactly 2 times, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_other_path") + "\"" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifyNoMatchingRequestsReceivedInSsl() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some.*path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_path")).withSecure(Boolean.valueOf(true)), VerificationTimes.atLeast((int)1));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least once, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator") + "  \"secure\" : true" + System.getProperty("line.separator") + "}> but was:<{" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(true)), this.headersToIgnore));
        try {
            mockServerClient.verify(HttpRequest.request().withPath(this.calculatePath("some_secure_path")).withSecure(Boolean.valueOf(false)), VerificationTimes.atLeast((int)1));
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request not found at least once, expected:<{" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_secure_path") + "\"," + System.getProperty("line.separator") + "  \"secure\" : false" + System.getProperty("line.separator") + "}> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void shouldVerifySequenceOfRequestsReceivedIncludingThoseNotMatchingAnException() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)4)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.notFoundResponse().withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("not_found")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.notFoundResponse().withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("not_found")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found"))});
        mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_one")), HttpRequest.request((String)this.calculatePath("not_found")), HttpRequest.request((String)this.calculatePath("some_path_three"))});
    }

    @Test
    public void shouldVerifySequenceOfRequestsNotReceived() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path.*")), Times.exactly((int)6)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_one")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_two")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response((String)"some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path_three")), this.headersToIgnore));
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_two")), HttpRequest.request((String)this.calculatePath("some_path_one"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + System.getProperty("line.separator") + "}, {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_three")), HttpRequest.request((String)this.calculatePath("some_path_two"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_three") + "\"" + System.getProperty("line.separator") + "}, {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_two") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
        try {
            mockServerClient.verify(new HttpRequest[]{HttpRequest.request((String)this.calculatePath("some_path_four"))});
            Assert.fail();
        }
        catch (AssertionError ae) {
            Assert.assertThat((Object)((Throwable)((Object)ae)).getMessage(), (Matcher)StringStartsWith.startsWith((String)("Request sequence not found, expected:<[ {" + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_four") + "\"" + System.getProperty("line.separator") + "} ]> but was:<[ {" + System.getProperty("line.separator") + "  \"method\" : \"GET\"," + System.getProperty("line.separator") + "  \"path\" : \"" + this.calculatePath("some_path_one") + "\"," + System.getProperty("line.separator"))));
        }
    }

    @Test
    public void shouldReturnResponseByMatchingPath() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathExactTimes() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseWhenTimeToLiveHasNotExpired() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2), TimeToLive.exactly((TimeUnit)TimeUnit.HOURS, (Long)1L)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithXPath() {
        mockServerClient.when(HttpRequest.request().withBody((Body)XPathBody.xpath((String)"/bookstore/book[price>30]/price")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "  <book category=\"COOKING\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "    <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>30.00</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"CHILDREN\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "    <author>J K. Rowling</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>29.99</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"WEB\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "    <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "    <year>2003</year>" + System.getProperty("line.separator") + "    <price>31.95</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "</bookstore>")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "  <book category=\"COOKING\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "    <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>30.00</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"CHILDREN\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "    <author>J K. Rowling</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>29.99</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"WEB\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "    <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "    <year>2003</year>" + System.getProperty("line.separator") + "    <price>31.95</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "</bookstore>")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJson() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra ignored field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra ignored array\": [\"one\", \"two\"]," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithCharsetUTF8() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"), (Charset)Charsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"), (Charset)Charsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c3\u03b5\u03b9\u03c1\u03ac\": [\"\u03ad\u03bd\u03b1\u03c2\", \"\u03b4\u03c5\u03bf\"]," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"), (Charset)Charsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithContentTypeHeader() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"), (Charset)Charsets.UTF_16, (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_16).toString()}).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c4\u03bf\u03bc\u03ad\u03b1\": \"\u03ba\u03ac\u03c0\u03bf\u03b9\u03b1 \u03b1\u03be\u03af\u03b1\"," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"))), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withHeader("Content-Type", new String[]{MediaType.create((String)"text", (String)"plain").withCharset(Charsets.UTF_16).toString()}).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"\u03c4\u03b1\u03c5\u03c4\u03cc\u03c4\u03b7\u03c4\u03b1\": 1," + System.getProperty("line.separator") + "    \"\u03b5\u03c0\u03b9\u03c0\u03bb\u03ad\u03bf\u03bd \u03b1\u03b3\u03bd\u03bf\u03bf\u03cd\u03bd\u03c4\u03b1\u03b9 \u03c3\u03b5\u03b9\u03c1\u03ac\": [\"\u03ad\u03bd\u03b1\u03c2\", \"\u03b4\u03c5\u03bf\"]," + System.getProperty("line.separator") + "    \"\u03cc\u03bd\u03bf\u03bc\u03b1\": \"\u03bc\u03b9\u03b1 \u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03b7 \u03c0\u03cc\u03c1\u03c4\u03b1\"," + System.getProperty("line.separator") + "    \"\u03c4\u03b9\u03bc\u03ae\": 12.50," + System.getProperty("line.separator") + "    \"\u03b5\u03c4\u03b9\u03ba\u03ad\u03c4\u03b5\u03c2\": [\"\u03c3\u03c0\u03af\u03c4\u03b9\", \"\u03c0\u03c1\u03ac\u03c3\u03b9\u03bd\u03bf\u03c2\"]" + System.getProperty("line.separator") + "}"))), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonWithMatchType() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), (MatchType)MatchType.ONLY_MATCHING_FIELDS)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withBody("some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withBody("some_body").withHeader("Content-Type", new String[]{TEXT_PLAIN}), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingBodyWithJsonSchema() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + System.getProperty("line.separator") + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + System.getProperty("line.separator") + "    \"title\": \"Product\"," + System.getProperty("line.separator") + "    \"description\": \"A product from Acme's catalog\"," + System.getProperty("line.separator") + "    \"type\": \"object\"," + System.getProperty("line.separator") + "    \"properties\": {" + System.getProperty("line.separator") + "        \"id\": {" + System.getProperty("line.separator") + "            \"description\": \"The unique identifier for a product\"," + System.getProperty("line.separator") + "            \"type\": \"integer\"" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"name\": {" + System.getProperty("line.separator") + "            \"description\": \"Name of the product\"," + System.getProperty("line.separator") + "            \"type\": \"string\"" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"price\": {" + System.getProperty("line.separator") + "            \"type\": \"number\"," + System.getProperty("line.separator") + "            \"minimum\": 0," + System.getProperty("line.separator") + "            \"exclusiveMinimum\": true" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"tags\": {" + System.getProperty("line.separator") + "            \"type\": \"array\"," + System.getProperty("line.separator") + "            \"items\": {" + System.getProperty("line.separator") + "                \"type\": \"string\"" + System.getProperty("line.separator") + "            }," + System.getProperty("line.separator") + "            \"minItems\": 1," + System.getProperty("line.separator") + "            \"uniqueItems\": true" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }," + System.getProperty("line.separator") + "    \"required\": [\"id\", \"name\", \"price\"]" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnPDFResponseByMatchingPath() throws IOException {
        byte[] pdfBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/document/[0-9]+\\.pdf"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withMethod("GET"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withMethod("GET"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnPNGResponseByMatchingPath() throws IOException {
        byte[] pngBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/[0-9]+/icon/[0-9]+\\.png"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withMethod("GET"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withMethod("GET"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnPDFResponseByMatchingBinaryPDFBody() throws IOException {
        byte[] pdfBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.pdf"));
        mockServerClient.when(HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pdfBytes))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withBody((Body)BinaryBody.binary((byte[])pdfBytes)).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.pdf\"; filename=\"test.pdf\""}), Header.header((String)"Cache-Control", (String[])new String[]{"must-revalidate, post-check=0, pre-check=0"}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PDF.toString()})}).withBody((Body)BinaryBody.binary((byte[])pdfBytes)), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("ws/rest/user/1/document/2.pdf")).withBody((Body)BinaryBody.binary((byte[])pdfBytes)).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnPNGResponseByMatchingBinaryPNGBody() throws IOException {
        byte[] pngBytes = IOUtils.toByteArray((InputStream)this.getClass().getClassLoader().getResourceAsStream("test.png"));
        mockServerClient.when(HttpRequest.request().withBody((Body)BinaryBody.binary((byte[])pngBytes))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()}), Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withBody((Body)BinaryBody.binary((byte[])pngBytes)).withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withHeaders(new Header[]{Header.header((String)"Content-Disposition", (String[])new String[]{"form-data; name=\"test.png\"; filename=\"test.png\""}), Header.header((String)"Content-Type", (String[])new String[]{MediaType.PNG.toString()})}).withBody((Body)BinaryBody.binary((byte[])pngBytes)), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("ws/rest/user/1/icon/1.png")).withBody((Body)BinaryBody.binary((byte[])pngBytes)).withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseForExpectationWithDelay() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1").withDelay(new Delay(TimeUnit.MILLISECONDS, 10L)));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2").withDelay(new Delay(TimeUnit.MILLISECONDS, 20L)));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body1"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethod() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingPathWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withPath(NottableString.not((String)this.calculatePath("some_path")))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_other_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_other_path")), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingMethodWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod(NottableString.not((String)"GET"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST"), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndBody() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndHeaders() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne_One", "requestHeaderValueOne_Two"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndCookies() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"requestCookieNameOne=requestCookieValueOne; requestCookieNameTwo=requestCookieValueTwo"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"responseCookieNameOne", (String)"responseCookieValueOne"), Cookie.cookie((String)"responseCookieNameTwo", (String)"responseCookieValueTwo")}).withHeaders(new Header[]{Header.header((String)"Set-Cookie", (String[])new String[]{"responseCookieNameOne=responseCookieValueOne", "responseCookieNameTwo=responseCookieValueTwo"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"requestCookieNameOne=requestCookieValueOne; requestCookieNameTwo=requestCookieValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParametersAndBodyParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterName", (String[])new String[]{"bodyParameterValue"})})), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndQueryStringParametersAndBody() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndBodyParameters() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByMatchingPathAndMethodAndParametersAndHeadersAndCookies() {
        mockServerClient.when(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"}), Header.header((String)"Cookie", (String[])new String[]{"cookieNameRequest=cookieValueRequest"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}).withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"}), Header.header((String)"Set-Cookie", (String[])new String[]{"cookieNameResponse=cookieValueResponse"}), Header.header((String)"Content-Type", (String[])new String[]{TEXT_PLAIN})}), (Object)this.makeRequest(HttpRequest.request().withMethod("PUT").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingBodyParameterWithNotOperatorForNameAndValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&OTHERBodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"OTHER Parameter One Value One", "OTHER Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=OTHER Parameter+One+Value+One&bodyParameterOneName=OTHER Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingBodyParameterWithNotOperatorForName() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.string((String)"Parameter One Value One"), NottableString.string((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&OTHERBodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingBodyParameterWithNotOperatorForValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.string((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"OTHER Parameter One Value One", "OTHER Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=OTHER Parameter+One+Value+One&bodyParameterOneName=OTHER Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForNameAndValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"OTHER Parameter One Value One", "OTHER Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForName() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.string((String)"Parameter One Value One"), NottableString.string((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingQueryStringParameterWithNotOperatorForValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.string((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"OTHER Parameter One Value One", "OTHER Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForNameAndValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.not((String)"requestCookieNameOne"), (NottableString)NottableString.not((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"OTHERrequestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"OTHERrequestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForName() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.not((String)"requestCookieNameOne"), (NottableString)NottableString.string((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"OTHERrequestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingCookieWithNotOperatorForValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.string((String)"requestCookieNameOne"), (NottableString)NottableString.not((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"OTHERrequestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForNameAndValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.not((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"OTHERrequestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"OTHERrequestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForName() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.not((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.string((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"OTHERrequestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void shouldReturnResponseByNotMatchingHeaderWithNotOperatorForValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.string((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"OTHERrequestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForWhenTimeToLiveExpired() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path")), Times.exactly((int)2), TimeToLive.exactly((TimeUnit)TimeUnit.SECONDS, (Long)5L)).respond(HttpResponse.response().withBody("some_body").withDelay(TimeUnit.SECONDS, 5L));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBody() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_other_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_other_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingBodyWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withBody((Body)Not.not((Not)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}")))), Times.exactly((int)2)).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra_ignored_field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra_ignored_array\": [\"one\", \"two\"]," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingXPathBody() {
        mockServerClient.when(HttpRequest.request().withBody((Body)new XPathBody("/bookstore/book[price>35]/price")), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "  <book category=\"COOKING\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "    <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>30.00</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"CHILDREN\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "    <author>J K. Rowling</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>29.99</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"WEB\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "    <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "    <year>2003</year>" + System.getProperty("line.separator") + "    <price>31.95</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "</bookstore>")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody((Body)new StringBody("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + System.getProperty("line.separator") + "<bookstore>" + System.getProperty("line.separator") + "  <book category=\"COOKING\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Everyday Italian</title>" + System.getProperty("line.separator") + "    <author>Giada De Laurentiis</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>30.00</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"CHILDREN\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Harry Potter</title>" + System.getProperty("line.separator") + "    <author>J K. Rowling</author>" + System.getProperty("line.separator") + "    <year>2005</year>" + System.getProperty("line.separator") + "    <price>29.99</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "  <book category=\"WEB\">" + System.getProperty("line.separator") + "    <title lang=\"en\">Learning XML</title>" + System.getProperty("line.separator") + "    <author>Erik T. Ray</author>" + System.getProperty("line.separator") + "    <year>2003</year>" + System.getProperty("line.separator") + "    <price>31.95</price>" + System.getProperty("line.separator") + "  </book>" + System.getProperty("line.separator") + "</bookstore>")), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonBody() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"---- XXXX WRONG VALUE XXXX ----\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"---- XXXX WRONG VALUE XXXX ----\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonBodyWithMatchType() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonBody.json((String)("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), (MatchType)MatchType.STRICT)), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"extra field\": \"some value\"," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingJsonSchema() {
        mockServerClient.when(HttpRequest.request().withBody((Body)JsonSchemaBody.jsonSchema((String)("{" + System.getProperty("line.separator") + "    \"$schema\": \"http://json-schema.org/draft-04/schema#\"," + System.getProperty("line.separator") + "    \"title\": \"Product\"," + System.getProperty("line.separator") + "    \"description\": \"A product from Acme's catalog\"," + System.getProperty("line.separator") + "    \"type\": \"object\"," + System.getProperty("line.separator") + "    \"properties\": {" + System.getProperty("line.separator") + "        \"id\": {" + System.getProperty("line.separator") + "            \"description\": \"The unique identifier for a product\"," + System.getProperty("line.separator") + "            \"type\": \"integer\"" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"name\": {" + System.getProperty("line.separator") + "            \"description\": \"Name of the product\"," + System.getProperty("line.separator") + "            \"type\": \"string\"" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"price\": {" + System.getProperty("line.separator") + "            \"type\": \"number\"," + System.getProperty("line.separator") + "            \"minimum\": 0," + System.getProperty("line.separator") + "            \"exclusiveMinimum\": true" + System.getProperty("line.separator") + "        }," + System.getProperty("line.separator") + "        \"tags\": {" + System.getProperty("line.separator") + "            \"type\": \"array\"," + System.getProperty("line.separator") + "            \"items\": {" + System.getProperty("line.separator") + "                \"type\": \"string\"" + System.getProperty("line.separator") + "            }," + System.getProperty("line.separator") + "            \"minItems\": 1," + System.getProperty("line.separator") + "            \"uniqueItems\": true" + System.getProperty("line.separator") + "        }" + System.getProperty("line.separator") + "    }," + System.getProperty("line.separator") + "    \"required\": [\"id\", \"name\", \"price\"]" + System.getProperty("line.separator") + "}"))), Times.exactly((int)2)).respond(HttpResponse.response().withBody("some_body"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"wrong field name\": \"A green door\"," + System.getProperty("line.separator") + "    \"price\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withMethod("POST").withBody("{" + System.getProperty("line.separator") + "    \"id\": 1," + System.getProperty("line.separator") + "    \"name\": \"A green door\"," + System.getProperty("line.separator") + "    \"wrong field name\": 12.50," + System.getProperty("line.separator") + "    \"tags\": [\"home\", \"green\"]" + System.getProperty("line.separator") + "}"), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingPath() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_other_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_other_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingPathWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withPath(NottableString.not((String)this.calculatePath("some_path")))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path")), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingMethodWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod(NottableString.not((String)"GET"))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET"), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET"), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBodyParameterName() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"OTHERBodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("OTHERBodyParameterOneName=Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingBodyParameterWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"bodyParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingBodyParameterValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})}))).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)ParameterBody.params((Parameter[])new Parameter[]{Parameter.param((String)"bodyParameterOneName", (String[])new String[]{"Other Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"bodyParameterTwoName", (String[])new String[]{"Parameter Two"})})).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withBody((Body)new StringBody("bodyParameterOneName=Other Parameter+One+Value+One&bodyParameterOneName=Parameter+One+Value+Two&bodyParameterTwoName=Parameter+Two")).withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingQueryStringParameterName() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"OTHERQueryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingQueryStringParameterValue() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest")).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response").withHeaders(new Header[]{Header.header((String)"headerNameResponse", (String[])new String[]{"headerValueResponse"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameResponse", (String)"cookieValueResponse")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"OTHERqueryStringParameterOneValueOne", "queryStringParameterOneValueTwo"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody("some_bodyRequest").withHeaders(new Header[]{Header.header((String)"headerNameRequest", (String[])new String[]{"headerValueRequest"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieNameRequest", (String)"cookieValueRequest")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingQueryStringParameterWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((NottableString)NottableString.not((String)"queryStringParameterOneName"), (NottableString[])new NottableString[]{NottableString.not((String)"Parameter One Value One"), NottableString.not((String)"Parameter One Value Two")}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("POST").withPath(this.calculatePath("some_pathRequest")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"Parameter One Value One", "Parameter One Value Two"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"Parameter Two"})}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingCookieName() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieOtherName", (String)"cookieValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieOtherName", (String)"cookieValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingCookieValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieOtherValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieOtherValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingCookieWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((NottableString)NottableString.not((String)"requestCookieNameOne"), (NottableString)NottableString.not((String)"requestCookieValueOne")), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withCookies(new Cookie[]{Cookie.cookie((String)"requestCookieNameOne", (String)"requestCookieValueOne"), Cookie.cookie((String)"requestCookieNameTwo", (String)"requestCookieValueTwo")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingHeaderName() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerOtherName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerOtherName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForNonMatchingHeaderValue() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body").withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerOtherValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path")).withQueryStringParameters(new Parameter[]{Parameter.param((String)"queryStringParameterOneName", (String[])new String[]{"queryStringParameterOneValue"}), Parameter.param((String)"queryStringParameterTwoName", (String[])new String[]{"queryStringParameterTwoValue"})}).withBody((Body)StringBody.exact((String)"some_body")).withHeaders(new Header[]{Header.header((String)"headerName", (String[])new String[]{"headerOtherValue"})}).withCookies(new Cookie[]{Cookie.cookie((String)"cookieName", (String)"cookieValue")}), this.headersToIgnore));
    }

    @Test
    public void shouldNotReturnResponseForMatchingHeaderWithNotOperator() {
        mockServerClient.when(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((NottableString)NottableString.not((String)"requestHeaderNameOne"), (NottableString[])new NottableString[]{NottableString.not((String)"requestHeaderValueOne")}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})})).respond(HttpResponse.response().withStatusCode(Integer.valueOf(HttpStatusCode.ACCEPTED_202.code())).withBody("some_body_response"));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withMethod("GET").withPath(this.calculatePath("some_pathRequest")).withHeaders(new Header[]{Header.header((String)"requestHeaderNameOne", (String[])new String[]{"requestHeaderValueOne"}), Header.header((String)"requestHeaderNameTwo", (String[])new String[]{"requestHeaderValueTwo"})}), this.headersToIgnore));
    }

    @Test
    public void shouldClearExpectations() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        mockServerClient.clear(HttpRequest.request().withPath(this.calculatePath("some_path1")));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.OK_200.code())).withBody("some_body2"), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
    }

    @Test
    public void shouldReset() {
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path1"))).respond(HttpResponse.response().withBody("some_body1"));
        mockServerClient.when(HttpRequest.request().withPath(this.calculatePath("some_path2"))).respond(HttpResponse.response().withBody("some_body2"));
        mockServerClient.reset();
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withPath(this.calculatePath("some_path2")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path1")), this.headersToIgnore));
        Assert.assertEquals((Object)HttpResponse.response().withHeader("Content-Type", new String[]{TEXT_PLAIN}).withStatusCode(Integer.valueOf(HttpStatusCode.NOT_FOUND_404.code())), (Object)this.makeRequest(HttpRequest.request().withSecure(Boolean.valueOf(true)).withPath(this.calculatePath("some_path2")), this.headersToIgnore));
    }

    @Test
    public void shouldEnsureThatRequestDelaysDoNotAffectOtherRequests() throws Exception {
        mockServerClient.when(HttpRequest.request((String)"/slow")).respond(HttpResponse.response((String)"super slow").withDelay(new Delay(TimeUnit.SECONDS, 8L)));
        mockServerClient.when(HttpRequest.request((String)"/fast")).respond(HttpResponse.response((String)"quite fast"));
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Future<Long> slowFuture = executorService.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                long start = System.currentTimeMillis();
                AbstractClientServerIntegrationTest.this.makeRequest(HttpRequest.request((String)"/slow"));
                return System.currentTimeMillis() - start;
            }
        });
        Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
        Future<Long> fastFuture = executorService.submit(new Callable<Long>(){

            @Override
            public Long call() throws Exception {
                long start = System.currentTimeMillis();
                AbstractClientServerIntegrationTest.this.makeRequest(HttpRequest.request((String)"/fast"));
                return System.currentTimeMillis() - start;
            }
        });
        Long slowRequestElapsedMillis = slowFuture.get();
        Long fastRequestElapsedMillis = fastFuture.get();
        Assert.assertThat((String)"Slow request takes less than expected", (Object)slowRequestElapsedMillis, (Matcher)Is.is((Matcher)OrderingComparison.greaterThan((Comparable)Long.valueOf(7000L))));
        Assert.assertThat((String)"Fast request takes longer than expected", (Object)fastRequestElapsedMillis, (Matcher)Is.is((Matcher)Matchers.lessThan((Comparable)Long.valueOf(3000L))));
    }

    protected HttpResponse makeRequest(HttpRequest httpRequest) {
        return this.makeRequest(httpRequest, Collections.<String>emptySet());
    }

    protected HttpResponse makeRequest(HttpRequest httpRequest, Collection<String> headersToIgnore) {
        int attemptsRemaining = 10;
        while (attemptsRemaining > 0) {
            try {
                boolean isSsl = httpRequest.isSecure() != null && httpRequest.isSecure() != false;
                int port = isSsl ? this.getMockServerSecurePort() : this.getMockServerPort();
                HttpResponse httpResponse = this.httpClient.sendRequest(OutboundHttpRequest.outboundRequest((String)"localhost", (int)port, (String)servletContext, (HttpRequest)httpRequest));
                ArrayList<Header> headers = new ArrayList<Header>();
                for (Header header : httpResponse.getHeaders()) {
                    if (headersToIgnore.contains(header.getName().getValue().toLowerCase())) continue;
                    if (header.getName().getValue().equalsIgnoreCase("Content-Type")) {
                        for (NottableString value : new ArrayList(header.getValues())) {
                            header.getValues().clear();
                            header.addValues(new String[]{value.getValue().replace(";charset", "; charset")});
                        }
                    }
                    headers.add(header);
                }
                httpResponse.withHeaders(headers);
                return httpResponse;
            }
            catch (SocketConnectionException caught) {
                this.logger.info("Retrying connection to mock server, attempts remaining: " + --attemptsRemaining);
                try {
                    TimeUnit.MILLISECONDS.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
        }
        throw new RuntimeException("Failed to send request:" + System.getProperty("line.separator") + httpRequest);
    }

    static {
        servletContext = "";
    }
}

