/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.Block;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.rx.client.AggregateObservable;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.ObservableHelper;
import com.mongodb.rx.client.RxObservables;
import com.mongodb.rx.client.Success;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.Subscriber;
import rx.Subscription;

class AggregateObservableImpl<TResult>
implements AggregateObservable<TResult> {
    private final AggregateIterable<TResult> wrapped;
    private final ObservableAdapter observableAdapter;

    AggregateObservableImpl(AggregateIterable<TResult> wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (AggregateIterable)Assertions.notNull((String)"wrapped", wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public AggregateObservable<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.wrapped.allowDiskUse(allowDiskUse);
        return this;
    }

    @Override
    public AggregateObservable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        this.wrapped.maxTime(maxTime, timeUnit);
        return this;
    }

    @Override
    public AggregateObservable<TResult> useCursor(Boolean useCursor) {
        this.wrapped.useCursor(useCursor);
        return this;
    }

    @Override
    public AggregateObservable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.wrapped.bypassDocumentValidation(bypassDocumentValidation);
        return this;
    }

    @Override
    public Observable<Success> toCollection() {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                AggregateObservableImpl.this.wrapped.toCollection(ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<TResult> toObservable() {
        return RxObservables.create(Observables.observe(this.wrapped), this.observableAdapter);
    }

    @Override
    public Subscription subscribe(Subscriber<? super TResult> subscriber) {
        return this.toObservable().subscribe(subscriber);
    }
}

