/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.rx.client.ListCollectionsObservable;
import com.mongodb.rx.client.MongoCollection;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.Success;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import rx.Observable;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public ObservableAdapter getObservableAdapter();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public ReadConcern getReadConcern();

    public MongoDatabase withObservableAdapter(ObservableAdapter var1);

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoDatabase withReadConcern(ReadConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public Observable<Document> runCommand(Bson var1);

    public Observable<Document> runCommand(Bson var1, ReadPreference var2);

    public <TResult> Observable<TResult> runCommand(Bson var1, Class<TResult> var2);

    public <TResult> Observable<TResult> runCommand(Bson var1, ReadPreference var2, Class<TResult> var3);

    public Observable<Success> drop();

    public Observable<String> listCollectionNames();

    public ListCollectionsObservable<Document> listCollections();

    public <TResult> ListCollectionsObservable<TResult> listCollections(Class<TResult> var1);

    public Observable<Success> createCollection(String var1);

    public Observable<Success> createCollection(String var1, CreateCollectionOptions var2);
}

