/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.rx.client;

import com.mongodb.Block;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.async.client.Observables;
import com.mongodb.client.model.CreateCollectionOptions;
import com.mongodb.rx.client.ListCollectionsObservable;
import com.mongodb.rx.client.ListCollectionsObservableImpl;
import com.mongodb.rx.client.MongoCollection;
import com.mongodb.rx.client.MongoCollectionImpl;
import com.mongodb.rx.client.MongoDatabase;
import com.mongodb.rx.client.ObservableAdapter;
import com.mongodb.rx.client.ObservableHelper;
import com.mongodb.rx.client.RxObservables;
import com.mongodb.rx.client.Success;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import rx.Observable;

class MongoDatabaseImpl
implements MongoDatabase {
    private final com.mongodb.async.client.MongoDatabase wrapped;
    private final ObservableAdapter observableAdapter;

    MongoDatabaseImpl(com.mongodb.async.client.MongoDatabase wrapped, ObservableAdapter observableAdapter) {
        this.wrapped = (com.mongodb.async.client.MongoDatabase)Assertions.notNull((String)"wrapped", (Object)wrapped);
        this.observableAdapter = (ObservableAdapter)Assertions.notNull((String)"observableAdapter", (Object)observableAdapter);
    }

    @Override
    public String getName() {
        return this.wrapped.getName();
    }

    @Override
    public ObservableAdapter getObservableAdapter() {
        return this.observableAdapter;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.wrapped.getCodecRegistry();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public MongoDatabase withObservableAdapter(ObservableAdapter observableAdapter) {
        return new MongoDatabaseImpl(this.wrapped, observableAdapter);
    }

    @Override
    public MongoDatabase withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoDatabaseImpl(this.wrapped.withCodecRegistry(codecRegistry), this.observableAdapter);
    }

    @Override
    public MongoDatabase withReadPreference(ReadPreference readPreference) {
        return new MongoDatabaseImpl(this.wrapped.withReadPreference(readPreference), this.observableAdapter);
    }

    @Override
    public MongoDatabase withWriteConcern(WriteConcern writeConcern) {
        return new MongoDatabaseImpl(this.wrapped.withWriteConcern(writeConcern), this.observableAdapter);
    }

    @Override
    public MongoDatabase withReadConcern(ReadConcern readConcern) {
        return new MongoDatabaseImpl(this.wrapped.withReadConcern(readConcern), this.observableAdapter);
    }

    @Override
    public MongoCollection<Document> getCollection(String collectionName) {
        return this.getCollection(collectionName, Document.class);
    }

    @Override
    public <TDocument> MongoCollection<TDocument> getCollection(String collectionName, Class<TDocument> clazz) {
        return new MongoCollectionImpl(this.wrapped.getCollection(collectionName, clazz), this.observableAdapter);
    }

    @Override
    public Observable<Document> runCommand(Bson command) {
        return this.runCommand(command, Document.class);
    }

    @Override
    public Observable<Document> runCommand(Bson command, ReadPreference readPreference) {
        return this.runCommand(command, readPreference, Document.class);
    }

    @Override
    public <TResult> Observable<TResult> runCommand(final Bson command, final Class<TResult> clazz) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TResult>>(){

            public void apply(SingleResultCallback<TResult> callback) {
                MongoDatabaseImpl.this.wrapped.runCommand(command, clazz, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public <TResult> Observable<TResult> runCommand(final Bson command, final ReadPreference readPreference, final Class<TResult> clazz) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<TResult>>(){

            public void apply(SingleResultCallback<TResult> callback) {
                MongoDatabaseImpl.this.wrapped.runCommand(command, readPreference, clazz, callback);
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<Success> drop() {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.drop(ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }

    @Override
    public Observable<String> listCollectionNames() {
        return RxObservables.create(Observables.observe((MongoIterable)this.wrapped.listCollectionNames()), this.observableAdapter);
    }

    @Override
    public ListCollectionsObservable<Document> listCollections() {
        return this.listCollections((Class)Document.class);
    }

    public <C> ListCollectionsObservable<C> listCollections(Class<C> clazz) {
        return new ListCollectionsObservableImpl(this.wrapped.listCollections(clazz), this.observableAdapter);
    }

    @Override
    public Observable<Success> createCollection(String collectionName) {
        return this.createCollection(collectionName, new CreateCollectionOptions());
    }

    @Override
    public Observable<Success> createCollection(final String collectionName, final CreateCollectionOptions options) {
        return RxObservables.create(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                MongoDatabaseImpl.this.wrapped.createCollection(collectionName, options, ObservableHelper.voidToSuccessCallback(callback));
            }
        }), this.observableAdapter);
    }
}

