/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.util.HashMap;
import org.mortbay.jetty.plus.annotation.LifeCycleCallback;
import org.mortbay.jetty.plus.annotation.PostConstructCallback;
import org.mortbay.jetty.plus.annotation.PreDestroyCallback;
import org.mortbay.log.Log;

public class LifeCycleCallbackCollection {
    private HashMap postConstructCallbacksMap = new HashMap();
    private HashMap preDestroyCallbacksMap = new HashMap();

    public void add(LifeCycleCallback callback) {
        if (callback == null || callback.getClassName() == null || callback.getTarget() == null) {
            return;
        }
        Log.debug((String)("Adding callback for class=" + callback.getClassName() + " of type " + callback.getClass().getName()));
        HashMap map = null;
        if (callback instanceof PreDestroyCallback) {
            map = this.preDestroyCallbacksMap;
        }
        if (callback instanceof PostConstructCallback) {
            map = this.postConstructCallbacksMap;
        }
        if (map == null) {
            throw new IllegalArgumentException("Unsupported lifecycle callback type: " + callback);
        }
        LifeCycleCallback existing = (LifeCycleCallback)map.get(callback.getClassName());
        if (existing != null) {
            throw new IllegalStateException("Callback already registered for class " + callback.getClassName() + " on method " + existing.getTarget().getName());
        }
        map.put(callback.getClassName(), callback);
    }

    public void callPostConstructCallback(Object o) throws Exception {
        if (o == null) {
            return;
        }
        LifeCycleCallback callback = (LifeCycleCallback)this.postConstructCallbacksMap.get(o.getClass().getName());
        Log.debug((String)("Got callback=" + callback + " for class: " + o.getClass().getName()));
        if (callback == null) {
            return;
        }
        callback.callback(o);
    }

    public void callPreDestroyCallback(Object o) {
        if (o == null) {
            return;
        }
        PreDestroyCallback callback = (PreDestroyCallback)this.preDestroyCallbacksMap.get(o.getClass().getName());
        Log.debug((String)("Got callback=" + callback + " for class: " + o.getClass().getName()));
        if (callback == null) {
            return;
        }
        callback.callback(o);
    }
}

