/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.btree.impl.singlevalue;

import org.neodatis.btree.IBTree;
import org.neodatis.btree.IBTreeNode;
import org.neodatis.btree.exception.BTreeException;
import org.neodatis.btree.impl.singlevalue.BTreeNodeSingleValuePerKey;

public class InMemoryBTreeNodeSingleValuePerkey
extends BTreeNodeSingleValuePerKey {
    protected static int nextId = 1;
    protected Integer id = new Integer(nextId++);
    protected IBTreeNode[] children;
    protected IBTreeNode parent;

    public InMemoryBTreeNodeSingleValuePerkey(IBTree btree) {
        super(btree);
    }

    public IBTreeNode getChildAt(int index, boolean throwExceptionIfNotExist) {
        if (this.children[index] == null && throwExceptionIfNotExist) {
            throw new BTreeException("Trying to load null child node at index " + index);
        }
        return this.children[index];
    }

    public IBTreeNode getParent() {
        return this.parent;
    }

    public void setChildAt(IBTreeNode child, int index) {
        this.children[index] = child;
        if (child != null) {
            child.setParent(this);
        }
    }

    public void setChildAt(IBTreeNode node, int childIndex, int index, boolean throwExceptionIfDoesNotExist) {
        IBTreeNode child;
        this.children[index] = child = node.getChildAt(childIndex, throwExceptionIfDoesNotExist);
        if (child != null) {
            child.setParent(this);
        }
    }

    public void setParent(IBTreeNode node) {
        this.parent = node;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    protected void init() {
        this.children = new IBTreeNode[this.maxNbChildren];
    }

    public Object getId() {
        return this.id;
    }

    public void setId(Object id) {
        this.id = (Integer)id;
    }

    public void deleteChildAt(int index) {
        this.children[index] = null;
        --this.nbChildren;
    }

    public void moveChildFromTo(int sourceIndex, int destinationIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[sourceIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + sourceIndex);
        }
        this.children[destinationIndex] = this.children[sourceIndex];
    }

    public void setNullChildAt(int childIndex) {
        this.children[childIndex] = null;
    }

    public Object getChildIdAt(int childIndex, boolean throwExceptionIfDoesNotExist) {
        if (this.children[childIndex] == null && throwExceptionIfDoesNotExist) {
            throw new BTreeException("Trying to move null child node at index " + childIndex);
        }
        return this.children[childIndex].getId();
    }

    public Object getParentId() {
        return this.id;
    }

    public Object getValueAsObjectAt(int index) {
        return this.getValueAt(index);
    }
}

