/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.criteria;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.query.IQuery;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.odb.impl.core.layers.layer2.meta.compare.AttributeValueComparator;

public class ComparisonCriterion
extends AbstractCriterion {
    public static final int COMPARISON_TYPE_GT = 1;
    public static final int COMPARISON_TYPE_GE = 2;
    public static final int COMPARISON_TYPE_LT = 3;
    public static final int COMPARISON_TYPE_LE = 4;
    private Object criterionValue;
    private int comparisonType;

    public ComparisonCriterion(String attributeName, String criterionValue, int comparisonType) {
        super(attributeName);
        this.criterionValue = criterionValue;
    }

    public ComparisonCriterion(String attributeName, int value, int comparisonType) {
        super(attributeName);
        this.init(new Integer(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, short value, int comparisonType) {
        super(attributeName);
        this.init(new Short(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, byte value, int comparisonType) {
        super(attributeName);
        this.init(new Byte(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, float value, int comparisonType) {
        super(attributeName);
        this.init(new Float(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, double value, int comparisonType) {
        super(attributeName);
        this.init(new Double(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, long value, int comparisonType) {
        super(attributeName);
        this.init(new Long(value), comparisonType);
    }

    public ComparisonCriterion(String attributeName, Object value, int comparisonType) {
        super(attributeName);
        this.init(value, comparisonType);
    }

    protected void init(Object value, int comparisonType) {
        this.criterionValue = value;
        this.comparisonType = comparisonType;
    }

    public ComparisonCriterion(String attributeName, boolean value, int comparisonType) {
        super(attributeName);
        this.init(value ? Boolean.TRUE : Boolean.FALSE, comparisonType);
    }

    public boolean match(Object valueToMatch) {
        if (valueToMatch == null && this.criterionValue == null) {
            return true;
        }
        AttributeValuesMap attributeValues = null;
        if (valueToMatch instanceof AttributeValuesMap) {
            attributeValues = (AttributeValuesMap)valueToMatch;
            valueToMatch = attributeValues.getAttributeValue(this.attributeName);
        }
        if (valueToMatch == null) {
            return false;
        }
        if (!(valueToMatch instanceof Comparable)) {
            throw new ODBRuntimeException(NeoDatisError.QUERY_COMPARABLE_CRITERIA_APPLIED_ON_NON_COMPARABLE.addParameter(valueToMatch.getClass().getName()));
        }
        Comparable comparable1 = (Comparable)valueToMatch;
        Comparable comparable2 = (Comparable)this.criterionValue;
        switch (this.comparisonType) {
            case 1: {
                return valueToMatch != null && AttributeValueComparator.compare(comparable1, comparable2) > 0.0;
            }
            case 2: {
                return valueToMatch != null && AttributeValueComparator.compare(comparable1, comparable2) >= 0.0;
            }
            case 3: {
                return valueToMatch != null && AttributeValueComparator.compare(comparable1, comparable2) < 0.0;
            }
            case 4: {
                return valueToMatch != null && AttributeValueComparator.compare(comparable1, comparable2) <= 0.0;
            }
        }
        throw new ODBRuntimeException(NeoDatisError.QUERY_UNKNOWN_OPERATOR.addParameter(this.comparisonType));
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.attributeName).append(" ").append(this.getOperator()).append(" ").append(this.criterionValue);
        return buffer.toString();
    }

    private String getOperator() {
        switch (this.comparisonType) {
            case 1: {
                return ">";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<";
            }
            case 4: {
                return "<=";
            }
        }
        return "?";
    }

    public AttributeValuesMap getValues() {
        AttributeValuesMap map = new AttributeValuesMap();
        map.put(this.attributeName, this.criterionValue);
        return map;
    }

    public void setQuery(IQuery query) {
        super.setQuery(query);
        this.getQuery().setOptimizeObjectComparison(false);
    }

    public void ready() {
    }
}

