/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.core.query.execution;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoIndex;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.query.ComposedCompareKey;
import org.neodatis.odb.core.query.SimpleCompareKey;
import org.neodatis.odb.impl.core.query.criteria.CriteriaQuery;
import org.neodatis.tool.wrappers.OdbComparable;

public class IndexTool {
    public static OdbComparable buildIndexKey(String indexName, NonNativeObjectInfo oi, int[] fieldIds) {
        OdbComparable[] keys = new OdbComparable[fieldIds.length];
        AbstractObjectInfo aoi = null;
        Comparable o = null;
        for (int i = 0; i < fieldIds.length; ++i) {
            try {
                aoi = oi.getAttributeValueFromId(fieldIds[i]);
                o = (Comparable)aoi.getObject();
                if (o == null && aoi.isNative()) {
                    String attributeName = oi.getClassInfo().getAttributeInfoFromId(fieldIds[i]).getName();
                    String desc = oi.toString();
                    throw new ODBRuntimeException(NeoDatisError.ERROR_WHILE_COMPUTING_KEY_FOR_INDEX_NULL_FIELD.addParameter(attributeName).addParameter(indexName).addParameter(desc));
                }
                if (aoi.getOdbType().isBoolean()) {
                    Boolean b = (Boolean)o;
                    o = b != false ? new Byte(1) : new Byte(0);
                }
                if (aoi.isNonNativeObject()) {
                    NonNativeObjectInfo nnoi = (NonNativeObjectInfo)aoi;
                    o = nnoi.getOid();
                }
                keys[i] = new SimpleCompareKey(o);
                continue;
            }
            catch (ODBRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                if (e instanceof ODBRuntimeException) continue;
                throw new ODBRuntimeException(NeoDatisError.INDEX_KEYS_MUST_IMPLEMENT_COMPARABLE.addParameter(fieldIds[i]).addParameter(oi.getAttributeValueFromId(fieldIds[i]).getClass().getName()), (Throwable)e);
            }
        }
        if (keys.length == 1) {
            return keys[0];
        }
        return new ComposedCompareKey(keys);
    }

    public static OdbComparable buildIndexKey(String indexName, AttributeValuesMap values, String[] fields) {
        if (fields.length == 1) {
            return new SimpleCompareKey(values.getComparable(fields[0]));
        }
        OdbComparable[] keys = new OdbComparable[fields.length];
        Comparable object = null;
        for (int i = 0; i < fields.length; ++i) {
            try {
                object = (Comparable)values.get(fields[i]);
                if (object instanceof Boolean) {
                    Boolean b = (Boolean)object;
                    object = b != false ? new Byte(1) : new Byte(0);
                }
                keys[i] = new SimpleCompareKey(object);
                continue;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.INDEX_KEYS_MUST_IMPLEMENT_COMPARABLE.addParameter(indexName).addParameter(fields[i]).addParameter(values.get(fields[i]).getClass().getName()));
            }
        }
        ComposedCompareKey key = new ComposedCompareKey(keys);
        return key;
    }

    public static OdbComparable computeKey(ClassInfo ci, ClassInfoIndex index, CriteriaQuery query) {
        String[] attributesNames = ci.getAttributeNames(index.getAttributeIds());
        AttributeValuesMap values = query.getCriteria().getValues();
        return IndexTool.buildIndexKey(index.getName(), values, attributesNames);
    }
}

