/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassAttributeInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.tool.wrappers.map.OdbHashMap;

public class ObjectInfoUtil {
    public static List buildAttributeNameList(ClassInfo ci) {
        return ObjectInfoUtil.buildAttributeNameList(null, ci, null, null);
    }

    private static List buildAttributeNameList(String attributeName, ClassInfo ci, String base, Map objectsAlreadyVisited) {
        boolean firstTime;
        ArrayList<String> result = new ArrayList<String>();
        boolean bl = firstTime = objectsAlreadyVisited == null;
        if (objectsAlreadyVisited == null) {
            objectsAlreadyVisited = new OdbHashMap<ClassAttributeInfo, ClassAttributeInfo>();
        }
        String baseClassName = null;
        baseClassName = base == null ? "" : (base.length() == 0 ? attributeName : base + "." + attributeName);
        for (int i = 0; i < ci.getAttributes().size(); ++i) {
            ClassAttributeInfo cai = ci.getAttributeInfo(i);
            if (objectsAlreadyVisited.get(cai) != null && !cai.getAttributeType().isNative()) {
                result.add("<-");
                continue;
            }
            objectsAlreadyVisited.put(cai, cai);
            if (cai.getAttributeType().isNative()) {
                String localAttributeName = (baseClassName.length() == 0 ? "" : baseClassName + ".") + cai.getName();
                result.add(localAttributeName);
                continue;
            }
            result.addAll(ObjectInfoUtil.buildAttributeNameList(cai.getName(), cai.getClassInfo(), baseClassName, objectsAlreadyVisited));
        }
        return result;
    }

    private static List buildAttributeTypeList(ClassInfo ci, String base, Map objectsAlreadyVisited) {
        boolean firstTime;
        ArrayList<String> result = new ArrayList<String>();
        boolean bl = firstTime = objectsAlreadyVisited == null;
        if (objectsAlreadyVisited == null) {
            objectsAlreadyVisited = new OdbHashMap<ClassAttributeInfo, ClassAttributeInfo>();
        }
        String baseClassName = null;
        baseClassName = base == null ? "" : (base.length() == 0 ? ci.getFullClassName() : base + "." + ci.getFullClassName().toLowerCase());
        for (int i = 0; i < ci.getAttributes().size(); ++i) {
            ClassAttributeInfo cai = ci.getAttributeInfo(i);
            if (objectsAlreadyVisited.get(cai) != null) continue;
            objectsAlreadyVisited.put(cai, cai);
            if (cai.getAttributeType().isNative()) {
                String attributeName = (baseClassName.length() == 0 ? "" : baseClassName + ".") + cai.getName();
                result.add(attributeName);
                continue;
            }
            result.addAll(ObjectInfoUtil.buildAttributeNameList(cai.getName(), cai.getClassInfo(), baseClassName, objectsAlreadyVisited));
        }
        return result;
    }

    public static List buildValueList(ClassInfo ci, Collection list) {
        return ObjectInfoUtil.buildValueList(ci, list, null);
    }

    private static List buildValueList(ClassInfo ci, Collection list, Map objectsAlreadyVisited) {
        boolean firstTime;
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> oneLine = null;
        int nbLines = list.size();
        boolean bl = firstTime = objectsAlreadyVisited == null;
        if (objectsAlreadyVisited == null) {
            objectsAlreadyVisited = new OdbHashMap<AbstractObjectInfo, AbstractObjectInfo>();
        }
        OdbHashMap otherMap = null;
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object element;
            if (firstTime) {
                objectsAlreadyVisited = new OdbHashMap();
            }
            if ((element = iterator.next()) instanceof NonNativeObjectInfo) {
                NonNativeObjectInfo nnoi = (NonNativeObjectInfo)element;
                oneLine = new ArrayList<Object>();
                if (nnoi == null || nnoi.isNull()) {
                    oneLine.addAll(ObjectInfoUtil.nullNonNativeObject(ci, null));
                    continue;
                }
                for (int j = 0; j < nnoi.getAttributeValues().length; ++j) {
                    Collection<AbstractObjectInfo> l;
                    AbstractObjectInfo object = nnoi.getAttributeValues()[j];
                    if (objectsAlreadyVisited.get(object) != null) {
                        oneLine.addAll(ObjectInfoUtil.manageNullOrRecursiveObjectInfo(nnoi.getClassInfo().getAttributeInfo(j), "@"));
                        continue;
                    }
                    objectsAlreadyVisited.put(object, object);
                    if (object instanceof NonNativeObjectInfo) {
                        NonNativeObjectInfo oi = (NonNativeObjectInfo)object;
                        if (oi instanceof NonNativeNullObjectInfo) {
                            oneLine.addAll(ObjectInfoUtil.nullNonNativeObject(ci, null));
                            continue;
                        }
                        if (oi.isDeletedObject()) {
                            oneLine.add("Deleted Object");
                            continue;
                        }
                        l = Arrays.asList(oi.getAttributeValues());
                        otherMap = new OdbHashMap(objectsAlreadyVisited);
                        oneLine.addAll(ObjectInfoUtil.buildValueList(oi.getClassInfo(), l, objectsAlreadyVisited));
                        continue;
                    }
                    if (object instanceof NonNativeNullObjectInfo) {
                        oneLine.addAll(ObjectInfoUtil.manageNullOrRecursiveObjectInfo(nnoi.getClassInfo().getAttributeInfo(j), "null"));
                        continue;
                    }
                    if (object == null) {
                        oneLine.add(null);
                        continue;
                    }
                    ODBType type = ODBType.getFromClass(object.getClass());
                    if (type.isCollection()) {
                        l = (Collection)((Object)object);
                        oneLine.add("[" + l.size() + "]:" + ObjectInfoUtil.buildValueList(null, l, objectsAlreadyVisited));
                        continue;
                    }
                    oneLine.add(object);
                }
                if (firstTime) {
                    result.add(oneLine);
                } else {
                    result.addAll(oneLine);
                }
            } else if (element != null) {
                ODBType type = ODBType.getFromClass(element.getClass());
                if (type.isCollection()) {
                    Collection l = (Collection)element;
                    result.add("[" + l.size() + "]:" + ObjectInfoUtil.buildValueList(null, l, objectsAlreadyVisited));
                } else if (element instanceof NonNativeNullObjectInfo) {
                    if (ci != null) {
                        result.addAll(ObjectInfoUtil.manageNullOrRecursiveObjectInfo(ci.getAttributeInfo(i), "null"));
                    } else {
                        result.add(null);
                    }
                } else {
                    result.add(element);
                }
            } else {
                result.add(null);
            }
            ++i;
        }
        return result;
    }

    private static Collection nullNonNativeObject(ClassInfo ci, Map alreadySet) {
        ArrayList<String> l = new ArrayList<String>();
        if (alreadySet == null) {
            alreadySet = new OdbHashMap<String, String>();
        }
        ClassAttributeInfo cai = null;
        String attributeId = null;
        for (int i = 0; i < ci.getNumberOfAttributes(); ++i) {
            cai = ci.getAttributeInfo(i);
            if (cai.getAttributeType().isNative()) {
                l.add("null");
                continue;
            }
            attributeId = ci.getFullClassName() + "." + cai.getName();
            if (alreadySet.get(attributeId) != null) {
                l.add("<-");
                continue;
            }
            alreadySet.put(attributeId, attributeId);
            l.addAll(ObjectInfoUtil.nullNonNativeObject(cai.getClassInfo(), alreadySet));
        }
        return l;
    }

    private static List manageNullOrRecursiveObjectInfo(ClassAttributeInfo cai, String item) {
        ArrayList<Object> list = new ArrayList<Object>();
        if (cai.getAttributeType().isNative()) {
            list.add(new NullNativeObjectInfo(cai.getAttributeType()));
        } else {
            int numberOfNullsToInsert = cai.getClassInfo().getAttributes().size();
            for (int k = 0; k < numberOfNullsToInsert; ++k) {
                list.add(item);
            }
        }
        return list;
    }
}

