/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.layers.layer1.introspector;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer1.introspector.IClassIntrospector;
import org.neodatis.odb.core.layers.layer1.introspector.IIntrospectionCallback;
import org.neodatis.odb.core.layers.layer1.introspector.IObjectIntrospector;
import org.neodatis.odb.core.layers.layer2.instance.IClassPool;
import org.neodatis.odb.core.layers.layer2.meta.AbstractObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ArrayObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.AtomicNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfoList;
import org.neodatis.odb.core.layers.layer2.meta.CollectionObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.EnumNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MapObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.NativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeNullObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.NullNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.layers.layer2.meta.ObjectReference;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.tool.wrappers.OdbReflection;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalObjectIntrospector
implements IObjectIntrospector {
    protected IStorageEngine storageEngine;
    protected IClassIntrospector classIntrospector;
    private IClassPool classPool;

    public LocalObjectIntrospector(IStorageEngine storageEngine) {
        this.storageEngine = storageEngine;
        this.classIntrospector = OdbConfiguration.getCoreProvider().getClassIntrospector();
        this.classPool = OdbConfiguration.getCoreProvider().getClassPool();
    }

    @Override
    public AbstractObjectInfo getMetaRepresentation(Object object, ClassInfo ci, boolean recursive, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        return this.getObjectInfo(object, ci, recursive, alreadyReadObjects, callback);
    }

    protected AbstractObjectInfo getObjectInfo(Object object, ClassInfo ci, boolean recursive, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        return this.getObjectInfoInternal(null, object, ci, recursive, alreadyReadObjects, callback);
    }

    protected AbstractObjectInfo getNativeObjectInfoInternal(ODBType type, Object object, boolean recursive, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        NativeObjectInfo aoi = null;
        if (type.isAtomicNative()) {
            aoi = object == null ? new NullNativeObjectInfo(type.getId()) : new AtomicNativeObjectInfo(object, type.getId());
        } else if (type.isCollection()) {
            aoi = this.introspectCollection((Collection)object, recursive, alreadyReadObjects, type, callback);
        } else if (type.isArray()) {
            if (object == null) {
                aoi = new ArrayObjectInfo(null);
            } else {
                String realArrayClassName = object.getClass().getComponentType().getName();
                ArrayObjectInfo aroi = null;
                aroi = recursive ? this.introspectArray(object, recursive, alreadyReadObjects, type, callback) : new ArrayObjectInfo((Object[])object);
                aroi.setRealArrayComponentClassName(realArrayClassName);
                aoi = aroi;
            }
        } else if (type.isMap()) {
            if (object == null) {
                aoi = new MapObjectInfo(null, type, type.getDefaultInstanciationClass().getName());
            } else {
                MapObjectInfo moi = null;
                String realMapClassName = object.getClass().getName();
                moi = new MapObjectInfo(this.introspectMap((Map)object, recursive, alreadyReadObjects, callback), type, realMapClassName);
                if (realMapClassName.indexOf("$") != -1) {
                    moi.setRealMapClassName(type.getDefaultInstanciationClass().getName());
                }
                aoi = moi;
            }
        } else if (type.isEnum()) {
            Enum enumObject = (Enum)object;
            if (enumObject == null) {
                aoi = new NullNativeObjectInfo(type.getSize());
            } else {
                String enumClassName = enumObject == null ? null : enumObject.getClass().getName();
                ClassInfo ci = this.getClassInfo(enumClassName);
                String enumValue = enumObject == null ? null : enumObject.name();
                aoi = new EnumNativeObjectInfo(ci, enumValue);
            }
        }
        return aoi;
    }

    protected AbstractObjectInfo getObjectInfoInternal(AbstractObjectInfo nnoi, Object object, ClassInfo ci, boolean recursive, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        Object value = null;
        if (object == null) {
            return NullNativeObjectInfo.getInstance();
        }
        Class<?> clazz = object.getClass();
        ODBType type = ODBType.getFromClass(clazz);
        String className = clazz.getName();
        if (type.isNative()) {
            return this.getNativeObjectInfoInternal(type, object, recursive, alreadyReadObjects, callback);
        }
        if (ci != null && !clazz.getName().equals(ci.getFullClassName())) {
            ci = this.getClassInfo(className);
            nnoi = null;
        }
        NonNativeObjectInfo mainAoi = (NonNativeObjectInfo)nnoi;
        boolean isRootObject = false;
        if (alreadyReadObjects == null) {
            alreadyReadObjects = new OdbHashMap<Object, NonNativeObjectInfo>();
            isRootObject = true;
        }
        if (object != null) {
            NonNativeObjectInfo cachedNnoi = alreadyReadObjects.get(object);
            if (cachedNnoi != null) {
                ObjectReference or = new ObjectReference(cachedNnoi);
                return or;
            }
            if (callback != null) {
                callback.objectFound(object);
            }
        }
        if (mainAoi == null) {
            mainAoi = this.buildNnoi(object, ci, null, null, null, alreadyReadObjects);
        }
        alreadyReadObjects.put(object, mainAoi);
        IOdbList<Field> fields = this.classIntrospector.getAllFields(className);
        AbstractObjectInfo aoi = null;
        int attributeId = -1;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            try {
                value = field.get(object);
                attributeId = ci.getAttributeId(field.getName());
                if (field.getType() == Class.class && value != null) {
                    value.toString();
                }
                if (attributeId == -1) {
                    throw new ODBRuntimeException(NeoDatisError.OBJECT_INTROSPECTOR_NO_FIELD_WITH_NAME.addParameter(ci.getFullClassName()).addParameter(field.getName()));
                }
                ODBType valueType = null;
                valueType = value == null ? ODBType.getFromClass(field.getType()) : ODBType.getFromClass(value.getClass());
                if (valueType.isNative()) {
                    aoi = this.getNativeObjectInfoInternal(valueType, value, recursive, alreadyReadObjects, callback);
                    mainAoi.setAttributeValue(attributeId, aoi);
                    continue;
                }
                ClassInfo clai = this.getClassInfo(valueType.getName());
                if (value == null) {
                    aoi = new NonNativeNullObjectInfo(clai);
                    mainAoi.setAttributeValue(attributeId, aoi);
                    continue;
                }
                if (recursive) {
                    aoi = this.getObjectInfoInternal(null, value, clai, recursive, alreadyReadObjects, callback);
                    mainAoi.setAttributeValue(attributeId, aoi);
                    continue;
                }
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("Should not enter here - ObjectIntrospector - 'simply add the object'"));
            }
            catch (IllegalArgumentException e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in getObjectInfoInternal"), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("getObjectInfoInternal"), (Throwable)e);
            }
        }
        if (isRootObject) {
            alreadyReadObjects.clear();
            alreadyReadObjects = null;
        }
        return mainAoi;
    }

    @Override
    public NonNativeObjectInfo buildNnoi(Object object, ClassInfo classInfo, AbstractObjectInfo[] values, long[] attributesIdentification, int[] attributeIds, Map<Object, NonNativeObjectInfo> alreadyReadObjects) {
        ISession session;
        ICache cache;
        OID oid;
        NonNativeObjectInfo nnoi = new NonNativeObjectInfo(object, classInfo, values, attributesIdentification, attributeIds);
        if (this.storageEngine != null && (oid = (cache = (session = this.storageEngine.getSession(true)).getCache()).getOid(object, false)) != null) {
            nnoi.setOid(oid);
            ObjectInfoHeader oih = cache.getObjectInfoHeaderFromOid(oid, false);
            if (oih == null && session.hasBeenCommitted()) {
                oih = this.storageEngine.getObjectReader().readObjectInfoHeaderFromOid(oid, false);
            }
            if (oih == null) {
                throw new ODBRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
            }
            nnoi.getHeader().setObjectVersion(oih.getObjectVersion());
            nnoi.getHeader().setUpdateDate(oih.getUpdateDate());
            nnoi.getHeader().setCreationDate(oih.getCreationDate());
        }
        return nnoi;
    }

    private CollectionObjectInfo introspectCollection(Collection collection, boolean introspect, Map<Object, NonNativeObjectInfo> alreadyReadObjects, ODBType type, IIntrospectionCallback callback) {
        if (collection == null) {
            return new CollectionObjectInfo();
        }
        ArrayList<AbstractObjectInfo> collectionCopy = new ArrayList<AbstractObjectInfo>(collection.size());
        ArrayList<NonNativeObjectInfo> nonNativesObjects = new ArrayList<NonNativeObjectInfo>(collection.size());
        AbstractObjectInfo aoi = null;
        for (Object o : collection) {
            ClassInfo ci = null;
            if (o == null) continue;
            ci = this.getClassInfo(o.getClass().getName());
            aoi = this.getObjectInfo(o, ci, introspect, alreadyReadObjects, callback);
            collectionCopy.add(aoi);
            if (!aoi.isNonNativeObject()) continue;
            nonNativesObjects.add((NonNativeObjectInfo)aoi);
        }
        CollectionObjectInfo coi = new CollectionObjectInfo(collectionCopy, nonNativesObjects);
        String realCollectionClassName = collection.getClass().getName();
        if (realCollectionClassName.indexOf("$") != -1) {
            coi.setRealCollectionClassName(type.getDefaultInstanciationClass().getName());
        } else {
            coi.setRealCollectionClassName(realCollectionClassName);
        }
        return coi;
    }

    private Map<AbstractObjectInfo, AbstractObjectInfo> introspectMap(Map map, boolean introspect, Map<Object, NonNativeObjectInfo> alreadyReadObjects, IIntrospectionCallback callback) {
        OdbHashMap<AbstractObjectInfo, AbstractObjectInfo> mapCopy = new OdbHashMap<AbstractObjectInfo, AbstractObjectInfo>();
        Set keySet = map.keySet();
        Iterator keys = keySet.iterator();
        ClassInfo ciKey = null;
        ClassInfo ciValue = null;
        AbstractObjectInfo aoiForKey = null;
        AbstractObjectInfo aoiForValue = null;
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = map.get(key);
            if (key == null) continue;
            ciKey = this.getClassInfo(key.getClass().getName());
            if (value != null) {
                ciValue = this.getClassInfo(value.getClass().getName());
            }
            aoiForKey = this.getObjectInfo(key, ciKey, introspect, alreadyReadObjects, callback);
            aoiForValue = this.getObjectInfo(value, ciValue, introspect, alreadyReadObjects, callback);
            mapCopy.put(aoiForKey, aoiForValue);
        }
        return mapCopy;
    }

    private ClassInfo getClassInfo(String fullClassName) {
        if (ODBType.getFromName(fullClassName).isNative()) {
            return null;
        }
        ISession session = this.storageEngine.getSession(true);
        MetaModel metaModel = session.getMetaModel();
        if (metaModel.existClass(fullClassName)) {
            return metaModel.getClassInfo(fullClassName, true);
        }
        ClassInfo ci = null;
        ClassInfoList ciList = null;
        ciList = this.classIntrospector.introspect(fullClassName, true);
        if (this.storageEngine != null) {
            this.storageEngine.addClasses(ciList);
            if (!this.storageEngine.isLocal()) {
                metaModel = session.getMetaModel();
            }
        } else {
            metaModel.addClasses(ciList);
        }
        ci = metaModel.getClassInfo(fullClassName, true);
        return ci;
    }

    public boolean objectHasChanged(Object object) {
        Class clazz = this.classPool.getClass(object.getClass().getName());
        try {
            Field field = this.classIntrospector.getField(clazz, "hasChanged");
            Object value = field.get(object);
            return (Boolean)value;
        }
        catch (Exception e) {
            throw new ODBRuntimeException(NeoDatisError.INTERNAL_ERROR.addParameter("in objectHasChanged(Object object)"), (Throwable)e);
        }
    }

    private ArrayObjectInfo introspectArray(Object array, boolean introspect, Map<Object, NonNativeObjectInfo> alreadyReadObjects, ODBType valueType, IIntrospectionCallback callback) {
        int length = OdbReflection.getArrayLength(array);
        Class<?> elementType = array.getClass().getComponentType();
        ODBType type = ODBType.getFromClass(elementType);
        if (type.isAtomicNative()) {
            return this.intropectAtomicNativeArray(array, type);
        }
        if (!introspect) {
            return new ArrayObjectInfo((Object[])array);
        }
        Object[] arrayCopy = new Object[length];
        for (int i = 0; i < length; ++i) {
            Object o = OdbReflection.getArrayElement(array, i);
            ClassInfo ci = null;
            if (o != null) {
                ci = this.getClassInfo(o.getClass().getName());
                AbstractObjectInfo aoi = this.getObjectInfo(o, ci, introspect, alreadyReadObjects, callback);
                arrayCopy[i] = aoi;
                continue;
            }
            arrayCopy[i] = new NonNativeNullObjectInfo();
        }
        ArrayObjectInfo arrayOfAoi = new ArrayObjectInfo(arrayCopy, valueType, type.getId());
        return arrayOfAoi;
    }

    private ArrayObjectInfo intropectAtomicNativeArray(Object array, ODBType type) {
        int length = OdbReflection.getArrayLength(array);
        AtomicNativeObjectInfo anoi = null;
        Object[] arrayCopy = new Object[length];
        int typeId = 0;
        for (int i = 0; i < length; ++i) {
            Object o = OdbReflection.getArrayElement(array, i);
            if (o != null) {
                typeId = ODBType.getFromClass(o.getClass()).getId();
                anoi = new AtomicNativeObjectInfo(o, typeId);
                arrayCopy[i] = anoi;
                continue;
            }
            arrayCopy[i] = new NullNativeObjectInfo(type.getId());
        }
        ArrayObjectInfo aoi = new ArrayObjectInfo(arrayCopy, ODBType.ARRAY, type.getId());
        return aoi;
    }

    @Override
    public void clear() {
        this.storageEngine = null;
    }

    @Override
    public IClassIntrospector getClassIntrospector() {
        return this.classIntrospector;
    }
}

