/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.query.criteria;

import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.AttributeValuesMap;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer3.IStorageEngine;
import org.neodatis.odb.core.query.criteria.AbstractCriterion;
import org.neodatis.odb.impl.core.layers.layer2.meta.compare.AttributeValueComparator;
import org.neodatis.tool.wrappers.OdbString;

public class EqualCriterion
extends AbstractCriterion {
    private Object criterionValue;
    private boolean isCaseSensitive;
    private OID oid;
    private boolean objectIsNative;

    public EqualCriterion(String attributeName, int value) {
        super(attributeName);
        this.init(new Integer(value));
    }

    public EqualCriterion(String attributeName, short value) {
        super(attributeName);
        this.init(new Short(value));
    }

    public EqualCriterion(String attributeName, byte value) {
        super(attributeName);
        this.init(new Byte(value));
    }

    public EqualCriterion(String attributeName, float value) {
        super(attributeName);
        this.init(new Float(value));
    }

    public EqualCriterion(String attributeName, double value) {
        super(attributeName);
        this.init(new Double(value));
    }

    public EqualCriterion(String attributeName, long value) {
        super(attributeName);
        this.init(new Long(value));
    }

    public EqualCriterion(String attributeName, Object value) {
        super(attributeName);
        this.init(value);
    }

    protected void init(Object value) {
        this.criterionValue = value;
        this.isCaseSensitive = true;
        this.objectIsNative = this.criterionValue == null ? true : ODBType.isNative(this.criterionValue.getClass());
        if (this.criterionValue != null && this.criterionValue.getClass().isEnum()) {
            Enum enumObject = (Enum)this.criterionValue;
            this.criterionValue = enumObject.name();
            this.objectIsNative = true;
        }
    }

    public EqualCriterion(String attributeName, Object value, boolean isCaseSensitive) {
        super(attributeName);
        this.criterionValue = value;
        this.isCaseSensitive = isCaseSensitive;
    }

    public EqualCriterion(String attributeName, String value, boolean isCaseSensitive) {
        super(attributeName);
        this.criterionValue = value;
        this.isCaseSensitive = isCaseSensitive;
    }

    public EqualCriterion(String attributeName, boolean value) {
        super(attributeName);
        this.init(value ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean match(Object valueToMatch) {
        boolean canUseCaseInsensitive;
        if (valueToMatch instanceof AttributeValuesMap) {
            AttributeValuesMap attributeValues = (AttributeValuesMap)valueToMatch;
            valueToMatch = attributeValues.getAttributeValue(this.attributeName);
        }
        if (valueToMatch == null && this.criterionValue == null && this.oid == null) {
            return true;
        }
        if (this.isCaseSensitive) {
            if (this.objectIsNative) {
                return valueToMatch != null && AttributeValueComparator.equals(valueToMatch, this.criterionValue);
            }
            OID objectOid = null;
            try {
                objectOid = (OID)valueToMatch;
            }
            catch (Exception e) {
                throw new ODBRuntimeException(NeoDatisError.EQUAL_CRITERIA_ON_OBJECT_WITH_WRONG_ATTRIBUTE_TYPE.addParameter(this.toString()).addParameter(this.attributeName).addParameter(valueToMatch.getClass().getName()).addParameter(OdbString.exceptionToString(e, true)));
            }
            if (this.oid == null) {
                return false;
            }
            return this.oid.equals(objectOid);
        }
        boolean bl = canUseCaseInsensitive = this.criterionValue.getClass() == String.class && valueToMatch.getClass() == String.class || this.criterionValue.getClass() == Character.class && valueToMatch.getClass() == Character.class;
        if (!canUseCaseInsensitive) {
            throw new ODBRuntimeException(NeoDatisError.QUERY_ATTRIBUTE_TYPE_NOT_SUPPORTED_IN_IEQUAL_EXPRESSION.addParameter(valueToMatch.getClass().getName()));
        }
        String s1 = (String)valueToMatch;
        String s2 = (String)this.criterionValue;
        return OdbString.equalsIgnoreCase(s1, s2);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.oid != null) {
            buffer.append(this.attributeName).append(" = (Object Id ").append(this.oid).append(")");
        } else {
            buffer.append(this.attributeName).append(" = ").append(this.criterionValue);
        }
        return buffer.toString();
    }

    public AttributeValuesMap getValues() {
        AttributeValuesMap map = new AttributeValuesMap();
        if (this.criterionValue == null && this.oid != null) {
            map.setOid(this.oid);
        } else {
            map.put(this.attributeName, this.criterionValue);
        }
        return map;
    }

    public boolean canUseIndex() {
        return true;
    }

    public void ready() {
        if (!this.objectIsNative) {
            if (this.getQuery() == null) {
                throw new ODBRuntimeException(NeoDatisError.CONTAINS_QUERY_WITH_NO_QUERY);
            }
            IStorageEngine engine = this.getQuery().getStorageEngine();
            if (engine == null) {
                throw new ODBRuntimeException(NeoDatisError.CONTAINS_QUERY_WITH_NO_STORAGE_ENGINE);
            }
            this.oid = engine.getObjectId(this.criterionValue, false);
            this.criterionValue = null;
        }
    }
}

